/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtMavenSdkPaths;

public class JpsGwtDependenciesCache {
    private static final Logger LOG = Logger.getInstance(JpsGwtDependenciesCache.class);
    public static final String GWT_DEPENDENCIES_CACHE_FILE_NAME = "gwt-dependencies.xml";
    protected final File myGwtDependenciesFile;
    protected GwtDependencies myDependencies;

    public JpsGwtDependenciesCache(@NotNull BuildDataPaths buildDataPaths) {
        if (buildDataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDataPaths", "org/jetbrains/jps/gwt/model/impl/sdk/JpsGwtDependenciesCache", "<init>"));
        }
        this(new File(buildDataPaths.getDataStorageRoot(), GWT_DEPENDENCIES_CACHE_FILE_NAME));
    }

    protected JpsGwtDependenciesCache(File gwtDependenciesFile) {
        this.myGwtDependenciesFile = gwtDependenciesFile;
        if (gwtDependenciesFile.exists()) {
            try {
                this.myDependencies = (GwtDependencies)XmlSerializer.deserialize((Element)JDOMUtil.load((File)gwtDependenciesFile), GwtDependencies.class);
            }
            catch (IOException | JDOMException e) {
                LOG.error("Unable to load file " + gwtDependenciesFile.getAbsolutePath(), e);
            }
        }
    }

    @Nullable
    public List<String> getAdditionalCompilerJars(@NotNull GwtMavenSdkPaths sdkPaths) throws GwtDependenciesFileNotFoundException {
        if (sdkPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPaths", "org/jetbrains/jps/gwt/model/impl/sdk/JpsGwtDependenciesCache", "getAdditionalCompilerJars"));
        }
        String version = sdkPaths.getVersion();
        if (this.myDependencies == null) {
            throw new GwtDependenciesFileNotFoundException(version);
        }
        Set<String> dependencies = this.myDependencies.myGwtDevDependenciesMap.get(version);
        if (dependencies == null) {
            return null;
        }
        ArrayList jars = ContainerUtil.newArrayList();
        for (String dependency : dependencies) {
            String[] triplet = dependency.split(":");
            ContainerUtil.addIfNotNull((Collection)jars, (Object)sdkPaths.getArtifactPath(triplet[0], triplet[1], triplet[2]));
        }
        ContainerUtil.addIfNotNull((Collection)jars, (Object)sdkPaths.getArtifactPath("javax.validation", "validation-api", null));
        return jars;
    }

    @Tag(value="maven-dependencies")
    public static class GwtDependencies {
        @Tag(value="gwt-dev")
        @MapAnnotation(keyAttributeName="version", surroundKeyWithTag=false, surroundValueWithTag=false, surroundWithTag=false)
        public Map<String, Set<String>> myGwtDevDependenciesMap = ContainerUtil.newHashMap();
    }

    public static class GwtDependenciesFileNotFoundException
    extends Exception {
        public GwtDependenciesFileNotFoundException(String version) {
            super(String.format("Dependencies of GWT %s SDK weren't computed accurately so classpath of GWT application may be incorrect. Reimport the project from Maven to actualize dependencies of GWT SDK.", version));
        }
    }
}

