/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc;

import java.util.ArrayList;
import java.util.Collection;

public class LinkageType {
    private static final Collection<LinkageType> all = new ArrayList<LinkageType>();
    public static final LinkageType Default = new LinkageType("Default", "Default", "");
    public static final LinkageType Merged = new LinkageType("Merged", "Merged into code", "Merged");
    public static final LinkageType RSL = new LinkageType("Runtime", "Runtime shared library", "RSL");
    public static final LinkageType External = new LinkageType("External", "External", "External");
    public static final LinkageType Include = new LinkageType("Include", "Include", "Include");
    public static final LinkageType LoadInRuntime = new LinkageType("Loaded", "Loaded at runtime", "Loaded");
    public static final LinkageType Test = new LinkageType("Test", "Test", "Test");
    private static final LinkageType[] SWC_LINKAGE_VALUES = new LinkageType[]{Merged, External, Include, Test};
    private final String myLongText;
    private final String myShortText;
    private final String mySerializedText;

    public String getSerializedText() {
        return this.mySerializedText;
    }

    public String getLongText() {
        return this.myLongText;
    }

    public String getShortText() {
        return this.myShortText;
    }

    private LinkageType(String serializedText, String longText, String shortText) {
        this.myLongText = longText;
        this.mySerializedText = serializedText;
        this.myShortText = shortText;
        all.add(this);
    }

    public String toString() {
        return this.getShortText();
    }

    public static LinkageType valueOf(String linkageType, LinkageType defaultValue) {
        for (LinkageType type : all) {
            if (!type.getSerializedText().equals(linkageType)) continue;
            return type;
        }
        return defaultValue;
    }

    public static LinkageType[] getSwcLinkageValues() {
        return SWC_LINKAGE_VALUES;
    }
}

