/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.osgi.jps.build.OsgiBuildSession;
import org.jetbrains.osgi.jps.build.OsmorcBuildTarget;
import org.jetbrains.osgi.jps.build.OsmorcBuildTargetType;

public class OsmorcBuilder
extends TargetBuilder<BuildRootDescriptor, OsmorcBuildTarget> {
    public static final String ID = "osgi";

    public OsmorcBuilder() {
        super(Collections.singletonList(OsmorcBuildTargetType.INSTANCE));
    }

    @NotNull
    public String getPresentableName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuilder", "getPresentableName"));
        }
        return ID;
    }

    public void build(@NotNull OsmorcBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, OsmorcBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/osgi/jps/build/OsmorcBuilder", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/osgi/jps/build/OsmorcBuilder", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/osgi/jps/build/OsmorcBuilder", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/osgi/jps/build/OsmorcBuilder", "build"));
        }
        if (target.getExtension().isAlwaysRebuildBundleJar() || JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context) || holder.hasDirtyFiles() || holder.hasRemovedFiles()) {
            new OsgiBuildSession().build(target, context);
        }
    }
}

