/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.sdk.JpsFlexSdkType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.service.SharedThreadPool;

public class JpsBuiltInFlexCompilerHandler {
    private static final Logger LOG = Logger.getInstance((String)JpsBuiltInFlexCompilerHandler.class.getName());
    private static final String CONNECTION_SUCCESSFUL = "Connection successful";
    public static final String COMPILATION_FINISHED = "Compilation finished";
    private final JpsProject myProject;
    private String mySdkHome;
    private ServerSocket myServerSocket;
    private DataInputStream myDataInputStream;
    private DataOutputStream myDataOutputStream;
    private int commandNumber = 1;
    private Map<String, Listener> myActiveListeners = new THashMap();

    JpsBuiltInFlexCompilerHandler(JpsProject project) {
        this.myProject = project;
    }

    public synchronized boolean canBeUsedForSdk(String sdkHome) {
        return this.mySdkHome == null || this.mySdkHome.equals(sdkHome);
    }

    public synchronized void startCompilerIfNeeded(JpsSdk<?> sdk, CompileContext context, String compilerName) throws IOException {
        if (!Comparing.equal((String)sdk.getHomePath(), (String)this.mySdkHome)) {
            this.stopCompilerProcess();
        }
        if (this.myServerSocket == null) {
            try {
                this.myServerSocket = new ServerSocket(0);
                this.myServerSocket.setSoTimeout(10000);
                int port = this.myServerSocket.getLocalPort();
                this.startCompilerProcess(sdk, port, context, compilerName);
                Socket socket = this.myServerSocket.accept();
                this.myDataInputStream = new DataInputStream(socket.getInputStream());
                this.myDataOutputStream = new DataOutputStream(socket.getOutputStream());
                this.mySdkHome = sdk.getHomePath();
                this.scheduleInputReading();
            }
            catch (IOException e) {
                this.stopCompilerProcess();
                throw e;
            }
        }
    }

    private void startCompilerProcess(JpsSdk<?> sdk, int port, CompileContext context, String compilerName) throws IOException {
        StringBuilder classpath = new StringBuilder();
        classpath.append(FlexCommonUtils.getPathToBundledJar("idea-flex-compiler-fix.jar"));
        classpath.append(File.pathSeparatorChar);
        classpath.append(FlexCommonUtils.getPathToBundledJar("flex-compiler.jar"));
        if (sdk.getSdkType() == JpsFlexSdkType.INSTANCE) {
            classpath.append(File.pathSeparator).append(FileUtil.toSystemDependentName((String)(sdk.getHomePath() + "/lib/flex-compiler-oem.jar")));
        }
        List<String> commandLine = FlexCommonUtils.getCommandLineForSdkTool(this.myProject, sdk, classpath.toString(), "com.intellij.flex.compiler.FlexCompiler");
        commandLine.add(String.valueOf(port));
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(FlexCommonUtils.getFlexCompilerWorkDirPath(this.myProject)));
        String plainCommand = StringUtil.join(processBuilder.command(), s -> s.contains(" ") ? "\"" + s + "\"" : s, (String)" ");
        context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.INFO, "Starting Flex compiler:\n" + plainCommand));
        Process process = processBuilder.start();
        this.readInputStreamUntilConnected(process, context, compilerName);
    }

    private void readInputStreamUntilConnected(Process process, CompileContext context, String compilerName) {
        SharedThreadPool.getInstance().executeOnPooledThread(() -> {
            InputStreamReader reader = FlexCommonUtils.createInputStreamReader(process.getInputStream());
            try {
                int read;
                char[] buf = new char[1024];
                while ((read = reader.read(buf, 0, buf.length)) >= 0) {
                    String output = new String(buf, 0, read);
                    if (output.startsWith(CONNECTION_SUCCESSFUL)) {
                        break;
                    }
                    this.closeSocket();
                    context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, output));
                }
            }
            catch (IOException e) {
                this.closeSocket();
                context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, "Failed to start Flex compiler: " + e.toString()));
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        });
    }

    private void scheduleInputReading() {
        SharedThreadPool.getInstance().executeOnPooledThread(() -> {
            DataInputStream dataInputStream;
            StringBuilder buffer = new StringBuilder();
            while ((dataInputStream = this.myDataInputStream) != null) {
                try {
                    int index;
                    buffer.append(dataInputStream.readUTF());
                    while ((index = buffer.indexOf("\n")) > -1) {
                        String line = buffer.substring(0, index);
                        buffer.delete(0, index + 1);
                        this.handleInputLine(line);
                    }
                }
                catch (IOException e) {
                    if (dataInputStream != this.myDataInputStream) break;
                    this.stopCompilerProcess();
                    break;
                }
            }
        });
    }

    private synchronized void handleInputLine(String line) {
        LOG.debug("RECEIVED: [" + line + "]");
        int colonPos = line.indexOf(":");
        if (colonPos <= 0) {
            LOG.error("Incorrect command: [" + line + "]");
            return;
        }
        String prefix = line.substring(0, colonPos + 1);
        Listener listener = this.myActiveListeners.get(prefix);
        if (listener == null) {
            LOG.warn("No active listener for input line: [" + line + "]");
        } else {
            String text = line.substring(colonPos + 1);
            if (text.startsWith(COMPILATION_FINISHED)) {
                listener.compilationFinished();
                this.myActiveListeners.remove(prefix);
            } else {
                listener.textAvailable(text);
            }
        }
    }

    public synchronized void sendCompilationCommand(String command, Listener listener) {
        if (this.myDataOutputStream == null) {
            listener.textAvailable("Error: Compiler process is not started.");
            listener.compilationFinished();
            return;
        }
        try {
            String prefix = String.valueOf(this.commandNumber++) + ":";
            String commandToSend = prefix + command + "\n";
            LOG.debug("SENDING: [" + commandToSend + "]");
            this.myDataOutputStream.writeUTF(commandToSend);
            this.myActiveListeners.put(prefix, listener);
        }
        catch (IOException e) {
            listener.textAvailable("Error: Can't start compilation: " + e.toString());
            listener.compilationFinished();
        }
    }

    private synchronized void cancelAllCompilations(boolean reportError) {
        for (Listener listener : this.myActiveListeners.values()) {
            if (reportError) {
                listener.textAvailable("Error: Compilation terminated");
            }
            listener.compilationFinished();
        }
        this.myActiveListeners.clear();
    }

    public synchronized void stopCompilerProcess() {
        this.cancelAllCompilations(true);
        this.closeSocket();
    }

    private synchronized void closeSocket() {
        if (this.myDataInputStream != null) {
            try {
                this.myDataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.myDataOutputStream != null) {
            try {
                this.myDataOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.myServerSocket != null) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myServerSocket = null;
        this.myDataInputStream = null;
        this.myDataOutputStream = null;
    }

    public synchronized void removeListener(Listener listener) {
        String toRemove = null;
        for (Map.Entry<String, Listener> entry : this.myActiveListeners.entrySet()) {
            if (entry.getValue() != listener) continue;
            toRemove = entry.getKey();
            break;
        }
        if (toRemove != null) {
            this.myActiveListeners.remove(toRemove);
        }
    }

    public synchronized int getActiveCompilationsNumber() {
        return this.myActiveListeners.size();
    }

    public static interface Listener {
        public void textAvailable(String var1);

        public void compilationFinished();
    }
}

