/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.internal;

import com.springsource.util.osgi.manifest.Parameterised;
import com.springsource.util.osgi.manifest.Parseable;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CompoundParseable<T extends Parameterised>
implements Parseable {
    protected final HeaderParser parser;
    protected List<T> components;
    private static final String EMPTY_STRING = "";

    CompoundParseable(HeaderParser parser) {
        this.parser = parser;
        this.components = new ArrayList<T>();
    }

    abstract List<HeaderDeclaration> parse(String var1);

    abstract T newEntry(String var1);

    @Override
    public void resetFromParseString(String parseString) {
        this.components.clear();
        if (parseString != null) {
            List<HeaderDeclaration> headers = this.parse(parseString);
            for (HeaderDeclaration header : headers) {
                for (String name : header.getNames()) {
                    T component = this.newEntry(name);
                    component.getAttributes().putAll(header.getAttributes());
                    component.getDirectives().putAll(header.getDirectives());
                    this.components.add(component);
                }
            }
        }
    }

    @Override
    public String toParseString() {
        if (this.components.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<T> components = this.components.iterator();
        while (components.hasNext()) {
            builder.append(((Parameterised)components.next()).toParseString());
            if (!components.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public String toString() {
        String parseString = this.toParseString();
        if (parseString == null) {
            return EMPTY_STRING;
        }
        return parseString;
    }

    protected T add(String name) {
        T newComponent = this.newEntry(name);
        this.components.add(newComponent);
        return newComponent;
    }
}

