/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.PathUtils;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderExtension;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.ClassPostProcessor;
import org.jetbrains.jps.incremental.java.CustomOutputDataListener;
import org.jetbrains.jps.incremental.java.ExternalJavacOptionsProvider;
import org.jetbrains.jps.incremental.java.OutputFilesSink;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.javac.JpsInfoDiagnostic;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.SharedThreadPool;

public class JavaBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.java.JavaBuilder");
    private static final String JAVA_EXTENSION = "java";
    public static final String BUILDER_NAME = "java";
    public static final Key<Boolean> IS_ENABLED = Key.create((String)"_java_compiler_enabled_");
    public static final FileFilter JAVA_SOURCES_FILTER = FileFilters.withExtension((String)"java");
    private static final Key<Integer> JAVA_COMPILER_VERSION_KEY = GlobalContextKey.create("_java_compiler_version_");
    private static final Key<Boolean> PREFER_TARGET_JDK_COMPILER = GlobalContextKey.create("_prefer_target_jdk_javac_");
    private static final Key<JavaCompilingTool> COMPILING_TOOL = Key.create((String)"_java_compiling_tool_");
    private static final Key<ConcurrentMap<String, Collection<String>>> COMPILER_USAGE_STATISTICS = Key.create((String)"_java_compiler_usage_stats_");
    private static final List<String> COMPILABLE_EXTENSIONS = Collections.singletonList("java");
    private static final Set<String> FILTERED_OPTIONS = ContainerUtil.newHashSet((Object[])new String[]{"-target"});
    private static final Set<String> FILTERED_SINGLE_OPTIONS = ContainerUtil.newHashSet((Object[])new String[]{"-g", "-deprecation", "-nowarn", "-verbose", "-proc:none", "-proc:only", "-proceedOnError"});
    private static final List<ClassPostProcessor> ourClassProcessors = new ArrayList<ClassPostProcessor>();
    private static final Set<JpsModuleType<?>> ourCompilableModuleTypes = new HashSet();
    @Nullable
    private static final File ourDefaultRtJar;
    private final Executor myTaskRunner;
    private static final Key<List<String>> JAVAC_OPTIONS;
    private static final Key<List<String>> JAVAC_VM_OPTIONS;
    private static final Key<String> USER_DEFINED_BYTECODE_TARGET;
    private static final Key<TasksCounter> COUNTER_KEY;

    public static void registerClassPostProcessor(ClassPostProcessor processor) {
        ourClassProcessors.add(processor);
    }

    public JavaBuilder(Executor tasksExecutor) {
        super(BuilderCategory.TRANSLATOR);
        this.myTaskRunner = new SequentialTaskExecutor("JavaBuilder pool", tasksExecutor);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if ("java" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/java/JavaBuilder", "getPresentableName"));
        }
        return "java";
    }

    @Override
    public void buildStarted(CompileContext context) {
        String compilerId = JavaBuilder.getUsedCompilerId(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Java compiler ID: " + compilerId);
        }
        JavaCompilingTool compilingTool = JavaBuilderUtil.findCompilingTool(compilerId);
        COMPILING_TOOL.set((UserDataHolder)context, (Object)compilingTool);
        COMPILER_USAGE_STATISTICS.set((UserDataHolder)context, new ConcurrentHashMap());
    }

    @Override
    public void chunkBuildStarted(final CompileContext context, final ModuleChunk chunk) {
        try {
            JavaBuilderUtil.markDirtyDependenciesForInitialRound(context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
                    if (processor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/java/JavaBuilder$1", "processDirtyFiles"));
                    }
                    FSOperations.processFilesToRecompile(context, chunk, processor);
                }
            }, chunk);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void buildFinished(CompileContext context) {
        ConcurrentMap stats = (ConcurrentMap)COMPILER_USAGE_STATISTICS.get((UserDataHolder)context);
        if (stats.size() == 1) {
            Map.Entry entry = stats.entrySet().iterator().next();
            String compilerName = (String)entry.getKey();
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, compilerName + " was used to compile java sources"));
            LOG.info(compilerName + " was used to compile " + entry.getValue());
        } else {
            for (Map.Entry entry : stats.entrySet()) {
                String compilerName = (String)entry.getKey();
                Collection moduleNames = (Collection)entry.getValue();
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, moduleNames.size() == 1 ? compilerName + " was used to compile [" + (String)moduleNames.iterator().next() + "]" : compilerName + " was used to compile " + moduleNames.size() + " modules"));
                LOG.info(compilerName + " was used to compile " + moduleNames);
            }
        }
    }

    @Override
    public List<String> getCompilableFileExtensions() {
        return COMPILABLE_EXTENSIONS;
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/java/JavaBuilder", "build"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/incremental/java/JavaBuilder", "build"));
        }
        if (dirtyFilesHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyFilesHolder", "org/jetbrains/jps/incremental/java/JavaBuilder", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/incremental/java/JavaBuilder", "build"));
        }
        JavaCompilingTool compilingTool = (JavaCompilingTool)COMPILING_TOOL.get((UserDataHolder)context);
        if (!((Boolean)IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue() || compilingTool == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        return this.doBuild(context, chunk, dirtyFilesHolder, outputConsumer, compilingTool);
    }

    public ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer, @NotNull JavaCompilingTool compilingTool) throws ProjectBuildException, IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/java/JavaBuilder", "doBuild"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/incremental/java/JavaBuilder", "doBuild"));
        }
        if (dirtyFilesHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyFilesHolder", "org/jetbrains/jps/incremental/java/JavaBuilder", "doBuild"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/incremental/java/JavaBuilder", "doBuild"));
        }
        if (compilingTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilingTool", "org/jetbrains/jps/incremental/java/JavaBuilder", "doBuild"));
        }
        try {
            ProjectBuilderLogger logger;
            THashSet filesToCompile = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            dirtyFilesHolder.processDirtyFiles((arg_0, arg_1, arg_2) -> JavaBuilder.lambda$doBuild$0((Set)filesToCompile, arg_0, arg_1, arg_2));
            int javaModulesCount = 0;
            if ((!filesToCompile.isEmpty() || dirtyFilesHolder.hasRemovedFiles()) && JpsJavaSdkType.parseVersion((String)JavaBuilder.getLanguageLevel((JpsModule)ContainerUtil.getFirstItem(chunk.getModules()))) >= 9) {
                JavaModuleIndex index = JavaBuilder.getJavaModuleIndex(context);
                for (ModuleBuildTarget target : chunk.getTargets()) {
                    File moduleInfoFile = index.getModuleInfoFile(target.getModule(), target.isTests());
                    if (moduleInfoFile == null) continue;
                    filesToCompile.add(moduleInfoFile);
                    ++javaModulesCount;
                }
            }
            if (JavaBuilderUtil.isCompileJavaIncrementally(context) && (logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled() && !filesToCompile.isEmpty()) {
                logger.logCompiledFiles((Collection<File>)filesToCompile, "java", "Compiling files:");
            }
            if (javaModulesCount > 1) {
                String prefix = "Cannot compile a module cycle with multiple module-info.java files: ";
                String message = chunk.getModules().stream().map(JpsNamedElement::getName).collect(Collectors.joining(", ", prefix, ""));
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, message));
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            return this.compile(context, chunk, dirtyFilesHolder, (Collection<File>)filesToCompile, outputConsumer, compilingTool, javaModulesCount > 0);
        }
        catch (PersistentEnumeratorBase.CorruptedException | BuildDataCorruptedException | ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            if (message == null) {
                message = "Internal error: \n" + ExceptionUtil.getThrowableText((Throwable)e);
            }
            context.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, message));
            throw new StopBuildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleLevelBuilder.ExitCode compile(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, Collection<File> files, ModuleLevelBuilder.OutputConsumer outputConsumer, JavaCompilingTool compilingTool, boolean hasModules) throws Exception {
        ModuleLevelBuilder.ExitCode exitCode;
        block19: {
            boolean hasSourcesToCompile;
            exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            boolean bl = hasSourcesToCompile = !files.isEmpty();
            if (!hasSourcesToCompile && !dirtyFilesHolder.hasRemovedFiles()) {
                return exitCode;
            }
            ProjectDescriptor pd = context.getProjectDescriptor();
            JavaBuilderUtil.ensureModuleHasJdk(chunk.representativeTarget().getModule(), context, "java");
            Collection<File> classpath = ProjectPaths.getCompilationClasspath(chunk, false);
            Collection<File> platformCp = ProjectPaths.getPlatformCompilationClasspath(chunk, false);
            OutputFilesSink outputSink = new OutputFilesSink(context, outputConsumer, JavaBuilderUtil.getDependenciesRegistrar(context), chunk.getPresentableShortName());
            Collection<File> filesWithErrors = null;
            try {
                if (!hasSourcesToCompile) break block19;
                exitCode = ModuleLevelBuilder.ExitCode.OK;
                HashSet<File> srcPath = new HashSet<File>();
                BuildRootIndex index = pd.getBuildRootIndex();
                for (ModuleBuildTarget target : chunk.getTargets()) {
                    for (JavaSourceRootDescriptor rd : index.getTempTargetRoots(target, context)) {
                        srcPath.add(rd.root);
                    }
                }
                DiagnosticSink diagnosticSink = new DiagnosticSink(context);
                String chunkName = chunk.getName();
                context.processMessage(new ProgressMessage("Parsing java... [" + chunk.getPresentableShortName() + "]"));
                int filesCount = files.size();
                boolean compiledOk = true;
                if (filesCount > 0) {
                    LOG.info("Compiling " + filesCount + " java files; module: " + chunkName + (chunk.containsTests() ? " (tests)" : ""));
                    if (LOG.isDebugEnabled()) {
                        for (File file : files) {
                            LOG.debug("Compiling " + file.getPath());
                        }
                        LOG.debug(" classpath for " + chunkName + ":");
                        for (File file : classpath) {
                            LOG.debug("  " + file.getAbsolutePath());
                        }
                        LOG.debug(" platform classpath for " + chunkName + ":");
                        for (File file : platformCp) {
                            LOG.debug("  " + file.getAbsolutePath());
                        }
                    }
                    try {
                        compiledOk = this.compileJava(context, chunk, files, classpath, platformCp, srcPath, diagnosticSink, outputSink, compilingTool, hasModules);
                    }
                    finally {
                        filesWithErrors = diagnosticSink.getFilesWithErrors();
                        for (File file : filesWithErrors) {
                            if (file.exists()) continue;
                            FSOperations.markDeleted(context, file);
                        }
                    }
                }
                context.checkCanceled();
                if (!compiledOk && diagnosticSink.getErrorCount() == 0) {
                    diagnosticSink.report((Diagnostic<? extends JavaFileObject>)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, "Compilation failed: internal java compiler error"));
                }
                if (!((Boolean)Utils.PROCEED_ON_ERROR_KEY.get((UserDataHolder)context, (Object)Boolean.FALSE)).booleanValue() && diagnosticSink.getErrorCount() > 0) {
                    if (!compiledOk) {
                        diagnosticSink.report((Diagnostic<? extends JavaFileObject>)new JpsInfoDiagnostic("Errors occurred while compiling module '" + chunkName + "'"));
                    }
                    throw new StopBuildException("Compilation failed: errors: " + diagnosticSink.getErrorCount() + "; warnings: " + diagnosticSink.getWarningCount());
                }
            }
            finally {
                JavaBuilderUtil.registerFilesToCompile(context, files);
                if (filesWithErrors != null) {
                    JavaBuilderUtil.registerFilesWithErrors(context, filesWithErrors);
                }
                JavaBuilderUtil.registerSuccessfullyCompiled(context, outputSink.getSuccessfullyCompiled());
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileJava(CompileContext context, ModuleChunk chunk, Collection<File> files, Collection<File> originalClassPath, Collection<File> originalPlatformCp, Collection<File> sourcePath, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool, boolean hasModules) throws Exception {
        TasksCounter counter = new TasksCounter();
        COUNTER_KEY.set((UserDataHolder)context, (Object)counter);
        JpsJavaExtensionService javaExt = JpsJavaExtensionService.getInstance();
        JpsJavaCompilerConfiguration compilerConfig = javaExt.getCompilerConfiguration(context.getProjectDescriptor().getProject());
        assert (compilerConfig != null);
        Set<JpsModule> modules = chunk.getModules();
        ProcessorConfigProfile profile = null;
        if (modules.size() == 1) {
            profile = compilerConfig.getAnnotationProcessingProfile(modules.iterator().next());
        } else {
            String message = JavaBuilder.validateCycle(chunk, javaExt, compilerConfig, modules);
            if (message != null) {
                diagnosticSink.report((Diagnostic)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, message));
                return true;
            }
        }
        Map<File, Set<File>> outs = JavaBuilder.buildOutputDirectoriesMap(context, chunk);
        try {
            boolean rc;
            Collection<File> platformCp;
            int targetLanguageLevel = JpsJavaSdkType.parseVersion((String)JavaBuilder.getLanguageLevel(chunk.getModules().iterator().next()));
            boolean shouldForkJavac = JavaBuilder.shouldForkCompilerProcess(context, chunk, targetLanguageLevel);
            Pair<String, Integer> forkSdk = null;
            if (shouldForkJavac && (forkSdk = JavaBuilder.getForkedJavacSdk(chunk, targetLanguageLevel)) == null) {
                String text = "Cannot start javac process for " + chunk.getName() + ": unknown JDK home path.\nPlease check project configuration.";
                diagnosticSink.report((Diagnostic)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, text));
                boolean bl = true;
                return bl;
            }
            int compilerSdkVersion = forkSdk == null ? JavaBuilder.getCompilerSdkVersion(context) : (Integer)forkSdk.getSecond();
            List<String> options = JavaBuilder.getCompilationOptions(compilerSdkVersion, context, chunk, profile, compilingTool);
            if (LOG.isDebugEnabled()) {
                String mode = shouldForkJavac ? "fork" : "in-process";
                LOG.debug("Compiling chunk [" + chunk.getName() + "] with options: \"" + StringUtil.join(options, (String)" ") + "\", mode=" + mode);
            }
            if ((platformCp = JavaBuilder.calcEffectivePlatformCp(originalPlatformCp, options, compilingTool)) == null) {
                String text = "Compact compilation profile was requested, but target platform for module \"" + chunk.getName() + "\" differs from javac's platform (" + System.getProperty("java.version") + ")\nCompilation profiles are not supported for such configuration";
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, text));
                boolean bl = true;
                return bl;
            }
            ArrayList<File> classPath = originalClassPath;
            List modulePath = Collections.emptyList();
            if (hasModules) {
                modulePath = ProjectPaths.getCompilationModulePath(chunk, false);
                classPath = Collections.emptyList();
            }
            if (!platformCp.isEmpty()) {
                if (hasModules) {
                    modulePath = JBIterable.from(platformCp).append(modulePath).toList();
                    platformCp = Collections.emptyList();
                } else {
                    int chunkSdkVersion = JavaBuilder.getChunkSdkVersion(chunk);
                    if (chunkSdkVersion >= 9) {
                        classPath = JBIterable.from(platformCp).append(classPath).toList();
                        platformCp = Collections.emptyList();
                    } else if (JavaBuilder.shouldUseReleaseOption(context, compilerSdkVersion, chunkSdkVersion, targetLanguageLevel)) {
                        ArrayList<File> joined = new ArrayList<File>(classPath.size() + 1);
                        for (File file : platformCp) {
                            if (FileUtil.toSystemIndependentName((String)file.getAbsolutePath()).contains("/jre/")) continue;
                            joined.add(file);
                        }
                        joined.addAll(classPath);
                        classPath = joined;
                        platformCp = Collections.emptyList();
                    }
                }
            }
            ClassProcessingConsumer classesConsumer = new ClassProcessingConsumer(context, outputSink);
            if (!shouldForkJavac) {
                JavaBuilder.updateCompilerUsageStatistics(context, compilingTool.getDescription(), chunk);
                rc = JavacMain.compile(options, files, (Collection)classPath, platformCp, (Collection)modulePath, sourcePath, outs, (DiagnosticOutputConsumer)diagnosticSink, (OutputFileConsumer)classesConsumer, (CanceledStatus)context.getCancelStatus(), (JavaCompilingTool)compilingTool);
            } else {
                JavaBuilder.updateCompilerUsageStatistics(context, "javac " + forkSdk.getSecond(), chunk);
                List<String> vmOptions = JavaBuilder.getCompilationVMOptions(context, compilingTool);
                ExternalJavacManager server = JavaBuilder.ensureJavacServerStarted(context);
                rc = server.forkJavac((String)forkSdk.getFirst(), JavaBuilder.getExternalJavacHeapSize(), vmOptions, options, platformCp, classPath, modulePath, sourcePath, files, outs, diagnosticSink, classesConsumer, compilingTool, context.getCancelStatus());
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            counter.await();
        }
    }

    private static void updateCompilerUsageStatistics(CompileContext context, String compilerName, ModuleChunk chunk) {
        Collection prev;
        ConcurrentMap map = (ConcurrentMap)COMPILER_USAGE_STATISTICS.get((UserDataHolder)context);
        Collection<String> names = (Set<String>)map.get(compilerName);
        if (names == null && (prev = (Collection)map.putIfAbsent(compilerName, names = Collections.synchronizedSet(new HashSet()))) != null) {
            names = prev;
        }
        for (JpsModule module : chunk.getModules()) {
            names.add(module.getName());
        }
    }

    private static int getExternalJavacHeapSize() {
        int maxMbytes = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        if (maxMbytes < 0) {
            return -1;
        }
        return Math.max(maxMbytes * 75 / 100, 256);
    }

    @Nullable
    public static String validateCycle(ModuleChunk chunk, JpsJavaExtensionService javaExt, JpsJavaCompilerConfiguration compilerConfig, Set<JpsModule> modules) {
        Pair pair = null;
        for (JpsModule module : modules) {
            LanguageLevel moduleLevel = javaExt.getLanguageLevel(module);
            if (pair == null) {
                pair = Pair.create((Object)module.getName(), (Object)moduleLevel);
                continue;
            }
            if (Comparing.equal((Object)pair.getSecond(), (Object)moduleLevel)) continue;
            return "Modules " + (String)pair.getFirst() + " and " + module.getName() + " must have the same language level because of cyclic dependencies between them";
        }
        for (JpsModule module : modules) {
            ProcessorConfigProfile prof = compilerConfig.getAnnotationProcessingProfile(module);
            if (!prof.isEnabled()) continue;
            return "Annotation processing is not supported for module cycles. Please ensure that all modules from cycle [" + chunk.getName() + "] are excluded from annotation processing";
        }
        return null;
    }

    private static boolean shouldUseReleaseOption(CompileContext context, int compilerVersion, int chunkSdkVersion, int targetLanguageLevel) {
        if (compilerVersion >= 9 && chunkSdkVersion > 0 && targetLanguageLevel > 0 && JavaBuilder.isJavac((JavaCompilingTool)COMPILING_TOOL.get((UserDataHolder)context))) {
            return chunkSdkVersion >= 9;
        }
        return false;
    }

    private static boolean shouldForkCompilerProcess(CompileContext context, ModuleChunk chunk, int chunkLanguageLevel) {
        Integer chunkSdkVersion;
        Pair<JpsSdk<JpsDummyElement>, Integer> sdkVersionPair;
        if (!JavaBuilder.isJavac((JavaCompilingTool)COMPILING_TOOL.get((UserDataHolder)context))) {
            return false;
        }
        int compilerSdkVersion = JavaBuilder.getCompilerSdkVersion(context);
        if (JavaBuilder.preferTargetJdkCompiler(context) && (sdkVersionPair = JavaBuilder.getAssociatedSdk(chunk)) != null && (chunkSdkVersion = (Integer)sdkVersionPair.second) != compilerSdkVersion && chunkSdkVersion >= 6) {
            return true;
        }
        if (compilerSdkVersion < 9 || chunkLanguageLevel <= 0) {
            return false;
        }
        return Math.abs(compilerSdkVersion - chunkLanguageLevel) > 3;
    }

    private static boolean isJavac(JavaCompilingTool compilingTool) {
        return compilingTool != null && (compilingTool.getId() == "Javac" || compilingTool.getId() == "compAPI");
    }

    private static boolean preferTargetJdkCompiler(CompileContext context) {
        Boolean val = (Boolean)PREFER_TARGET_JDK_COMPILER.get((UserDataHolder)context);
        if (val == null) {
            JpsProject project = context.getProjectDescriptor().getProject();
            JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
            val = config != null ? config.getCompilerOptions((String)"Javac").PREFER_TARGET_JDK_COMPILER : Boolean.TRUE;
            PREFER_TARGET_JDK_COMPILER.set((UserDataHolder)context, (Object)val);
        }
        return val;
    }

    @Nullable
    private static Collection<File> calcEffectivePlatformCp(Collection<File> platformCp, List<String> options, JavaCompilingTool compilingTool) {
        if (ourDefaultRtJar == null || !JavaBuilder.isJavac(compilingTool)) {
            return platformCp;
        }
        boolean profileFeatureRequested = false;
        for (String option : options) {
            if (!"-profile".equalsIgnoreCase(option)) continue;
            profileFeatureRequested = true;
            break;
        }
        if (!profileFeatureRequested) {
            return platformCp;
        }
        boolean isTargetPlatformSameAsBuildRuntime = false;
        for (File file : platformCp) {
            if (!FileUtil.filesEqual((File)file, (File)ourDefaultRtJar)) continue;
            isTargetPlatformSameAsBuildRuntime = true;
            break;
        }
        if (!isTargetPlatformSameAsBuildRuntime) {
            return null;
        }
        return Collections.emptyList();
    }

    private void submitAsyncTask(CompileContext context, Runnable taskRunnable) {
        TasksCounter counter = (TasksCounter)COUNTER_KEY.get((UserDataHolder)context);
        assert (counter != null);
        counter.incTaskCount();
        this.myTaskRunner.execute(() -> {
            try {
                taskRunnable.run();
            }
            catch (Throwable e) {
                context.processMessage(new CompilerMessage("java", e));
            }
            finally {
                counter.decTaskCounter();
            }
        });
    }

    private static synchronized ExternalJavacManager ensureJavacServerStarted(@NotNull CompileContext context) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/java/JavaBuilder", "ensureJavacServerStarted"));
        }
        ExternalJavacManager server = (ExternalJavacManager)ExternalJavacManager.KEY.get(context);
        if (server != null) {
            return server;
        }
        int listenPort = JavaBuilder.findFreePort();
        server = new ExternalJavacManager(Utils.getSystemRoot()){

            @Override
            protected ExternalJavacManager.ExternalJavacProcessHandler createProcessHandler(@NotNull Process process, @NotNull String commandLine) {
                if (process == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/jps/incremental/java/JavaBuilder$2", "createProcessHandler"));
                }
                if (commandLine == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/jetbrains/jps/incremental/java/JavaBuilder$2", "createProcessHandler"));
                }
                return new ExternalJavacManager.ExternalJavacProcessHandler(process, commandLine){

                    @NotNull
                    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
                        if (task == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jps/incremental/java/JavaBuilder$2$1", "executeOnPooledThread"));
                        }
                        Future future = SharedThreadPool.getInstance().executeOnPooledThread(task);
                        if (future == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/java/JavaBuilder$2$1", "executeOnPooledThread"));
                        }
                        return future;
                    }
                };
            }
        };
        server.start(listenPort);
        ExternalJavacManager.KEY.set(context, server);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        ServerSocket serverSocket;
        int n;
        ServerSocket serverSocket2 = new ServerSocket(0);
        try {
            n = serverSocket2.getLocalPort();
            serverSocket = serverSocket2;
        }
        catch (Throwable throwable) {
            try {
                ServerSocket serverSocket3 = serverSocket2;
                synchronized (serverSocket3) {
                    try {
                        serverSocket2.wait(1L);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                serverSocket2.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return 7878;
            }
        }
        synchronized (serverSocket) {
            try {
                serverSocket2.wait(1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        serverSocket2.close();
        return n;
    }

    private static List<String> getCompilationVMOptions(CompileContext context, JavaCompilingTool compilingTool) {
        List cached = (List)JAVAC_VM_OPTIONS.get((UserDataHolder)context);
        if (cached == null) {
            JavaBuilder.loadCommonJavacOptions(context, compilingTool);
            cached = (List)JAVAC_VM_OPTIONS.get((UserDataHolder)context);
        }
        return cached;
    }

    private static List<String> getCompilationOptions(int compilerSdkVersion, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile, @NotNull JavaCompilingTool compilingTool) {
        if (compilingTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilingTool", "org/jetbrains/jps/incremental/java/JavaBuilder", "getCompilationOptions"));
        }
        List cached = (List)JAVAC_OPTIONS.get((UserDataHolder)context);
        if (cached == null) {
            JavaBuilder.loadCommonJavacOptions(context, compilingTool);
            cached = (List)JAVAC_OPTIONS.get((UserDataHolder)context);
            assert (cached != null) : context;
        }
        ArrayList<String> options = new ArrayList<String>();
        JpsModule module = chunk.representativeTarget().getModule();
        File baseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
        if (baseDirectory != null) {
            String stringToReplace = "$MODULE_DIR$";
            String moduleDirPath = FileUtil.toCanonicalPath((String)baseDirectory.getAbsolutePath());
            for (String s : cached) {
                options.add(StringUtil.replace((String)s, (String)stringToReplace, (String)moduleDirPath));
            }
        } else {
            options.addAll(cached);
        }
        JavaBuilder.addCompilationOptions(compilerSdkVersion, options, context, chunk, profile);
        return options;
    }

    public static void addCompilationOptions(List<String> options, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile) {
        JavaBuilder.addCompilationOptions(JavaBuilder.getCompilerSdkVersion(context), options, context, chunk, profile);
    }

    public static void addCompilationOptions(int compilerSdkVersion, List<String> options, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile) {
        File srcOutput;
        if (!JavaBuilder.isEncodingSet(options)) {
            CompilerEncodingConfiguration config = context.getProjectDescriptor().getEncodingConfiguration();
            String encoding = config.getPreferredModuleChunkEncoding(chunk);
            if (config.getAllModuleChunkEncodings(chunk).size() > 1) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("Multiple encodings set for module chunk ").append(chunk.getName());
                if (encoding != null) {
                    msgBuilder.append("\n\"").append(encoding).append("\" will be used by compiler");
                }
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.INFO, msgBuilder.toString()));
            }
            if (!StringUtil.isEmpty((String)encoding)) {
                options.add("-encoding");
                options.add(encoding);
            }
        }
        JavaBuilder.addCrossCompilationOptions(compilerSdkVersion, options, context, chunk);
        if (JavaBuilder.addAnnotationProcessingOptions(options, (AnnotationProcessingConfiguration)profile) && (srcOutput = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(chunk.getModules().iterator().next(), chunk.containsTests(), profile)) != null) {
            FileUtil.createDirectory((File)srcOutput);
            options.add("-s");
            options.add(srcOutput.getPath());
        }
    }

    public static boolean addAnnotationProcessingOptions(List<String> options, @Nullable AnnotationProcessingConfiguration profile) {
        Set processors;
        if (profile == null || !profile.isEnabled()) {
            options.add("-proc:none");
            return false;
        }
        if (!profile.isObtainProcessorsFromClasspath()) {
            String processorsPath = profile.getProcessorPath();
            options.add("-processorpath");
            options.add(FileUtil.toSystemDependentName((String)processorsPath.trim()));
        }
        if (!(processors = profile.getProcessors()).isEmpty()) {
            options.add("-processor");
            options.add(StringUtil.join((Collection)processors, (String)","));
        }
        for (Map.Entry optionEntry : profile.getProcessorOptions().entrySet()) {
            options.add("-A" + (String)optionEntry.getKey() + "=" + (String)optionEntry.getValue());
        }
        return true;
    }

    @NotNull
    public static String getUsedCompilerId(CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
        String string = config == null ? "Javac" : config.getJavaCompilerId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/java/JavaBuilder", "getUsedCompilerId"));
        }
        return string;
    }

    private static void addCrossCompilationOptions(int compilerSdkVersion, List<String> options, CompileContext context, ModuleChunk chunk) {
        int targetLanguageLevel;
        JpsJavaCompilerConfiguration compilerConfiguration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(context.getProjectDescriptor().getProject());
        String langLevel = JavaBuilder.getLanguageLevel(chunk.getModules().iterator().next());
        int chunkSdkVersion = JavaBuilder.getChunkSdkVersion(chunk);
        if (JavaBuilder.shouldUseReleaseOption(context, compilerSdkVersion, chunkSdkVersion, targetLanguageLevel = JpsJavaSdkType.parseVersion((String)langLevel))) {
            if (compilerSdkVersion != targetLanguageLevel) {
                options.add("--release");
                options.add(String.valueOf(targetLanguageLevel));
            }
            return;
        }
        if (!StringUtil.isEmpty((String)langLevel)) {
            options.add("-source");
            options.add(langLevel);
        }
        String bytecodeTarget = null;
        for (JpsModule module : chunk.getModules()) {
            String moduleTarget = compilerConfiguration.getByteCodeTargetLevel(module.getName());
            if (moduleTarget == null) continue;
            if (bytecodeTarget == null) {
                bytecodeTarget = moduleTarget;
                continue;
            }
            if (moduleTarget.compareTo(bytecodeTarget) >= 0) continue;
            bytecodeTarget = moduleTarget;
        }
        if (bytecodeTarget == null) {
            bytecodeTarget = !StringUtil.isEmpty((String)langLevel) ? langLevel : (String)USER_DEFINED_BYTECODE_TARGET.get((UserDataHolder)context);
        }
        if (bytecodeTarget != null) {
            int userSpecifiedTargetVersion;
            options.add("-target");
            if (chunkSdkVersion > 0 && compilerSdkVersion > chunkSdkVersion && (userSpecifiedTargetVersion = JpsJavaSdkType.parseVersion((String)bytecodeTarget)) > 0 && userSpecifiedTargetVersion <= compilerSdkVersion && userSpecifiedTargetVersion > chunkSdkVersion) {
                bytecodeTarget = "1." + chunkSdkVersion;
            }
            options.add(bytecodeTarget);
        } else if (chunkSdkVersion > 0 && compilerSdkVersion > chunkSdkVersion) {
            options.add("-target");
            options.add("1." + chunkSdkVersion);
        }
    }

    private static String getLanguageLevel(JpsModule module) {
        LanguageLevel level = JpsJavaExtensionService.getInstance().getLanguageLevel(module);
        return level != null ? level.getComplianceOption() : null;
    }

    private static boolean isEncodingSet(List<String> options) {
        for (String option : options) {
            if (!"-encoding".equals(option)) continue;
            return true;
        }
        return false;
    }

    private static int getCompilerSdkVersion(CompileContext context) {
        Integer cached = (Integer)JAVA_COMPILER_VERSION_KEY.get((UserDataHolder)context);
        if (cached != null) {
            return cached;
        }
        int javaVersion = JpsJavaSdkType.parseVersion((String)SystemProperties.getJavaVersion());
        JAVA_COMPILER_VERSION_KEY.set((UserDataHolder)context, (Object)javaVersion);
        return javaVersion;
    }

    private static int getChunkSdkVersion(ModuleChunk chunk) {
        int chunkSdkVersion = -1;
        for (JpsModule module : chunk.getModules()) {
            int moduleSdkVersion;
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
            if (sdk == null || (moduleSdkVersion = JpsJavaSdkType.parseVersion((String)sdk.getVersionString())) == 0 || chunkSdkVersion >= 0 && chunkSdkVersion <= moduleSdkVersion) continue;
            chunkSdkVersion = moduleSdkVersion;
        }
        return chunkSdkVersion;
    }

    @Nullable
    private static Pair<String, Integer> getForkedJavacSdk(ModuleChunk chunk, int targetLanguageLevel) {
        int sdkVersion;
        Pair<JpsSdk<JpsDummyElement>, Integer> sdkVersionPair = JavaBuilder.getAssociatedSdk(chunk);
        if (sdkVersionPair != null && (sdkVersion = ((Integer)sdkVersionPair.second).intValue()) >= 6 && (sdkVersion < 9 || Math.abs(sdkVersion - targetLanguageLevel) <= 3)) {
            return Pair.create((Object)((JpsSdk)sdkVersionPair.first).getHomePath(), (Object)sdkVersion);
        }
        String fallbackJdkHome = System.getProperty("jps.fallback.jdk.home", null);
        if (fallbackJdkHome == null) {
            LOG.info("Fallback JDK is not specified. (See jps.fallback.jdk.home option)");
            return null;
        }
        String fallbackJdkVersion = System.getProperty("jps.fallback.jdk.version", null);
        if (fallbackJdkVersion == null) {
            LOG.info("Fallback JDK version is not specified. (See jps.fallback.jdk.version option)");
            return null;
        }
        int fallbackVersion = JpsJavaSdkType.parseVersion((String)fallbackJdkVersion);
        if (fallbackVersion < 6) {
            LOG.info("Version string for fallback JDK is '" + fallbackJdkVersion + "' (recognized as version '" + fallbackJdkVersion + "'). At least version 6 is required.");
            return null;
        }
        return Pair.create((Object)fallbackJdkHome, (Object)fallbackVersion);
    }

    @Nullable
    private static Pair<JpsSdk<JpsDummyElement>, Integer> getAssociatedSdk(ModuleChunk chunk) {
        JpsSdk sdk = chunk.representativeTarget().getModule().getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
        return sdk != null ? Pair.create((Object)sdk, (Object)JpsJavaSdkType.parseVersion((String)sdk.getVersionString())) : null;
    }

    private static void loadCommonJavacOptions(@NotNull CompileContext context, @NotNull JavaCompilingTool compilingTool) {
        String customArgs;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/java/JavaBuilder", "loadCommonJavacOptions"));
        }
        if (compilingTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilingTool", "org/jetbrains/jps/incremental/java/JavaBuilder", "loadCommonJavacOptions"));
        }
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> vmOptions = new ArrayList<String>();
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        JpsJavaCompilerOptions compilerOptions = compilerConfig.getCurrentCompilerOptions();
        if (compilerOptions.DEBUGGING_INFO) {
            options.add("-g");
        }
        if (compilerOptions.DEPRECATION) {
            options.add("-deprecation");
        }
        if (compilerOptions.GENERATE_NO_WARNINGS) {
            options.add("-nowarn");
        }
        if (compilerOptions instanceof EclipseCompilerOptions) {
            EclipseCompilerOptions eclipseOptions = (EclipseCompilerOptions)compilerOptions;
            if (eclipseOptions.PROCEED_ON_ERROR) {
                options.add("-proceedOnError");
            }
        }
        if ((customArgs = compilerOptions.ADDITIONAL_OPTIONS_STRING) != null) {
            boolean skip = false;
            boolean targetOptionFound = false;
            for (String userOption : ParametersListUtil.parse((String)customArgs)) {
                if (FILTERED_OPTIONS.contains(userOption)) {
                    skip = true;
                    targetOptionFound = "-target".equals(userOption);
                    continue;
                }
                if (skip) {
                    skip = false;
                    if (!targetOptionFound) continue;
                    targetOptionFound = false;
                    USER_DEFINED_BYTECODE_TARGET.set((UserDataHolder)context, (Object)userOption);
                    continue;
                }
                if (FILTERED_SINGLE_OPTIONS.contains(userOption)) continue;
                if (userOption.startsWith("-J-")) {
                    vmOptions.add(userOption.substring("-J".length()));
                    continue;
                }
                options.add(userOption);
            }
        }
        for (ExternalJavacOptionsProvider extension : JpsServiceManager.getInstance().getExtensions(ExternalJavacOptionsProvider.class)) {
            vmOptions.addAll(extension.getOptions(compilingTool));
        }
        if ("Eclipse".equals(compilingTool.getId())) {
            for (String option : options) {
                if (!option.startsWith("-proceedOnError")) continue;
                Utils.PROCEED_ON_ERROR_KEY.set((UserDataHolder)context, (Object)Boolean.TRUE);
                break;
            }
        }
        JAVAC_OPTIONS.set((UserDataHolder)context, options);
        JAVAC_VM_OPTIONS.set((UserDataHolder)context, vmOptions);
    }

    @Override
    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        JavaBuilderUtil.cleanupChunkResources(context);
    }

    private static Map<File, Set<File>> buildOutputDirectoriesMap(CompileContext context, ModuleChunk chunk) {
        THashMap map = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File outputDir = target.getOutputDir();
            if (outputDir == null) continue;
            THashSet roots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (JavaSourceRootDescriptor descriptor : context.getProjectDescriptor().getBuildRootIndex().getTargetRoots(target, context)) {
                roots.add(descriptor.root);
            }
            map.put(outputDir, roots);
        }
        return map;
    }

    private static JavaModuleIndex getJavaModuleIndex(CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        File storageRoot = context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot();
        return JpsJavaExtensionService.getInstance().getJavaModuleIndex(project, storageRoot);
    }

    private static /* synthetic */ boolean lambda$doBuild$0(Set filesToCompile, ModuleBuildTarget target, File file, JavaSourceRootDescriptor descriptor) throws IOException {
        if (JAVA_SOURCES_FILTER.accept(file) && ourCompilableModuleTypes.contains(target.getModule().getModuleType())) {
            filesToCompile.add(file);
        }
        return true;
    }

    static {
        for (JavaBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(JavaBuilderExtension.class)) {
            ourCompilableModuleTypes.addAll(extension.getCompilableModuleTypes());
        }
        File rtJar = null;
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("sun.boot.class.path", ""), File.pathSeparator, false);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            if (!"rt.jar".equals(file.getName())) continue;
            rtJar = file;
            break;
        }
        ourDefaultRtJar = rtJar;
        JAVAC_OPTIONS = Key.create((String)"_javac_options_");
        JAVAC_VM_OPTIONS = Key.create((String)"_javac_vm_options_");
        USER_DEFINED_BYTECODE_TARGET = Key.create((String)"_user_defined_bytecode_target_");
        COUNTER_KEY = Key.create((String)"_async_task_counter_");
    }

    private static final class TasksCounter {
        private int myCounter;

        private TasksCounter() {
        }

        private synchronized void incTaskCount() {
            ++this.myCounter;
        }

        private synchronized void decTaskCounter() {
            this.myCounter = Math.max(0, this.myCounter - 1);
            if (this.myCounter == 0) {
                this.notifyAll();
            }
        }

        public synchronized void await() {
            while (this.myCounter > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ClassProcessingConsumer
    implements OutputFileConsumer {
        private final CompileContext myContext;
        private final OutputFileConsumer myDelegateOutputFileSink;

        private ClassProcessingConsumer(CompileContext context, OutputFileConsumer sink) {
            this.myContext = context;
            this.myDelegateOutputFileSink = sink != null ? sink : new OutputFileConsumer(){

                public void save(@NotNull OutputFileObject fileObject) {
                    if (fileObject == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "org/jetbrains/jps/incremental/java/JavaBuilder$ClassProcessingConsumer$1", "save"));
                    }
                    throw new RuntimeException("Output sink for compiler was not specified");
                }
            };
        }

        public void save(@NotNull OutputFileObject fileObject) {
            if (fileObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "org/jetbrains/jps/incremental/java/JavaBuilder$ClassProcessingConsumer", "save"));
            }
            try {
                BinaryContent content = fileObject.getContent();
                File file = fileObject.getFile();
                if (content != null) {
                    content.saveToFile(file);
                } else {
                    this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.WARNING, "Missing content for file " + file.getPath()));
                }
            }
            catch (IOException e) {
                this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, e.getMessage()));
            }
            JavaBuilder.this.submitAsyncTask(this.myContext, () -> {
                if (fileObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "org/jetbrains/jps/incremental/java/JavaBuilder$ClassProcessingConsumer", "lambda$save$0"));
                }
                try {
                    for (ClassPostProcessor processor : ourClassProcessors) {
                        processor.process(this.myContext, fileObject);
                    }
                }
                finally {
                    this.myDelegateOutputFileSink.save(fileObject);
                }
            });
        }
    }

    private static class DiagnosticSink
    implements DiagnosticOutputConsumer {
        private final CompileContext myContext;
        private volatile int myErrorCount;
        private volatile int myWarningCount;
        private final Set<File> myFilesWithErrors = new THashSet(FileUtil.FILE_HASHING_STRATEGY);

        private DiagnosticSink(CompileContext context) {
            this.myContext = context;
        }

        public void javaFileLoaded(File file) {
        }

        public void registerImports(String className, Collection<String> imports, Collection<String> staticImports) {
        }

        public void customOutputData(String pluginId, String dataName, byte[] data) {
            for (CustomOutputDataListener listener : JpsServiceManager.getInstance().getExtensions(CustomOutputDataListener.class)) {
                if (!pluginId.equals(listener.getId())) continue;
                listener.processData(dataName, data);
                return;
            }
        }

        public void outputLineAvailable(String line) {
            if (!StringUtil.isEmpty((String)line)) {
                if (line.startsWith("JAVAC_PROCESS[STDOUT]")) {
                    System.out.println(line);
                } else if (line.startsWith("JAVAC_PROCESS[STDERR]")) {
                    System.err.println(line);
                } else if (line.contains("java.lang.OutOfMemoryError")) {
                    this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, "OutOfMemoryError: insufficient memory"));
                    ++this.myErrorCount;
                } else {
                    BuildMessage.Kind kind = DiagnosticSink.getKindByMessageText(line);
                    if (kind == BuildMessage.Kind.ERROR) {
                        ++this.myErrorCount;
                    } else if (kind == BuildMessage.Kind.WARNING) {
                        ++this.myWarningCount;
                    }
                    this.myContext.processMessage(new CompilerMessage("java", kind, line));
                }
            }
        }

        private static BuildMessage.Kind getKindByMessageText(String line) {
            String lowercasedLine = line.toLowerCase(Locale.US);
            if (lowercasedLine.contains("error") || lowercasedLine.contains("requires target release")) {
                return BuildMessage.Kind.ERROR;
            }
            return BuildMessage.Kind.INFO;
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            String srcPath;
            BuildMessage.Kind kind;
            switch (diagnostic.getKind()) {
                case ERROR: {
                    kind = BuildMessage.Kind.ERROR;
                    ++this.myErrorCount;
                    break;
                }
                case MANDATORY_WARNING: 
                case WARNING: {
                    kind = BuildMessage.Kind.WARNING;
                    ++this.myWarningCount;
                    break;
                }
                case NOTE: {
                    kind = BuildMessage.Kind.INFO;
                    break;
                }
                case OTHER: {
                    kind = diagnostic instanceof JpsInfoDiagnostic ? BuildMessage.Kind.JPS_INFO : BuildMessage.Kind.OTHER;
                    break;
                }
                default: {
                    kind = BuildMessage.Kind.OTHER;
                }
            }
            File sourceFile = null;
            try {
                JavaFileObject source = diagnostic.getSource();
                sourceFile = source != null ? PathUtils.convertToFile((URI)source.toUri()) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
            if (sourceFile != null) {
                if (kind == BuildMessage.Kind.ERROR) {
                    this.myFilesWithErrors.add(sourceFile);
                }
                srcPath = FileUtil.toSystemIndependentName((String)sourceFile.getPath());
            } else {
                srcPath = null;
            }
            String message = diagnostic.getMessage(Locale.US);
            if (Utils.IS_TEST_MODE) {
                LOG.info(message);
            }
            CompilerMessage compilerMsg = new CompilerMessage("java", kind, message, srcPath, diagnostic.getStartPosition(), diagnostic.getEndPosition(), diagnostic.getPosition(), diagnostic.getLineNumber(), diagnostic.getColumnNumber());
            if (LOG.isDebugEnabled()) {
                LOG.debug(compilerMsg.toString());
            }
            this.myContext.processMessage(compilerMsg);
        }

        public int getErrorCount() {
            return this.myErrorCount;
        }

        public int getWarningCount() {
            return this.myWarningCount;
        }

        @NotNull
        public Collection<File> getFilesWithErrors() {
            Set<File> set = this.myFilesWithErrors;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/java/JavaBuilder$DiagnosticSink", "getFilesWithErrors"));
            }
            return set;
        }
    }
}

