/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;

public class AjModelSerializerExtension
extends JpsModelSerializerExtension {
    private static final JpsElementChildRole<JpsElementReference> AJ_PATH_REF_ROLE = JpsElementChildRoleBase.create((String)"AJ Path Reference");

    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<AjCompilerSettingsSerializer> list = Collections.singletonList(new AjCompilerSettingsSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjModelSerializerExtension", "getProjectExtensionSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        List<AjFacetConfigurationSerializer> list = Collections.singletonList(new AjFacetConfigurationSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjModelSerializerExtension", "getFacetConfigurationSerializers"));
        }
        return list;
    }

    private static void bindReferences(@NotNull List<AjPathEntries.Entry> entries, @NotNull JpsCompositeElement holder) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/lang/aspectj/build/AjModelSerializerExtension", "bindReferences"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/aspectj/build/AjModelSerializerExtension", "bindReferences"));
        }
        for (AjPathEntries.Entry entry : entries) {
            Object reference = entry.getReference();
            if (reference == null) continue;
            holder.getContainer().setChild(AJ_PATH_REF_ROLE, reference);
        }
    }

    private static class AjFacetConfigurationSerializer
    extends JpsFacetConfigurationSerializer<AjJpsModuleSettings> {
        private AjFacetConfigurationSerializer() {
            super(AjJpsModuleSettings.ROLE, "AspectJ", "AspectJ");
        }

        protected AjJpsModuleSettings loadExtension(@NotNull Element element, String name, JpsElement parent, JpsModule module) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/aspectj/build/AjModelSerializerExtension$AjFacetConfigurationSerializer", "loadExtension"));
            }
            AjModuleSettings settings = (AjModuleSettings)XmlSerializer.deserialize((Element)element, AjModuleSettings.class);
            AjJpsModuleSettings component = new AjJpsModuleSettings(settings);
            AjModelSerializerExtension.bindReferences(settings.aspectPath, (JpsCompositeElement)component);
            return component;
        }

        protected void saveExtension(AjJpsModuleSettings extension, Element facetConfigurationTag, JpsModule module) {
        }
    }

    private static class AjCompilerSettingsSerializer
    extends JpsProjectExtensionSerializer {
        private AjCompilerSettingsSerializer() {
            super("compiler.xml", "AjcSettings");
        }

        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/build/AjModelSerializerExtension$AjCompilerSettingsSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "com/intellij/lang/aspectj/build/AjModelSerializerExtension$AjCompilerSettingsSerializer", "loadExtension"));
            }
            AjCompilerSettings settings = (AjCompilerSettings)XmlSerializer.deserialize((Element)componentTag, AjCompilerSettings.class);
            AjJpsCompilerSettings component = new AjJpsCompilerSettings(settings);
            project.getContainer().setChild(AjJpsCompilerSettings.ROLE, (JpsElement)component);
        }

        public void loadExtensionWithDefaultSettings(@NotNull JpsProject project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/build/AjModelSerializerExtension$AjCompilerSettingsSerializer", "loadExtensionWithDefaultSettings"));
            }
            AjJpsCompilerSettings component = new AjJpsCompilerSettings(new AjCompilerSettings());
            project.getContainer().setChild(AjJpsCompilerSettings.ROLE, (JpsElement)component);
        }

        public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/build/AjModelSerializerExtension$AjCompilerSettingsSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "com/intellij/lang/aspectj/build/AjModelSerializerExtension$AjCompilerSettingsSerializer", "saveExtension"));
            }
        }
    }
}

