/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.run;

import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexDependencyEntry;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.run.JpsBCBasedRunnerParameters;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsFlexUnitRunnerParameters
extends JpsBCBasedRunnerParameters<JpsFlexUnitRunnerParameters> {
    @NotNull
    private Scope myScope = Scope.Class;
    @NotNull
    private String myPackageName = "";
    @NotNull
    private String myClassName = "";
    @NotNull
    private String myMethodName = "";
    @Nullable
    private OutputLogLevel myOutputLogLevel = null;
    private int myPort;
    private int mySocketPolicyPort;

    public JpsFlexUnitRunnerParameters() {
    }

    private JpsFlexUnitRunnerParameters(JpsFlexUnitRunnerParameters original) {
        super(original);
        this.myScope = original.myScope;
        this.myPackageName = original.myPackageName;
        this.myClassName = original.myClassName;
        this.myMethodName = original.myMethodName;
        this.myOutputLogLevel = original.myOutputLogLevel;
    }

    @NotNull
    public JpsFlexUnitRunnerParameters createCopy() {
        JpsFlexUnitRunnerParameters jpsFlexUnitRunnerParameters = new JpsFlexUnitRunnerParameters(this);
        if (jpsFlexUnitRunnerParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "createCopy"));
        }
        return jpsFlexUnitRunnerParameters;
    }

    @Override
    public void applyChanges(@NotNull JpsFlexUnitRunnerParameters modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "applyChanges"));
        }
        super.applyChanges(modified);
        this.myScope = modified.myScope;
        this.myPackageName = modified.myPackageName;
        this.myClassName = modified.myClassName;
        this.myMethodName = modified.myMethodName;
        this.myOutputLogLevel = modified.myOutputLogLevel;
    }

    @Attribute(value="scope")
    @NotNull
    public Scope getScope() {
        Scope scope = this.myScope;
        if (scope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "getScope"));
        }
        return scope;
    }

    public void setScope(@NotNull Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "setScope"));
        }
        this.myScope = scope;
    }

    @Attribute(value="package_name")
    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "getPackageName"));
        }
        return string;
    }

    public void setPackageName(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "setPackageName"));
        }
        this.myPackageName = packageName;
    }

    @Attribute(value="class_name")
    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "getClassName"));
        }
        return string;
    }

    public void setClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "setClassName"));
        }
        this.myClassName = className;
    }

    @Attribute(value="method_name")
    @NotNull
    public String getMethodName() {
        String string = this.myMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "getMethodName"));
        }
        return string;
    }

    public void setMethodName(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/flex/model/run/JpsFlexUnitRunnerParameters", "setMethodName"));
        }
        this.myMethodName = methodName;
    }

    @Attribute(value="output_log_level")
    @Nullable
    public OutputLogLevel getOutputLogLevel() {
        return this.myOutputLogLevel;
    }

    public void setOutputLogLevel(@Nullable OutputLogLevel outputLogLevel) {
        this.myOutputLogLevel = outputLogLevel;
    }

    @Transient
    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    @Transient
    public int getSocketPolicyPort() {
        return this.mySocketPolicyPort;
    }

    public void setSocketPolicyPort(int port) {
        this.mySocketPolicyPort = port;
    }

    @Override
    @Nullable
    public JpsFlexBuildConfiguration getBC(JpsProject project) {
        JpsFlexBuildConfiguration bc = super.getBC(project);
        if (bc == null) {
            return null;
        }
        JpsFlexBuildConfiguration overriddenBC = ((JpsFlexBuildConfigurationManager)bc.getModule().getProperties()).createTemporaryCopyForCompilation(bc);
        overriddenBC.setOutputType(OutputType.Application);
        overriddenBC.setMainClass("____FlexUnitLauncher");
        overriddenBC.setOutputFileName("_flexunit.swf");
        String testOutputUrl = StringUtil.notNullize((String)JpsJavaExtensionService.getInstance().getOutputUrl(bc.getModule(), true));
        overriddenBC.setOutputFolder(JpsPathUtil.urlToPath((String)testOutputUrl));
        overriddenBC.setUseHtmlWrapper(false);
        overriddenBC.setRLMs(Collections.emptyList());
        overriddenBC.setCssFilesToCompile(Collections.emptyList());
        overriddenBC.setSkipCompile(false);
        overriddenBC.getDependencies().setFrameworkLinkage(LinkageType.Merged);
        for (JpsFlexDependencyEntry entry : overriddenBC.getDependencies().getEntries()) {
            if (entry.getLinkageType() != LinkageType.External) continue;
            entry.setLinkageType(LinkageType.Merged);
        }
        return overriddenBC;
    }

    public static enum OutputLogLevel {
        Fatal("1000"),
        Error("8"),
        Warn("6"),
        Info("4"),
        Debug("2"),
        All("0");

        private final String myFlexConstant;

        private OutputLogLevel(String flexConstant) {
            this.myFlexConstant = flexConstant;
        }

        public String getFlexConstant() {
            return this.myFlexConstant;
        }
    }

    public static enum Scope {
        Method,
        Class,
        Package;

    }
}

