/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Processor;
import aQute.service.reporter.Reporter;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.build.Reporter;

public class ReportingBuilder
extends Builder {
    private final Reporter myReporter;

    public ReportingBuilder(@NotNull Reporter reporter) {
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "org/jetbrains/osgi/jps/build/ReportingBuilder", "<init>"));
        }
        this.myReporter = reporter;
    }

    public ReportingBuilder(@NotNull Reporter reporter, @NotNull Builder parent) {
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "org/jetbrains/osgi/jps/build/ReportingBuilder", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/osgi/jps/build/ReportingBuilder", "<init>"));
        }
        super((Processor)parent);
        this.myReporter = reporter;
        this.use((Processor)parent);
    }

    public Reporter.SetLocation exception(Throwable t, String format, Object ... args) {
        Logger.getInstance(this.myReporter.getClass()).warn(ReportingBuilder.formatArrays((String)format, (Object[])args), t);
        return super.exception(t, format, args);
    }

    public void progress(float progress, String format, Object ... args) {
        this.myReporter.progress(ReportingBuilder.formatArrays((String)format, (Object[])args));
    }

    public boolean isTrace() {
        return this.myReporter.isDebugEnabled();
    }

    public void trace(String format, Object ... args) {
        this.myReporter.debug(ReportingBuilder.formatArrays((String)format, (Object[])args));
    }
}

