/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.parse.standard;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceContext {
    private int[] linebreaks;
    private String theSource;

    public SourceContext(String theSource) {
        this.theSource = theSource;
        int[] nArray = new int[2];
        nArray[1] = theSource.length();
        this.linebreaks = nArray;
    }

    public void setLinebreaks(List<Integer> linebreaks) {
        this.linebreaks = new int[linebreaks.size()];
        int i = 0;
        while (i < linebreaks.size()) {
            this.linebreaks[i] = linebreaks.get(i);
            ++i;
        }
    }

    public int[] getLinebreaks() {
        int[] linebreaksCopy = new int[this.linebreaks.length];
        System.arraycopy(this.linebreaks, 0, linebreaksCopy, 0, this.linebreaks.length);
        return linebreaksCopy;
    }

    public int getLine(int offset) {
        return this.getRelevantStartLinebreakEntry(offset) + 1;
    }

    public int getColumn(int offset) {
        int lb = this.getRelevantStartLinebreakEntry(offset);
        return offset - this.linebreaks[lb];
    }

    private int getRelevantStartLinebreakEntry(int startoffset) {
        int pos = Arrays.binarySearch(this.linebreaks, startoffset);
        if (pos < 0) {
            return -pos - 2;
        }
        return pos;
    }

    public String getLineAsString(int relevantLine) {
        int startoffset = this.linebreaks[relevantLine - 1];
        int endoffset = this.linebreaks[relevantLine];
        return this.theSource.substring(startoffset, endoffset - 1);
    }
}

