/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

@Tag(value="filter")
public class ResourceRootFilter {
    @Tag(value="filterType")
    @NotNull
    public String filterType;
    @Tag(value="properties")
    @NotNull
    public String properties;
    private transient Map<Object, Object> propertiesMap;

    public int computeConfigurationHash() {
        int result = this.filterType.hashCode();
        result = 31 * result + this.getProperties().hashCode();
        return result;
    }

    @NotNull
    public Map<Object, Object> getProperties() {
        if (this.propertiesMap == null) {
            try {
                Gson gson = new GsonBuilder().create();
                this.propertiesMap = (Map)gson.fromJson(this.properties, new TypeToken<Map<Object, Object>>(){}.getType());
                if ("RenamingCopyFilter".equals(this.filterType)) {
                    Object pattern = this.propertiesMap.get("pattern");
                    Matcher matcher = Pattern.compile(pattern instanceof String ? (String)pattern : "").matcher("");
                    this.propertiesMap.put("matcher", matcher);
                }
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Unsupported filter: " + this.properties, e);
            }
            if (this.propertiesMap == null) {
                this.propertiesMap = new HashMap<Object, Object>();
            }
        }
        Map<Object, Object> map = this.propertiesMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gradle/model/impl/ResourceRootFilter", "getProperties"));
        }
        return map;
    }
}

