/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;

public abstract class JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsLoaderBase.class);
    private static final int MAX_ATTEMPTS = 5;
    private final JpsMacroExpander myMacroExpander;

    protected JpsLoaderBase(JpsMacroExpander macroExpander) {
        this.myMacroExpander = macroExpander;
    }

    @Nullable
    protected Element loadRootElement(@NotNull Path file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "loadRootElement"));
        }
        return JpsLoaderBase.loadRootElement(file, this.myMacroExpander);
    }

    protected <E extends JpsElement> void loadComponents(@NotNull Path dir, @NotNull Path defaultConfigFile, JpsElementExtensionSerializerBase<E> serializer, E element) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "loadComponents"));
        }
        if (defaultConfigFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultConfigFile", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "loadComponents"));
        }
        String fileName = serializer.getConfigFileName();
        Path configFile = fileName == null ? defaultConfigFile : dir.resolve(fileName);
        Runnable timingLog = TimingLog.startActivity("loading: " + configFile.getFileName() + ":" + serializer.getComponentName());
        Element componentTag = JDomSerializationUtil.findComponent(this.loadRootElement(configFile), serializer.getComponentName());
        if (componentTag != null) {
            serializer.loadExtension(element, componentTag);
        } else {
            serializer.loadExtensionWithDefaultSettings(element);
        }
        timingLog.run();
    }

    @Nullable
    protected static Element loadRootElement(@NotNull Path file, @NotNull JpsMacroExpander macroExpander) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "loadRootElement"));
        }
        if (macroExpander == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroExpander", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "loadRootElement"));
        }
        Element element = JpsLoaderBase.tryLoadRootElement(file);
        if (element != null) {
            macroExpander.substitute(element, SystemInfo.isFileSystemCaseSensitive);
        }
        return element;
    }

    @Nullable
    private static Element tryLoadRootElement(@NotNull Path file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/serialization/JpsLoaderBase", "tryLoadRootElement"));
        }
        int i = 0;
        while (true) {
            try {
                return JDOMUtil.load((Reader)Files.newBufferedReader(file));
            }
            catch (NoSuchFileException e) {
                return null;
            }
            catch (IOException | JDOMException e) {
                if (++i == 5) {
                    throw new CannotLoadJpsModelException(file.toFile(), "Cannot " + (e instanceof IOException ? "read" : "parse") + " file " + file.toAbsolutePath() + ": " + e.getMessage(), e);
                }
                LOG.info("Loading attempt #" + i + " failed", e);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ignored) {
                    return null;
                }
            }
        }
    }
}

