/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.jarRepository;

import com.intellij.util.SmartList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoriesConfiguration;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryService;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsRemoteRepositoriesConfigurationSerializer
extends JpsProjectExtensionSerializer {
    private static final String ELEMENT_TAG = "remote-repository";
    private static final String OPTION_TAG = "option";
    private static final String ID_PROPERTY = "id";
    private static final String NAME_PROPERTY = "name";
    private static final String URL_PROPERTY = "url";

    public JpsRemoteRepositoriesConfigurationSerializer() {
        super("jarRepositories.xml", "RemoteRepositoriesConfiguration");
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/jarRepository/JpsRemoteRepositoriesConfigurationSerializer", "loadExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/jarRepository/JpsRemoteRepositoriesConfigurationSerializer", "loadExtension"));
        }
        SmartList result = new SmartList();
        List children = componentTag.getChildren(ELEMENT_TAG);
        for (Element repoElement : children) {
            String id = null;
            String name = null;
            String url = null;
            for (Element element : repoElement.getChildren(OPTION_TAG)) {
                String option = element.getAttributeValue(NAME_PROPERTY);
                String optionValue = element.getAttributeValue("value");
                if (ID_PROPERTY.equals(option)) {
                    id = optionValue;
                    continue;
                }
                if (NAME_PROPERTY.equals(option)) {
                    name = optionValue == null ? "" : optionValue;
                    continue;
                }
                if (!URL_PROPERTY.equals(option)) continue;
                url = optionValue;
            }
            if (id == null || url == null) continue;
            result.add(new JpsRemoteRepositoryDescription(id, name, url));
        }
        JpsRemoteRepositoriesConfiguration config = JpsRemoteRepositoryService.getInstance().getOrCreateRemoteRepositoriesConfiguration(project);
        if (!result.isEmpty()) {
            config.setRepositories((List<JpsRemoteRepositoryDescription>)result);
        }
    }

    @Override
    public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/jarRepository/JpsRemoteRepositoriesConfigurationSerializer", "saveExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/jarRepository/JpsRemoteRepositoriesConfigurationSerializer", "saveExtension"));
        }
    }
}

