/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ast.AbstractRefCollectorCompilerToolExtension;
import org.jetbrains.jps.javac.ast.api.JavacFileData;

public class ExternalRefCollectorCompilerToolExtension
extends AbstractRefCollectorCompilerToolExtension {
    public static final String ID = "external.ast.reference.collector";
    public static final String ENABLED_PARAM = "external.java.process.ref.collector.enabled";
    public static final String DIVIDE_IMPORTS_PARAM = "external.java.process.divide.imports";

    @Override
    protected boolean isEnabled() {
        return "true".equals(System.getProperty(ENABLED_PARAM));
    }

    @Override
    protected boolean divideImportsRefs() {
        return "true".equals(System.getProperty(DIVIDE_IMPORTS_PARAM));
    }

    @Override
    @NotNull
    protected Consumer<JavacFileData> getFileDataConsumer(final @NotNull DiagnosticOutputConsumer diagnosticConsumer) {
        if (diagnosticConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticConsumer", "org/jetbrains/jps/javac/ast/ExternalRefCollectorCompilerToolExtension", "getFileDataConsumer"));
        }
        Consumer<JavacFileData> consumer = new Consumer<JavacFileData>(){

            public void consume(JavacFileData data) {
                diagnosticConsumer.customOutputData(ExternalRefCollectorCompilerToolExtension.ID, "javac-refs", data.asBytes());
            }
        };
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/ExternalRefCollectorCompilerToolExtension", "getFileDataConsumer"));
        }
        return consumer;
    }
}

