/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public interface LightRef
extends RW.Savable {
    public static final LightRef[] EMPTY_ARRAY = new LightRef[0];
    public static final byte CLASS_MARKER = 0;
    public static final byte METHOD_MARKER = 1;
    public static final byte FIELD_MARKER = 2;
    public static final byte FUN_EXPR_MARKER = 3;
    public static final byte ANONYMOUS_CLASS_MARKER = 4;

    public LightRef override(int var1);

    public static class JavaLightFunExprDef
    implements LightFunExprDef {
        private final int myId;

        public JavaLightFunExprDef(int id) {
            this.myId = id;
        }

        @Override
        public int getId() {
            return this.myId;
        }

        @Override
        public LightRef override(int newOwner) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(3);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getId());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaLightFunExprDef usage = (JavaLightFunExprDef)o;
            return this.myId == usage.myId;
        }

        public int hashCode() {
            return this.myId;
        }
    }

    public static class JavaLightClassRef
    implements LightClassHierarchyElementDef {
        private final int myName;

        public JavaLightClassRef(int name) {
            this.myName = name;
        }

        @Override
        public int getName() {
            return this.myName;
        }

        @Override
        public LightRef override(int newOwner) {
            return new JavaLightClassRef(newOwner);
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(0);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getName());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaLightClassRef usage = (JavaLightClassRef)o;
            return this.myName == usage.myName;
        }

        public int hashCode() {
            return this.myName;
        }
    }

    public static class JavaLightAnonymousClassRef
    implements LightAnonymousClassDef {
        private final int myName;

        public JavaLightAnonymousClassRef(int name) {
            this.myName = name;
        }

        @Override
        public LightRef override(int newOwner) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getName() {
            return this.myName;
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(4);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getName());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaLightAnonymousClassRef ref = (JavaLightAnonymousClassRef)o;
            return this.myName == ref.myName;
        }

        public int hashCode() {
            return this.myName;
        }
    }

    public static class JavaLightFieldRef
    implements LightMember {
        private final int myOwner;
        private final int myName;

        public JavaLightFieldRef(int owner, int name) {
            this.myOwner = owner;
            this.myName = name;
        }

        @Override
        public int getName() {
            return this.myName;
        }

        @Override
        public LightRef override(int newOwner) {
            return new JavaLightFieldRef(newOwner, this.myName);
        }

        @Override
        @NotNull
        public LightClassHierarchyElementDef getOwner() {
            JavaLightClassRef javaLightClassRef = new JavaLightClassRef(this.myOwner);
            if (javaLightClassRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/LightRef$JavaLightFieldRef", "getOwner"));
            }
            return javaLightClassRef;
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(2);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOwner);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getName());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaLightFieldRef usage = (JavaLightFieldRef)o;
            if (this.myOwner != usage.myOwner) {
                return false;
            }
            return this.myName == usage.myName;
        }

        public int hashCode() {
            return this.myName + 31 * this.myOwner;
        }
    }

    public static class JavaLightMethodRef
    implements LightMember {
        private final int myOwner;
        private final int myName;
        private final int myParameterCount;

        public JavaLightMethodRef(int owner, int name, int parameterCount) {
            this.myOwner = owner;
            this.myName = name;
            this.myParameterCount = parameterCount;
        }

        @Override
        public int getName() {
            return this.myName;
        }

        @Override
        public LightRef override(int newOwner) {
            return new JavaLightMethodRef(newOwner, this.myName, this.myParameterCount);
        }

        public int getParameterCount() {
            return this.myParameterCount;
        }

        @Override
        @NotNull
        public LightClassHierarchyElementDef getOwner() {
            JavaLightClassRef javaLightClassRef = new JavaLightClassRef(this.myOwner);
            if (javaLightClassRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/LightRef$JavaLightMethodRef", "getOwner"));
            }
            return javaLightClassRef;
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(1);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOwner);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getName());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getParameterCount());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaLightMethodRef usage = (JavaLightMethodRef)o;
            if (this.myOwner != usage.myOwner) {
                return false;
            }
            if (this.myName != usage.myName) {
                return false;
            }
            return this.myParameterCount == usage.myParameterCount;
        }

        public int hashCode() {
            int result = this.myName;
            result = 31 * result + this.myParameterCount;
            result = 31 * result + this.myOwner;
            return result;
        }
    }

    public static interface LightMember
    extends NamedLightRef {
        @NotNull
        public LightClassHierarchyElementDef getOwner();
    }

    public static interface LightFunExprDef
    extends LightRef {
        public int getId();
    }

    public static interface LightAnonymousClassDef
    extends LightClassHierarchyElementDef {
    }

    public static interface LightClassHierarchyElementDef
    extends NamedLightRef {
        public static final LightClassHierarchyElementDef[] EMPTY_ARRAY = new LightClassHierarchyElementDef[0];
    }

    public static interface NamedLightRef
    extends LightRef {
        public static final NamedLightRef[] EMPTY_ARRAY = new NamedLightRef[0];

        public int getName();
    }
}

