/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.gwt.build.GwtBuildTarget;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class GwtBuildTargetType
extends BuildTargetType<GwtBuildTarget> {
    public static final GwtBuildTargetType INSTANCE = new GwtBuildTargetType();
    public static final String TYPE_ID = "gwt";

    private GwtBuildTargetType() {
        super(TYPE_ID, true);
    }

    @NotNull
    public List<GwtBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/gwt/build/GwtBuildTargetType", "computeAllTargets"));
        }
        ArrayList<GwtBuildTarget> targets = new ArrayList<GwtBuildTarget>();
        JpsGwtExtensionService service = JpsGwtExtensionService.getInstance();
        for (JpsModule module : model.getProject().getModules()) {
            JpsGwtModuleExtension extension = service.getExtension(module);
            if (extension == null) continue;
            targets.add(new GwtBuildTarget(extension));
        }
        ArrayList<GwtBuildTarget> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/build/GwtBuildTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @NotNull
    public BuildTargetLoader<GwtBuildTarget> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/gwt/build/GwtBuildTargetType", "createLoader"));
        }
        Loader loader = new Loader(model);
        if (loader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/build/GwtBuildTargetType", "createLoader"));
        }
        return loader;
    }

    private static class Loader
    extends BuildTargetLoader<GwtBuildTarget> {
        private Map<String, GwtBuildTarget> myTargets = new HashMap<String, GwtBuildTarget>();

        public Loader(JpsModel model) {
            JpsGwtExtensionService service = JpsGwtExtensionService.getInstance();
            for (JpsModule module : model.getProject().getModules()) {
                JpsGwtModuleExtension extension = service.getExtension(module);
                if (extension == null) continue;
                this.myTargets.put(module.getName(), new GwtBuildTarget(extension));
            }
        }

        @Nullable
        public GwtBuildTarget createTarget(@NotNull String targetId) {
            if (targetId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/gwt/build/GwtBuildTargetType$Loader", "createTarget"));
            }
            return this.myTargets.get(targetId);
        }
    }
}

