/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gant;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.jetbrains.annotations.NotNull;

public class Log4jFileLoggerFactory
implements Logger.Factory {
    private final RollingFileAppender myAppender;
    private final List<String> myCategoriesWithDebugLevel;

    public Log4jFileLoggerFactory(File logFile, String categoriesWithDebugLevel) throws IOException {
        this.myCategoriesWithDebugLevel = categoriesWithDebugLevel.isEmpty() ? Collections.emptyList() : Arrays.asList(categoriesWithDebugLevel.split(","));
        PatternLayout pattern = new PatternLayout("%d [%7r] %6p - %30.30c - %m\n");
        this.myAppender = new RollingFileAppender((Layout)pattern, logFile.getAbsolutePath());
        this.myAppender.setMaxFileSize("20MB");
        this.myAppender.setMaxBackupIndex(10);
    }

    @NotNull
    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "org/jetbrains/jps/gant/Log4jFileLoggerFactory", "getLoggerInstance"));
        }
        Logger logger = Logger.getLogger((String)category);
        logger.addAppender((Appender)this.myAppender);
        logger.setLevel(this.isDebugLevel(category) ? Level.DEBUG : Level.INFO);
        Log4jBasedLogger log4jBasedLogger = new Log4jBasedLogger(logger);
        if (log4jBasedLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gant/Log4jFileLoggerFactory", "getLoggerInstance"));
        }
        return log4jBasedLogger;
    }

    private boolean isDebugLevel(String category) {
        for (String debug : this.myCategoriesWithDebugLevel) {
            if (!category.startsWith(debug)) continue;
            return true;
        }
        return false;
    }
}

