/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gwt.build.GwtBuildTarget;
import org.jetbrains.jps.gwt.build.GwtBuildTargetType;
import org.jetbrains.jps.gwt.build.GwtBuilderMessages;
import org.jetbrains.jps.gwt.build.GwtBuilderParameters;
import org.jetbrains.jps.gwt.build.GwtExternalCompilerProcessHandler;
import org.jetbrains.jps.gwt.build.JpsGwtClasspathUtil;
import org.jetbrains.jps.gwt.build.JpsGwtCompilerPaths;
import org.jetbrains.jps.gwt.index.JpsGwtModule;
import org.jetbrains.jps.gwt.index.JpsGwtModuleIndex;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.JpsGwtCompilerProjectExtension;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.gwt.model.impl.JpsGwtCompilerProjectExtensionImpl;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtMavenSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.JpsGwtDependenciesCache;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtBuilder
extends TargetBuilder<BuildRootDescriptor, GwtBuildTarget> {
    private static final boolean SKIP_COMPILATION_FOR_COMPILE_FILE = SystemProperties.getBooleanProperty((String)"idea.gwt.skip.compilation.for.compile.file.action", (boolean)true);
    public static final String NAME = "GWT Compiler";

    public GwtBuilder() {
        super(Collections.singletonList(GwtBuildTargetType.INSTANCE));
    }

    public void build(@NotNull GwtBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, GwtBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            GwtBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GwtBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            GwtBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GwtBuilder.$$$reportNull$$$0(3);
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        JpsGwtModuleIndex index = JpsGwtExtensionService.getInstance().getGwtModuleIndex(context.getProjectDescriptor().getModel(), dataPaths);
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerConfiguration compilerConfiguration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        final BidirectionalMultiMap rootsToModules = new BidirectionalMultiMap((Map)new THashMap(FileUtil.FILE_HASHING_STRATEGY), (Map)new HashMap());
        JpsGwtModuleExtension extension = target.getExtension();
        String compileReportModuleName = extension.getModule().getName().equals(GwtBuilderParameters.getCompileReportModuleName(context)) ? GwtBuilderParameters.getCompileReportGwtModuleQualifiedName(context) : null;
        final LinkedHashSet<JpsGwtModule> modulesToRecompile = new LinkedHashSet<JpsGwtModule>();
        for (JpsGwtModule gwtModule : index.getModules(extension, true, false)) {
            if (compilerConfiguration.getCompilerExcludes().isExcluded(gwtModule.getModuleFile())) continue;
            if (gwtModule.getQualifiedName().equals(compileReportModuleName) && index.isCompilable(gwtModule, extension)) {
                modulesToRecompile.add(gwtModule);
            }
            GwtBuilder.collectModuleRoots(gwtModule, (BidirectionalMultiMap<File, JpsGwtModule>)rootsToModules, gwtModule);
            for (JpsGwtModule module : index.getInheritedModules(gwtModule)) {
                GwtBuilder.collectModuleRoots(module, (BidirectionalMultiMap<File, JpsGwtModule>)rootsToModules, gwtModule);
            }
        }
        holder.processDirtyFiles((FileProcessor)new FileProcessor<BuildRootDescriptor, GwtBuildTarget>(){

            public boolean apply(GwtBuildTarget target, File file, BuildRootDescriptor root) throws IOException {
                GwtBuilder.collectModulesToRecompile(file, root, (BidirectionalMultiMap<File, JpsGwtModule>)rootsToModules, modulesToRecompile);
                return true;
            }
        });
        Collection removedFiles = holder.getRemovedFiles((BuildTarget)target);
        for (String path : removedFiles) {
            GwtBuilder.collectModulesToRecompile(new File(path), null, (BidirectionalMultiMap<File, JpsGwtModule>)rootsToModules, modulesToRecompile);
        }
        if (SKIP_COMPILATION_FOR_COMPILE_FILE && !context.getScope().isWholeTargetAffected((BuildTarget)target)) {
            if (!modulesToRecompile.isEmpty()) {
                context.processMessage((BuildMessage)new CompilerMessage(NAME, BuildMessage.Kind.INFO, "GWT compiler for '" + extension.getModule().getName() + "' module wasn't invoked because only some files were selected for compilation. Invoke Build | 'Build Artifacts' action to perform GWT compilation."));
            }
            return;
        }
        for (JpsGwtModule module : modulesToRecompile) {
            if (!index.isCompilable(module, extension)) continue;
            GwtBuilder.compile(target, module, rootsToModules.getKeys((Object)module), module.getQualifiedName().equals(compileReportModuleName), outputConsumer, context);
        }
    }

    private static void collectModulesToRecompile(File file, @Nullable BuildRootDescriptor root, BidirectionalMultiMap<File, JpsGwtModule> modulesByRoots, Set<JpsGwtModule> modulesToRecompile) {
        File current = file;
        do {
            modulesToRecompile.addAll(modulesByRoots.getValues((Object)current));
        } while ((current = FileUtil.getParentFile((File)current)) != null && (root == null || !FileUtil.filesEqual((File)current, (File)root.getRootFile())));
    }

    private static void collectModuleRoots(JpsGwtModule moduleToGetRoots, BidirectionalMultiMap<File, JpsGwtModule> modulesByRoots, JpsGwtModule targetModule) {
        modulesByRoots.put((Object)moduleToGetRoots.getModuleFile(), (Object)targetModule);
        for (File root : moduleToGetRoots.getSourceRoots(false)) {
            modulesByRoots.put((Object)root, (Object)targetModule);
        }
        for (File root : moduleToGetRoots.getPublicRoots(false)) {
            modulesByRoots.put((Object)root, (Object)targetModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compile(GwtBuildTarget target, final JpsGwtModule gwtModule, Set<File> roots, boolean generateReport, BuildOutputConsumer outputConsumer, final CompileContext context) throws IOException, ProjectBuildException {
        String localWorkers;
        context.processMessage((BuildMessage)new ProgressMessage("Compiling GWT module '" + gwtModule.getQualifiedName() + "'"));
        JpsGwtModuleExtension extension = target.getExtension();
        JpsModule module = extension.getModule();
        JpsSdk sdk = JavaBuilderUtil.ensureModuleHasJdk((JpsModule)module, (CompileContext)context, (String)NAME);
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        File outputDir = JpsGwtCompilerPaths.getCompilerOutputRoot(target, dataPaths);
        outputDir.mkdirs();
        if (context.getLoggingManager().getProjectBuilderLogger().isEnabled()) {
            context.getLoggingManager().getProjectBuilderLogger().logCompiledFiles(Collections.singletonList(gwtModule.getModuleFile()), NAME, "Compiling GWT modules:");
        }
        Collection<File> sourceRoots = JpsGwtClasspathUtil.getSourceRootsOfGwtModules(extension.getModule(), true);
        List<String> classpath = GwtBuilder.createClasspath(extension, sourceRoots, context);
        ArrayList<String> vmOptions = new ArrayList<String>();
        vmOptions.addAll(ParametersListUtil.parse((String)extension.getAdditionalCompilerVMParameters()));
        vmOptions.add("-Xmx" + extension.getCompilerMaximumHeapSize() + "m");
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.addAll(ParametersListUtil.parse((String)extension.getCompilerParameters()));
        File extraOutputRoot = JpsGwtCompilerPaths.getExtraOutputRoot(target, dataPaths);
        if (generateReport) {
            parameters.add("-compileReport");
            parameters.add("-extra");
            parameters.add(extraOutputRoot.getAbsolutePath());
        }
        parameters.addAll(Arrays.asList("-logLevel", "TRACE"));
        parameters.addAll(Arrays.asList("-war", outputDir.getAbsolutePath()));
        parameters.addAll(Arrays.asList("-style", extension.getOutputStyle().getId()));
        parameters.add(gwtModule.getQualifiedName());
        int localWorkersIndex = 1 + parameters.indexOf("-localWorkers");
        if (localWorkersIndex != 0 && localWorkersIndex < parameters.size() && (localWorkers = (String)parameters.get(localWorkersIndex)).endsWith("C")) {
            parameters.set(localWorkersIndex, Integer.toString((int)(Float.parseFloat(StringUtil.trimEnd((String)localWorkers, (char)'C')) * (float)Runtime.getRuntime().availableProcessors())));
        }
        boolean wrapCompilerCommandLine = SystemProperties.getBooleanProperty((String)"idea.gwt.wrap.compiler.command.line", (boolean)true);
        List commandLine = ExternalProcessUtil.buildJavaCommandLine((String)JpsJavaSdkType.getJavaExecutable((JpsSdk)sdk), (String)"com.google.gwt.dev.Compiler", Collections.emptyList(), classpath, vmOptions, parameters, (boolean)wrapCompilerCommandLine, (boolean)false);
        Process process = new ProcessBuilder(new String[0]).command(commandLine).directory(outputDir).start();
        String moduleFileUrl = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)gwtModule.getModuleFile().getAbsolutePath()));
        JpsGwtCompilerProjectExtension compilerProjectExtension = (JpsGwtCompilerProjectExtension)extension.getModule().getProject().getContainer().getChild(JpsGwtCompilerProjectExtensionImpl.ROLE);
        boolean showCompilerOutput = compilerProjectExtension != null && compilerProjectExtension.isShowCompilerOutput(extension);
        GwtExternalCompilerProcessHandler handler = new GwtExternalCompilerProcessHandler(process, StringUtil.join((Collection)commandLine, (String)" "), moduleFileUrl, sourceRoots, context);
        if (showCompilerOutput) {
            GwtBuilderMessages.sendCompilationStartedMessage(context, gwtModule);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    GwtBuilderMessages.sendLogMessage(context, gwtModule, event.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/jps/gwt/build/GwtBuilder$2";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        try {
            handler.startNotify();
            handler.waitForTerminationOrCancellation();
            context.checkCanceled();
            if (generateReport) {
                GwtBuilderMessages.sendCompileReportGenerated(context, gwtModule, new File(extraOutputRoot, gwtModule.getOutputName()).getAbsolutePath());
            }
        }
        finally {
            if (showCompilerOutput) {
                GwtBuilderMessages.sendCompilationFinishedMessage(context, gwtModule);
            }
        }
        ArrayList<String> sourceFiles = new ArrayList<String>();
        CollectPathsProcessor processor = new CollectPathsProcessor(sourceFiles);
        for (File root : roots) {
            FileUtil.processFilesRecursively((File)root, (Processor)processor);
        }
        outputConsumer.registerOutputDirectory(outputDir, sourceFiles);
    }

    private static List<String> createClasspath(JpsGwtModuleExtension extension, Collection<File> sourceRoots, CompileContext context) {
        ArrayList<File> roots = new ArrayList<File>();
        roots.addAll(sourceRoots);
        roots.addAll(JpsJavaExtensionService.dependencies((JpsModule)extension.getModule()).productionOnly().recursively().classes().getRoots());
        ArrayList<String> classpath = new ArrayList<String>();
        GwtSdkPaths sdkPaths = extension.getSdkPaths();
        classpath.add(sdkPaths.getDevJarPath(true));
        for (File root : roots) {
            classpath.add(root.getAbsolutePath());
        }
        boolean addDefaultAdditionalCompilerJars = true;
        if (sdkPaths instanceof GwtMavenSdkPaths) {
            BuildDataPaths buildDataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
            try {
                List<String> jars = new JpsGwtDependenciesCache(buildDataPaths).getAdditionalCompilerJars((GwtMavenSdkPaths)sdkPaths);
                if (jars != null) {
                    classpath.addAll(jars);
                    addDefaultAdditionalCompilerJars = false;
                }
            }
            catch (JpsGwtDependenciesCache.GwtDependenciesFileNotFoundException e) {
                context.processMessage((BuildMessage)new CompilerMessage(NAME, BuildMessage.Kind.WARNING, e.getMessage()));
            }
        }
        if (addDefaultAdditionalCompilerJars) {
            classpath.addAll(sdkPaths.getAdditionalCompilerJars());
        }
        return classpath;
    }

    @NotNull
    public String getPresentableName() {
        if (NAME == null) {
            GwtBuilder.$$$reportNull$$$0(4);
        }
        return NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gwt/build/GwtBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gwt/build/GwtBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectPathsProcessor
    implements Processor<File> {
        private final List<String> myResult;

        public CollectPathsProcessor(List<String> result) {
            this.myResult = result;
        }

        public boolean process(File file) {
            if (file.isFile()) {
                this.myResult.add(file.getAbsolutePath());
            }
            return true;
        }
    }
}

