/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class LibraryBundlificationRule {
    private String myRuleRegex = ".*";
    private String myAdditionalProperties = "Import-Package: *;resolution:=optional";
    private boolean myDoNotBundle = false;
    private boolean myStopAfterThisRule = false;
    private long myLastModified = System.currentTimeMillis();

    public String getRuleRegex() {
        return this.myRuleRegex;
    }

    public void setRuleRegex(String ruleRegex) {
        this.myRuleRegex = ruleRegex;
    }

    public String getAdditionalProperties() {
        return this.myAdditionalProperties;
    }

    public void setAdditionalProperties(String additionalProperties) {
        this.myAdditionalProperties = additionalProperties;
    }

    public boolean isDoNotBundle() {
        return this.myDoNotBundle;
    }

    public void setDoNotBundle(boolean doNotBundle) {
        this.myDoNotBundle = doNotBundle;
    }

    public boolean isStopAfterThisRule() {
        return this.myStopAfterThisRule;
    }

    public void setStopAfterThisRule(boolean stopAfterThisRule) {
        this.myStopAfterThisRule = stopAfterThisRule;
    }

    public long getLastModified() {
        return this.myLastModified;
    }

    public void setLastModified(long lastModified) {
        this.myLastModified = lastModified;
    }

    public LibraryBundlificationRule copy() {
        LibraryBundlificationRule result = new LibraryBundlificationRule();
        result.myAdditionalProperties = this.myAdditionalProperties;
        result.myRuleRegex = this.myRuleRegex;
        result.myDoNotBundle = this.myDoNotBundle;
        result.myStopAfterThisRule = this.myStopAfterThisRule;
        return result;
    }

    @Transient
    public Map<String, String> getAdditionalPropertiesMap() {
        try {
            Properties p = new Properties();
            p.load(new ByteArrayInputStream(this.myAdditionalProperties.getBytes(CharsetToolkit.UTF8_CHARSET)));
            HashMap result = ContainerUtil.newHashMap();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                result.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            return result;
        }
        catch (IOException iOException) {
            return Collections.emptyMap();
        }
    }

    public boolean appliesTo(@NotNull String libraryName) {
        if (libraryName == null) {
            LibraryBundlificationRule.$$$reportNull$$$0(0);
        }
        try {
            return ".*".equals(this.myRuleRegex) || !StringUtil.isEmptyOrSpaces((String)this.myRuleRegex) && libraryName.matches(this.myRuleRegex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public void validate() throws IllegalArgumentException {
        if (StringUtil.isEmptyOrSpaces((String)this.myRuleRegex)) {
            throw new IllegalArgumentException("Empty regex");
        }
        if (!".*".equals(this.myRuleRegex)) {
            Pattern.compile(this.myRuleRegex);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myAdditionalProperties)) {
            try {
                new Properties().load(new ByteArrayInputStream(this.myAdditionalProperties.getBytes(CharsetToolkit.UTF8_CHARSET)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Malformed manifest entries");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryBundlificationRule rule = (LibraryBundlificationRule)o;
        if (this.myDoNotBundle != rule.myDoNotBundle) {
            return false;
        }
        if (this.myStopAfterThisRule != rule.myStopAfterThisRule) {
            return false;
        }
        if (!this.myAdditionalProperties.equals(rule.myAdditionalProperties)) {
            return false;
        }
        return this.myRuleRegex.equals(rule.myRuleRegex);
    }

    public int hashCode() {
        int result = this.myRuleRegex.hashCode();
        result = 31 * result + this.myAdditionalProperties.hashCode();
        result = 31 * result + (this.myDoNotBundle ? 1 : 0);
        result = 31 * result + (this.myStopAfterThisRule ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Rule: " + this.myRuleRegex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "org/jetbrains/osgi/jps/model/LibraryBundlificationRule", "appliesTo"));
    }
}

