/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;

public abstract class JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsLoaderBase.class);
    private static final int MAX_ATTEMPTS = 5;
    private final JpsMacroExpander myMacroExpander;

    protected JpsLoaderBase(JpsMacroExpander macroExpander) {
        this.myMacroExpander = macroExpander;
    }

    @Nullable
    protected Element loadRootElement(@NotNull Path file) {
        if (file == null) {
            JpsLoaderBase.$$$reportNull$$$0(0);
        }
        return JpsLoaderBase.loadRootElement(file, this.myMacroExpander);
    }

    protected <E extends JpsElement> void loadComponents(@NotNull Path dir, @NotNull Path defaultConfigFile, JpsElementExtensionSerializerBase<E> serializer, E element) {
        String fileName;
        if (dir == null) {
            JpsLoaderBase.$$$reportNull$$$0(1);
        }
        if (defaultConfigFile == null) {
            JpsLoaderBase.$$$reportNull$$$0(2);
        }
        Path configFile = (fileName = serializer.getConfigFileName()) == null ? defaultConfigFile : dir.resolve(fileName);
        Runnable timingLog = TimingLog.startActivity("loading: " + configFile.getFileName() + ":" + serializer.getComponentName());
        Element componentTag = JDomSerializationUtil.findComponent(this.loadRootElement(configFile), serializer.getComponentName());
        if (componentTag != null) {
            serializer.loadExtension(element, componentTag);
        } else {
            serializer.loadExtensionWithDefaultSettings(element);
        }
        timingLog.run();
    }

    @Nullable
    protected static Element loadRootElement(@NotNull Path file, @NotNull JpsMacroExpander macroExpander) {
        Element element;
        if (file == null) {
            JpsLoaderBase.$$$reportNull$$$0(3);
        }
        if (macroExpander == null) {
            JpsLoaderBase.$$$reportNull$$$0(4);
        }
        if ((element = JpsLoaderBase.tryLoadRootElement(file)) != null) {
            macroExpander.substitute(element, SystemInfo.isFileSystemCaseSensitive);
        }
        return element;
    }

    @Nullable
    private static Element tryLoadRootElement(@NotNull Path file) {
        if (file == null) {
            JpsLoaderBase.$$$reportNull$$$0(5);
        }
        int i = 0;
        while (true) {
            try {
                return JDOMUtil.load((Reader)Files.newBufferedReader(file));
            }
            catch (NoSuchFileException e) {
                return null;
            }
            catch (IOException | JDOMException e) {
                if (++i == 5) {
                    throw new CannotLoadJpsModelException(file.toFile(), "Cannot " + (e instanceof IOException ? "read" : "parse") + " file " + file.toAbsolutePath() + ": " + e.getMessage(), e);
                }
                LOG.info("Loading attempt #" + i + " failed", e);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ignored) {
                    return null;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultConfigFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroExpander";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsLoaderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadRootElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryLoadRootElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

