/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.keyFMap.KeyFMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDataHolderBase
implements UserDataHolderEx,
Cloneable {
    private static final Key<KeyFMap> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");
    @NotNull
    private volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
    private static final AtomicFieldUpdater<UserDataHolderBase, KeyFMap> updater = AtomicFieldUpdater.forFieldOfType(UserDataHolderBase.class, KeyFMap.class);

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.setUserMap(KeyFMap.EMPTY_MAP);
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUserDataString() {
        KeyFMap userMap = this.getUserMap();
        KeyFMap copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        return userMap + (copyableMap == null ? "" : copyableMap.toString());
    }

    public void copyUserDataTo(@NotNull UserDataHolderBase other) {
        if (other == null) {
            UserDataHolderBase.$$$reportNull$$$0(0);
        }
        other.setUserMap(this.getUserMap());
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(1);
        }
        return this.getUserMap().get(key);
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = this.myUserMap;
        if (keyFMap == null) {
            UserDataHolderBase.$$$reportNull$$$0(2);
        }
        return keyFMap;
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        KeyFMap map;
        KeyFMap newMap;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(3);
        }
        do {
            map = this.getUserMap();
            KeyFMap keyFMap = newMap = value == null ? map.minus(key) : map.plus(key, value);
        } while (newMap != map && !this.changeUserMap(map, newMap));
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        return updater.compareAndSet(this, oldMap, newMap);
    }

    public <T> T getCopyableUserData(@NotNull Key<T> key) {
        KeyFMap map;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(4);
        }
        return (map = this.getUserData(COPYABLE_USER_MAP_KEY)) == null ? null : (T)map.get(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
        KeyFMap map;
        KeyFMap newMap;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(5);
        }
        do {
            KeyFMap copyableMap;
            if ((copyableMap = (map = this.getUserMap()).get(COPYABLE_USER_MAP_KEY)) == null) {
                copyableMap = KeyFMap.EMPTY_MAP;
            }
            KeyFMap newCopyableMap = value == null ? copyableMap.minus(key) : copyableMap.plus(key, value);
            KeyFMap keyFMap = newMap = newCopyableMap.isEmpty() ? map.minus(COPYABLE_USER_MAP_KEY) : map.plus(COPYABLE_USER_MAP_KEY, newCopyableMap);
        } while (newMap != map && !this.changeUserMap(map, newMap));
    }

    @Override
    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        KeyFMap map;
        KeyFMap newMap;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(6);
        }
        do {
            if ((map = this.getUserMap()).get(key) != oldValue) {
                return false;
            }
            KeyFMap keyFMap = newMap = newValue == null ? map.minus(key) : map.plus(key, newValue);
        } while (newMap != map && !this.changeUserMap(map, newMap));
        return true;
    }

    @Override
    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        KeyFMap map;
        KeyFMap newMap;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(7);
        }
        if (value == null) {
            UserDataHolderBase.$$$reportNull$$$0(8);
        }
        do {
            T oldValue;
            if ((oldValue = (map = this.getUserMap()).get(key)) == null) continue;
            T t = oldValue;
            if (t == null) {
                UserDataHolderBase.$$$reportNull$$$0(9);
            }
            return t;
        } while ((newMap = map.plus(key, value)) != map && !this.changeUserMap(map, newMap));
        T t = value;
        if (t == null) {
            UserDataHolderBase.$$$reportNull$$$0(10);
        }
        return t;
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        if (clone == null) {
            UserDataHolderBase.$$$reportNull$$$0(11);
        }
        clone.putUserData(COPYABLE_USER_MAP_KEY, this.getUserData(COPYABLE_USER_MAP_KEY));
    }

    protected void clearUserData() {
        this.setUserMap(KeyFMap.EMPTY_MAP);
    }

    protected void setUserMap(@NotNull KeyFMap map) {
        if (map == null) {
            UserDataHolderBase.$$$reportNull$$$0(12);
        }
        this.myUserMap = map;
    }

    public boolean isUserDataEmpty() {
        return this.getUserMap().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/UserDataHolderBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clone";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/UserDataHolderBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyUserDataTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyCopyableDataTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

