/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.ExcludedJavaSourceRootProvider;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.JVMModuleBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.service.JpsServiceManager;

public final class ModuleBuildTarget
extends JVMModuleBuildTarget<JavaSourceRootDescriptor> {
    public static final Boolean REBUILD_ON_DEPENDENCY_CHANGE = Boolean.valueOf(System.getProperty("rebuild.on.dependency.change", "true"));
    private final JavaModuleBuildTargetType myTargetType;

    public ModuleBuildTarget(@NotNull JpsModule module, JavaModuleBuildTargetType targetType) {
        if (module == null) {
            ModuleBuildTarget.$$$reportNull$$$0(0);
        }
        super(targetType, module);
        this.myTargetType = targetType;
    }

    @Nullable
    public File getOutputDir() {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, this.myTargetType.isTests());
    }

    @Override
    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        File annotationOut;
        SmartList result = new SmartList();
        File outputDir = this.getOutputDir();
        if (outputDir != null) {
            result.add(outputDir);
        }
        JpsModule module = this.getModule();
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(module.getProject());
        ProcessorConfigProfile profile = configuration.getAnnotationProcessingProfile(module);
        if (profile.isEnabled() && (annotationOut = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(module, this.isTests(), profile)) != null) {
            result.add(annotationOut);
        }
        SmartList smartList = result;
        if (smartList == null) {
            ModuleBuildTarget.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    @Override
    public boolean isTests() {
        return this.myTargetType.isTests();
    }

    @Override
    public final boolean isCompiledBeforeModuleLevelBuilders() {
        return false;
    }

    @Override
    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)this.myModule).compileOnly();
        if (!this.isTests()) {
            enumerator.productionOnly();
        }
        ArrayList dependencies = new ArrayList();
        enumerator.processModules(module -> dependencies.add(new ModuleBuildTarget((JpsModule)module, this.myTargetType)));
        if (this.isTests()) {
            dependencies.add(new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.PRODUCTION));
        }
        Collection<ModuleBasedTarget<?>> moduleBased = targetRegistry.getModuleBasedTargets(this.getModule(), this.isTests() ? BuildTargetRegistry.ModuleTargetSelector.TEST : BuildTargetRegistry.ModuleTargetSelector.PRODUCTION);
        for (ModuleBasedTarget<?> target : moduleBased) {
            if (target == this || !target.isCompiledBeforeModuleLevelBuilders()) continue;
            dependencies.add(target);
        }
        dependencies.trimToSize();
        return dependencies;
    }

    @Override
    @NotNull
    public List<JavaSourceRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<JavaSourceRootDescriptor> roots = new ArrayList<JavaSourceRootDescriptor>();
        JavaSourceRootType type = this.isTests() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        Iterable excludedRootProviders = JpsServiceManager.getInstance().getExtensions(ExcludedJavaSourceRootProvider.class);
        JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(this.myModule.getProject());
        block0: for (JpsTypedModuleSourceRoot sourceRoot : this.myModule.getSourceRoots((JpsModuleSourceRootType)type)) {
            File outputDir;
            if (index.isExcludedFromModule(sourceRoot.getFile(), this.myModule)) continue;
            for (ExcludedJavaSourceRootProvider provider : excludedRootProviders) {
                if (!provider.isExcludedFromCompilation(this.myModule, (JpsModuleSourceRoot)sourceRoot)) continue;
                continue block0;
            }
            String packagePrefix = ((JavaSourceRootProperties)sourceRoot.getProperties()).getPackagePrefix();
            THashSet excludes = this.computeRootExcludes(sourceRoot.getFile(), index);
            ProcessorConfigProfile profile = compilerConfig.getAnnotationProcessingProfile(this.myModule);
            if (profile.isEnabled() && (outputDir = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(this.myModule, JavaSourceRootType.TEST_SOURCE == sourceRoot.getRootType(), profile)) != null && FileUtil.isAncestor((File)sourceRoot.getFile(), (File)outputDir, (boolean)true)) {
                excludes = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY, excludes);
                excludes.add(outputDir);
            }
            roots.add(new JavaSourceRootDescriptor(sourceRoot.getFile(), this, false, false, packagePrefix, (Set<File>)excludes));
        }
        ArrayList<JavaSourceRootDescriptor> arrayList = roots;
        if (arrayList == null) {
            ModuleBuildTarget.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "Module '" + this.getModule().getName() + "' " + (this.myTargetType.isTests() ? "tests" : "production");
        if (string == null) {
            ModuleBuildTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        CompilerEncodingConfiguration encodingConfig;
        String encoding;
        JpsJavaCompilerConfiguration config;
        String bytecodeTarget;
        JpsModule module = this.getModule();
        int fingerprint = this.getDependenciesFingerprint();
        for (JavaSourceRootDescriptor root : pd.getBuildRootIndex().getTargetRoots(this, null)) {
            fingerprint += FileUtil.fileHashCode((File)root.getRootFile());
        }
        LanguageLevel level = JpsJavaExtensionService.getInstance().getLanguageLevel(module);
        if (level != null) {
            fingerprint += level.name().hashCode();
        }
        if ((bytecodeTarget = (config = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(module.getProject())).getByteCodeTargetLevel(module.getName())) != null) {
            fingerprint += bytecodeTarget.hashCode();
        }
        if ((encoding = (encodingConfig = pd.getEncodingConfiguration()).getPreferredModuleEncoding(module)) != null) {
            fingerprint += encoding.hashCode();
        }
        out.write(Integer.toHexString(fingerprint));
    }

    private int getDependenciesFingerprint() {
        int fingerprint = 0;
        if (!REBUILD_ON_DEPENDENCY_CHANGE.booleanValue()) {
            return fingerprint;
        }
        JpsModule module = this.getModule();
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)module).compileOnly();
        if (!this.isTests()) {
            enumerator = enumerator.productionOnly();
        }
        for (String url : enumerator.classes().getUrls()) {
            fingerprint = 31 * fingerprint + url.hashCode();
        }
        return fingerprint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/ModuleBuildTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/ModuleBuildTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

