/*
 * Decompiled with CFR 0.152.
 */
package aQute.service.library;

import aQute.lib.hex.Hex;
import aQute.service.library.Library;
import aQute.struct.Patterns;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Coordinate {
    public static String $artifact = "(?:[0-9a-fA-F][0-9a-fA-Z])+|[-\\p{L}0-9_.]+";
    public static String $group = "[-\\p{L}0-9_.]+";
    public static String $classifier = "(?:[-\\p{L}0-9_.]+)";
    public static String $baseline = "\\d+(?:\\.\\d+(?:\\.\\d+)?)?";
    public static String $qualifier = "[-\\w\\d\\._]*";
    public static String $version = "(?:@((" + $baseline + ")(\\." + $qualifier + ")?)?([*=~!])?)?";
    public static String $coordinate = "(" + $group + ")(?::(" + $artifact + ")(?::(" + $classifier + ")?)?)?" + $version;
    public static Pattern COORDINATE_P = Pattern.compile($coordinate, 2);
    public static Pattern COORDINATE_VERSION_P = Pattern.compile($version, 2);
    final Library.Group group;
    final String groupId;
    final String artifactId;
    final String classifier;
    final String version;
    final String baseline;
    final String qualifier;
    final String coordinate;
    final Set<Library.Phase> phases;
    private boolean exact;

    public boolean isValid(String coordinate) {
        return COORDINATE_P.matcher(coordinate.replaceAll("__", ":")).matches();
    }

    public Coordinate(String coordinate) {
        this(COORDINATE_P.matcher(coordinate.replaceAll("__", ":")));
    }

    public Coordinate(Matcher matcher) {
        Matcher m;
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(matcher.group()) + " does not match coordinate pattern: " + matcher.pattern().pattern());
        }
        this.coordinate = matcher.group(0);
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        String classifier = matcher.group(3);
        String version = matcher.group(4);
        String baseline = matcher.group(5);
        String qualifier = matcher.group(6);
        String modifier = matcher.group(7);
        if (artifactId == null && classifier == null) {
            artifactId = groupId;
            if (Library.SHA_P.matcher(groupId).matches()) {
                groupId = "sha";
                version = "0.0.0";
                baseline = "0.0.0";
            } else {
                groupId = "";
            }
        }
        this.group = "sha".equals(groupId) ? Library.Group.SHA : ("osgi".equals(groupId) ? Library.Group.OSGI : ("".equals(groupId) ? Library.Group.SIMPLE : Library.Group.MAVEN));
        if (this.group == Library.Group.SHA && !(m = Patterns.SHA_1_P.matcher(artifactId)).matches()) {
            throw new IllegalArgumentException("Not a valid SHA-1 " + artifactId);
        }
        if (modifier == null) {
            modifier = "=";
        }
        switch (modifier.charAt(0)) {
            default: {
                this.phases = EnumSet.of(Library.Phase.MASTER);
                this.exact = true;
                break;
            }
            case '*': {
                this.phases = EnumSet.of(Library.Phase.LOCKED, Library.Phase.MASTER, Library.Phase.STAGING);
                this.exact = false;
                break;
            }
            case '~': {
                this.phases = EnumSet.allOf(Library.Phase.class);
                this.exact = false;
                break;
            }
            case '!': {
                this.phases = EnumSet.of(Library.Phase.WITHDRAWN, Library.Phase.RETIRED, Library.Phase.UNKNOWN, Library.Phase.PENDING);
                this.exact = false;
            }
        }
        this.exact = "=".equals(modifier);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null || classifier.isEmpty() ? null : classifier;
        this.qualifier = qualifier != null && !qualifier.isEmpty() ? (qualifier.startsWith(".") ? qualifier.substring(1) : qualifier) : null;
        if (version != null) {
            String[] parts = baseline.split("\\.");
            long[] nrs = new long[3];
            int i = 0;
            while (i < parts.length) {
                nrs[i] = Long.parseLong(parts[i]);
                ++i;
            }
            this.baseline = String.valueOf(nrs[0]) + "." + nrs[1] + "." + nrs[2];
        } else {
            this.baseline = null;
        }
        this.version = version;
    }

    public Coordinate(String groupId, String artifactId, String classifier, String version) {
        this(Coordinate.construct(groupId, artifactId, classifier, version, true, false));
    }

    public Coordinate(String groupId, String artifactId) {
        this(Coordinate.construct(groupId, artifactId, null, null, false, false));
    }

    public Coordinate(Library.Revision revision) {
        this(Coordinate.construct(revision.groupId, revision.artifactId, revision.classifier, revision.version, true, true));
    }

    public Coordinate(String groupId, String artifactId, String classifier) {
        this(Coordinate.construct(groupId, artifactId, classifier, null, false, false));
    }

    public Coordinate(Library.RevisionRef r) {
        this(Coordinate.construct(r.groupId, r.artifactId, r.classifier, r.version, true, false));
    }

    public static String construct(String groupId, String artifactId, String classifier, String version, boolean exact, boolean staging) {
        StringBuilder sb = new StringBuilder();
        sb.append(groupId).append(":").append(artifactId);
        if (classifier != null && !classifier.isEmpty()) {
            sb.append(":").append(classifier);
        }
        if (version != null || exact || staging) {
            sb.append("@");
            if (version != null) {
                sb.append(version);
            }
            if (exact) {
                sb.append('=');
            } else if (staging) {
                sb.append('*');
            }
        }
        return sb.toString();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isSha() {
        return this.group == Library.Group.SHA;
    }

    public byte[] getSha() {
        assert (this.isSha());
        return Hex.toByteArray(this.artifactId);
    }

    public boolean isVisible(Library.Phase phase) {
        return this.phases.contains((Object)phase);
    }

    public boolean isExact() {
        return this.exact;
    }

    public Library.Group getGroup() {
        return this.group;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBaseline() {
        return this.baseline;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean hasClassifier() {
        return this.classifier != null;
    }

    public String toString() {
        return this.coordinate;
    }

    public Set<Library.Phase> getPhases() {
        return this.phases;
    }
}

