/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.utf8properties;

import aQute.lib.io.IO;
import aQute.lib.utf8properties.PropertiesParser;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Properties;

public class UTF8Properties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static Charset UTF8 = Charset.forName("UTF-8");
    private static Charset ISO8859_1 = Charset.forName("ISO8859-1");

    public UTF8Properties(Properties p) {
        super(p);
    }

    public UTF8Properties() {
    }

    public void load(InputStream in, File file, Reporter reporter) throws IOException {
        String source = this.read(in);
        this.load(source, file, reporter);
    }

    public void load(String source, File file, Reporter reporter) throws IOException {
        PropertiesParser parser = new PropertiesParser(source, file == null ? null : file.getAbsolutePath(), reporter, this);
        parser.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file, Reporter reporter) throws Exception {
        FileInputStream fin = new FileInputStream(file);
        try {
            this.load(fin, file, reporter);
        }
        finally {
            fin.close();
        }
    }

    @Override
    public void load(InputStream in) throws IOException {
        this.load(in, null, null);
    }

    @Override
    public void load(Reader r) throws IOException {
        String s = IO.collect(r);
        PropertiesParser parser = new PropertiesParser(s, null, null, this);
        parser.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String read(InputStream in) throws IOException {
        byte[] buffer = IO.read(in);
        try {
            String string = this.convert(buffer, UTF8);
            return string;
        }
        catch (CharacterCodingException e2) {
            try {
                String e2 = this.convert(buffer, ISO8859_1);
                return e2;
            }
            catch (CharacterCodingException characterCodingException) {
                String string = new String(buffer);
                return string;
            }
        }
    }

    private String convert(byte[] buffer, Charset charset) throws IOException {
        CharBuffer cb;
        ByteBuffer bb;
        CharBuffer decode = charset.decode(ByteBuffer.wrap(buffer));
        CharsetDecoder decoder = charset.newDecoder();
        CoderResult result = decoder.decode(bb = ByteBuffer.wrap(buffer), cb = CharBuffer.allocate(buffer.length * 4), true);
        if (!result.isError()) {
            return new String(cb.array(), 0, cb.position());
        }
        throw new CharacterCodingException();
    }

    @Override
    public void store(OutputStream out, String msg) throws IOException {
        String[] lines;
        StringWriter sw = new StringWriter();
        super.store(sw, null);
        for (String line : lines = ((Object)sw).toString().split("\n\r?")) {
            if (line.startsWith("#")) continue;
            out.write(line.getBytes(UTF8));
            out.write("\n".getBytes(UTF8));
        }
    }

    @Override
    public void store(Writer out, String msg) throws IOException {
        String[] lines;
        StringWriter sw = new StringWriter();
        super.store(sw, null);
        for (String line : lines = ((Object)sw).toString().split("\n\r?")) {
            if (line.startsWith("#")) continue;
            out.write(line);
            out.write("\n");
        }
    }

    public void store(OutputStream out) throws IOException {
        this.store(out, null);
    }
}

