/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.service.url.State;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.cryptography.SHA1;
import aQute.maven.api.Archive;
import aQute.maven.api.Program;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenFileRepository;
import aQute.maven.provider.MavenRemoteRepository;
import aQute.maven.provider.MetadataParser;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MavenBackingRepository
implements Closeable {
    static final Pattern DIGEST_POLLUTED = Pattern.compile("(.+=\\s*)?(?<digest>([0-9A-F][0-9A-F])+)\\s*", 2);
    final Map<Revision, MetadataParser.RevisionMetadata> revisions = new ConcurrentHashMap<Revision, MetadataParser.RevisionMetadata>();
    final Map<Program, MetadataParser.ProgramMetadata> programs = new ConcurrentHashMap<Program, MetadataParser.ProgramMetadata>();
    final String id;
    final File local;
    final Reporter reporter;

    public MavenBackingRepository(File root, String base, Reporter reporter) throws Exception {
        this.local = root;
        this.reporter = reporter;
        this.id = MavenBackingRepository.toName(base);
    }

    public static String toName(String uri) throws Exception {
        String s = SHA1.digest(uri.getBytes(StandardCharsets.UTF_8)).asHex();
        return s.substring(0, 8);
    }

    public abstract TaggedData fetch(String var1, File var2) throws Exception;

    protected void checkDigest(String fileDigest, String remoteDigest, File file) {
        if (remoteDigest == null) {
            return;
        }
        Matcher m = DIGEST_POLLUTED.matcher(remoteDigest);
        if (m.matches()) {
            remoteDigest = m.group("digest");
        }
        try {
            int start;
            for (start = 0; start < remoteDigest.length() && Character.isWhitespace(remoteDigest.charAt(start)); ++start) {
            }
            for (int i = 0; i < fileDigest.length(); ++i) {
                char them;
                char us;
                if (start + i < remoteDigest.length() && ((us = fileDigest.charAt(i)) == (them = remoteDigest.charAt(start + i)) || Character.toLowerCase(us) == Character.toLowerCase(them))) continue;
                throw new IllegalArgumentException("Invalid checksum content " + remoteDigest + " for " + file);
            }
        }
        catch (Exception e) {
            file.delete();
            throw e;
        }
    }

    public abstract void store(File var1, String var2) throws Exception;

    public abstract boolean delete(String var1) throws Exception;

    @Override
    public void close() {
    }

    public abstract URI toURI(String var1) throws Exception;

    public void getRevisions(Program program, List<Revision> revisions) throws Exception {
        MetadataParser.ProgramMetadata meta = this.getMetadata(program);
        if (meta == null) {
            return;
        }
        for (MavenVersion v : meta.versions) {
            revisions.add(program.version(v));
        }
    }

    MetadataParser.RevisionMetadata getMetadata(Revision revision) throws Exception {
        File metafile = IO.getFile(this.local, revision.metadata(this.id));
        MetadataParser.RevisionMetadata metadata = this.revisions.get(revision);
        TaggedData tag = this.fetch(revision.metadata(), metafile);
        if (tag.getState() == State.NOT_FOUND || tag.getState() == State.OTHER) {
            if (metadata == null) {
                metadata = new MetadataParser.RevisionMetadata();
                this.revisions.put(revision, metadata);
            }
            return metadata;
        }
        if (metadata == null || tag.getState() == State.UPDATED) {
            metadata = MetadataParser.parseRevisionMetadata(metafile);
            this.revisions.put(revision, metadata);
        }
        return metadata;
    }

    MetadataParser.ProgramMetadata getMetadata(Program program) throws Exception {
        File metafile = IO.getFile(this.local, program.metadata(this.id));
        MetadataParser.ProgramMetadata metadata = this.programs.get(program);
        TaggedData tag = this.fetch(program.metadata(), metafile);
        switch (tag.getState()) {
            case NOT_FOUND: {
                return null;
            }
            case OTHER: {
                throw new IOException("Failed " + tag.getResponseCode());
            }
            case UNMODIFIED: {
                if (metadata == null) break;
                return metadata;
            }
        }
        metadata = MetadataParser.parseProgramMetadata(metafile);
        this.programs.put(program, metadata);
        return metadata;
    }

    public List<Archive> getSnapshotArchives(Revision revision) throws Exception {
        MetadataParser.RevisionMetadata metadata = this.getMetadata(revision);
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (MetadataParser.SnapshotVersion snapshotVersion : metadata.snapshotVersions) {
            Archive archive = revision.archive(snapshotVersion.value, snapshotVersion.extension, snapshotVersion.classifier);
            archives.add(archive);
        }
        return archives;
    }

    public MavenVersion getVersion(Revision revision) throws Exception {
        MetadataParser.RevisionMetadata metadata = this.getMetadata(revision);
        if (metadata.snapshot.timestamp == null || metadata.snapshot.buildNumber == null) {
            this.reporter.warning("Snapshot and/or buildnumber not set %s in %s", new Object[]{metadata.snapshot, revision});
            return null;
        }
        return revision.version.toSnapshot(metadata.snapshot.timestamp, metadata.snapshot.buildNumber);
    }

    public String getId() {
        return this.id;
    }

    public abstract String toString();

    public String getUser() throws Exception {
        return null;
    }

    public static List<MavenBackingRepository> create(String urls, Reporter reporter, File localRepo, HttpClient client) throws Exception {
        if (urls == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenBackingRepository> result = new ArrayList<MavenBackingRepository>();
        List<String> parts = Strings.split(urls);
        for (String part : parts) {
            MavenBackingRepository mbr = MavenBackingRepository.getBackingRepository(part, reporter, localRepo, client);
            result.add(mbr);
        }
        return result;
    }

    public static MavenBackingRepository getBackingRepository(String url, Reporter reporter, File localRepo, HttpClient client) throws Exception {
        URI uri = new URI(url = MavenBackingRepository.clean(url));
        if (uri.getScheme() == null) {
            File file = IO.getFile(uri.getPath());
            uri = file.toURI();
        }
        if (uri.getScheme().equalsIgnoreCase("file")) {
            File remote = new File(uri);
            return new MavenFileRepository(localRepo, remote, reporter);
        }
        return new MavenRemoteRepository(localRepo, client, url, reporter);
    }

    public static String clean(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }

    public abstract boolean isFile();
}

