/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.backwardRefs.index.CompilerIndices;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class CompilerBackwardReferenceIndex {
    private static final Logger LOG = Logger.getInstance(CompilerBackwardReferenceIndex.class);
    private static final String FILE_ENUM_TAB = "file.path.enum.tab";
    private static final String NAME_ENUM_TAB = "name.tab";
    private static final String VERSION_FILE = "version";
    private final Map<IndexId<?, ?>, InvertedIndex<?, ?, CompiledFileData>> myIndices;
    private final NameEnumerator myNameEnumerator;
    private final PersistentStringEnumerator myFilePathEnumerator;
    private final File myIndicesDir;
    private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameEnumerator nameEnumerator = CompilerBackwardReferenceIndex.this.myNameEnumerator;
            synchronized (nameEnumerator) {
                if (!CompilerBackwardReferenceIndex.this.myNameEnumerator.isClosed()) {
                    CompilerBackwardReferenceIndex.this.myNameEnumerator.force();
                }
            }
            nameEnumerator = CompilerBackwardReferenceIndex.this.myFilePathEnumerator;
            synchronized (nameEnumerator) {
                if (!CompilerBackwardReferenceIndex.this.myFilePathEnumerator.isClosed()) {
                    CompilerBackwardReferenceIndex.this.myFilePathEnumerator.force();
                }
            }
        }
    });
    private volatile Exception myRebuildRequestCause;

    public CompilerBackwardReferenceIndex(File buildDir, boolean readOnly) {
        this.myIndicesDir = CompilerBackwardReferenceIndex.getIndexDir(buildDir);
        if (!this.myIndicesDir.exists() && !this.myIndicesDir.mkdirs()) {
            throw new RuntimeException("Can't create dir: " + buildDir.getAbsolutePath());
        }
        try {
            if (CompilerBackwardReferenceIndex.versionDiffers(buildDir)) {
                this.saveVersion(buildDir);
            }
            this.myFilePathEnumerator = new PersistentStringEnumerator(new File(this.myIndicesDir, FILE_ENUM_TAB)){

                public int enumerate(String value) throws IOException {
                    return super.enumerate(SystemInfo.isFileSystemCaseSensitive ? value : value.toLowerCase(Locale.ROOT));
                }
            };
            this.myIndices = new HashMap();
            for (IndexExtension<?, ?, CompiledFileData> indexExtension : CompilerIndices.getIndices()) {
                this.myIndices.put((IndexId<?, ?>)indexExtension.getName(), (InvertedIndex<?, ?, CompiledFileData>)new CompilerMapReduceIndex(indexExtension, this.myIndicesDir, readOnly));
            }
            this.myNameEnumerator = new NameEnumerator(new File(this.myIndicesDir, NAME_ENUM_TAB));
        }
        catch (IOException e) {
            CompilerBackwardReferenceIndex.removeIndexFiles(this.myIndicesDir);
            throw new BuildDataCorruptedException(e);
        }
    }

    Collection<InvertedIndex<?, ?, CompiledFileData>> getIndices() {
        return this.myIndices.values();
    }

    public <K, V> InvertedIndex<K, V, CompiledFileData> get(IndexId<K, V> key) {
        return this.myIndices.get(key);
    }

    @NotNull
    public NameEnumerator getByteSeqEum() {
        NameEnumerator nameEnumerator = this.myNameEnumerator;
        if (nameEnumerator == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(0);
        }
        return nameEnumerator;
    }

    @NotNull
    public PersistentStringEnumerator getFilePathEnumerator() {
        PersistentStringEnumerator persistentStringEnumerator = this.myFilePathEnumerator;
        if (persistentStringEnumerator == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(1);
        }
        return persistentStringEnumerator;
    }

    public void close() {
        this.myLowMemoryWatcher.stop();
        CommonProcessors.FindFirstProcessor exceptionProc = new CommonProcessors.FindFirstProcessor();
        CompilerBackwardReferenceIndex.close((Closeable)this.myFilePathEnumerator, (Processor<Exception>)exceptionProc);
        CompilerBackwardReferenceIndex.close((Closeable)((Object)this.myNameEnumerator), (Processor<Exception>)exceptionProc);
        for (InvertedIndex<?, ?, CompiledFileData> index : this.myIndices.values()) {
            CompilerBackwardReferenceIndex.close(index, (CommonProcessors.FindFirstProcessor<Exception>)exceptionProc);
        }
        Exception exception = (Exception)exceptionProc.getFoundValue();
        if (exception != null) {
            CompilerBackwardReferenceIndex.removeIndexFiles(this.myIndicesDir);
            if (this.myRebuildRequestCause == null) {
                throw new RuntimeException(exception);
            }
            return;
        }
        if (this.myRebuildRequestCause != null) {
            CompilerBackwardReferenceIndex.removeIndexFiles(this.myIndicesDir);
        }
    }

    Exception getRebuildRequestCause() {
        return this.myRebuildRequestCause;
    }

    File getIndicesDir() {
        return this.myIndicesDir;
    }

    public static void removeIndexFiles(File buildDir) {
        File indexDir = CompilerBackwardReferenceIndex.getIndexDir(buildDir);
        if (indexDir.exists()) {
            FileUtil.delete((File)indexDir);
        }
    }

    private static File getIndexDir(@NotNull File buildDir) {
        if (buildDir == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(2);
        }
        return new File(buildDir, "backward-refs");
    }

    public static boolean exist(@NotNull File buildDir) {
        if (buildDir == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(3);
        }
        return CompilerBackwardReferenceIndex.getIndexDir(buildDir).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean versionDiffers(@NotNull File buildDir) {
        boolean bl;
        if (buildDir == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(4);
        }
        File versionFile = new File(CompilerBackwardReferenceIndex.getIndexDir(buildDir), VERSION_FILE);
        DataInputStream is = new DataInputStream(new FileInputStream(versionFile));
        try {
            boolean isDiffer;
            int currentIndexVersion = is.readInt();
            boolean bl2 = isDiffer = currentIndexVersion != 6;
            if (isDiffer) {
                LOG.info("backward reference index version differ, expected = 6, current = " + currentIndexVersion);
            }
            bl = isDiffer;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ignored) {
                LOG.info("backward reference index version differ due to: " + ignored.getClass());
                return true;
            }
        }
        is.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveVersion(@NotNull File buildDir) {
        if (buildDir == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(5);
        }
        File versionFile = new File(CompilerBackwardReferenceIndex.getIndexDir(buildDir), VERSION_FILE);
        try {
            FileUtil.createIfDoesntExist((File)versionFile);
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(versionFile));){
                os.writeInt(6);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
            throw new BuildDataCorruptedException(ex);
        }
    }

    void setRebuildRequestCause(Exception e) {
        this.myRebuildRequestCause = e;
    }

    private static void close(InvertedIndex<?, ?, CompiledFileData> index, CommonProcessors.FindFirstProcessor<Exception> exceptionProcessor) {
        try {
            index.dispose();
        }
        catch (RuntimeException e) {
            exceptionProcessor.process((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Closeable closeable, Processor<Exception> exceptionProcessor) {
        Closeable closeable2 = closeable;
        synchronized (closeable2) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                exceptionProcessor.process((Object)new BuildDataCorruptedException(e));
            }
        }
    }

    private static <Key, Value> IndexStorage<Key, Value> createIndexStorage(@NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, @NotNull IndexId<Key, Value> indexId, @NotNull File indexDir, boolean readOnly) throws IOException {
        if (keyDescriptor == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(6);
        }
        if (valueExternalizer == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(7);
        }
        if (indexId == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(8);
        }
        if (indexDir == null) {
            CompilerBackwardReferenceIndex.$$$reportNull$$$0(9);
        }
        return new MapIndexStorage<Key, Value>(new File(indexDir, indexId.getName()), keyDescriptor, valueExternalizer, 16384, false, true, readOnly){

            public void checkCanceled() {
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteSeqEum";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathEnumerator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exist";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "versionDiffers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveVersion";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createIndexStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class CompilerMapReduceIndex<Key, Value>
    extends MapReduceIndex<Key, Value, CompiledFileData> {
        public CompilerMapReduceIndex(final @NotNull IndexExtension<Key, Value, CompiledFileData> extension, final File indexDir, boolean readOnly) throws IOException {
            if (extension == null) {
                CompilerMapReduceIndex.$$$reportNull$$$0(0);
            }
            if (indexDir == null) {
                CompilerMapReduceIndex.$$$reportNull$$$0(1);
            }
            super(extension, CompilerBackwardReferenceIndex.createIndexStorage(extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getName(), indexDir, readOnly), (ForwardIndex)(readOnly ? null : new KeyCollectionBasedForwardIndex<Key, Value>(extension){

                @NotNull
                public PersistentHashMap<Integer, Collection<Key>> createMap() throws IOException {
                    IndexId id = this.getIndexExtension().getName();
                    PersistentHashMap persistentHashMap = new PersistentHashMap(new File(indexDir, id.getName() + ".inputs"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new InputIndexDataExternalizer(extension.getKeyDescriptor(), id));
                    if (persistentHashMap == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return persistentHashMap;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex$CompilerMapReduceIndex$1", "createMap"));
                }
            }));
        }

        public void checkCanceled() {
        }

        protected void requestRebuild(Exception e) {
            CompilerBackwardReferenceIndex.this.setRebuildRequestCause(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexDir";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex$CompilerMapReduceIndex";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

