/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.internal;

import com.springsource.util.osgi.PackageAdminUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardPackageAdminUtil
implements PackageAdminUtil {
    private static final String PACKAGE_ADMIN_CLASS = "org.osgi.service.packageadmin.PackageAdmin";
    private static final long SLEEP_INTERVAL_MS = 50L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardPackageAdminUtil.class);
    private Object monitor = new Object();
    private boolean started = true;
    private final PackageAdmin packageAdmin;
    private final FrameworkListener frameworkListener;
    private ServiceReference packageAdminServiceReference;
    private final BundleContext bundleContext;
    private volatile boolean refreshComplete = true;

    public StandardPackageAdminUtil(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.packageAdminServiceReference = bundleContext.getServiceReference(PACKAGE_ADMIN_CLASS);
        this.packageAdmin = (PackageAdmin)bundleContext.getService(this.packageAdminServiceReference);
        this.frameworkListener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    Object object = StandardPackageAdminUtil.this.monitor;
                    synchronized (object) {
                        StandardPackageAdminUtil.this.refreshComplete = true;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Packages refreshed");
                    }
                }
            }
        };
        this.bundleContext.addFrameworkListener(this.frameworkListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                this.started = false;
                this.bundleContext.ungetService(this.packageAdminServiceReference);
                this.bundleContext.removeFrameworkListener(this.frameworkListener);
                this.refreshComplete = true;
            }
        }
    }

    public void refreshPackages(Bundle[] bundles, long timeoutMillis) {
        this.ensurePreviousRefreshComplete();
        this.packageAdmin.refreshPackages(bundles);
        this.waitForRefreshToComplete(timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePreviousRefreshComplete() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ensuring previous refresh complete");
        }
        while (true) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.refreshComplete) {
                    this.refreshComplete = false;
                    break;
                }
            }
            this.sleep(50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRefreshToComplete(long timeoutMillis) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("waiting for refresh to complete");
        }
        long remainingTimeoutMillis = timeoutMillis;
        while (!this.refreshComplete && remainingTimeoutMillis > 0L) {
            this.sleep(50L);
            remainingTimeoutMillis -= 50L;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.refreshComplete = true;
        }
    }

    private void sleep(long interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException interruptedException) {}
    }
}

