/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.partialmanifest;

import com.springsource.bundlor.support.partialmanifest.ReadablePartialManifest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardReadablePartialManifest
implements ReadablePartialManifest {
    private static final String[] EXCLUDED_PREFIXES = new String[]{"java.", "sun."};
    public final Set<String> exportedPackages = new TreeSet<String>();
    private final Set<String> importedTypes = new TreeSet<String>();
    private final Map<String, Set<String>> uses = new HashMap<String, Set<String>>();
    private final Set<String> localTypes = new TreeSet<String>();
    private final Set<String> referencedPackages = new TreeSet<String>();
    private boolean condensed = false;
    private final Set<String> importedPackages = new TreeSet<String>();
    public final Map<String, Set<String>> unsatisfiedTypesByPackage = new HashMap<String, Set<String>>();
    public static final Set<String> EMPTY_SET = new TreeSet<String>();

    @Override
    public void recordExportPackage(String packageName) {
        if (this.isRecordablePackage(packageName)) {
            this.exportedPackages.add(packageName);
        }
    }

    protected void unrecordExportPackage(String packageName) {
        if (packageName != null) {
            this.exportedPackages.remove(packageName);
        }
    }

    public void condense() {
        if (!this.condensed) {
            this.importedPackages.clear();
            this.unsatisfiedTypesByPackage.clear();
            TreeSet<String> unsatisfiableTypes = new TreeSet<String>(this.importedTypes);
            unsatisfiableTypes.removeAll(this.localTypes);
            for (String unsatisfiableType : unsatisfiableTypes) {
                String packageName = StandardReadablePartialManifest.getPackageName(unsatisfiableType);
                this.getUnsatisfiedTypesForPackage(packageName).add(unsatisfiableType);
                if (!this.isRecordablePackage(packageName)) continue;
                this.importedPackages.add(packageName);
            }
            this.condensed = true;
            this.referencedPackages.removeAll(this.exportedPackages);
            this.importedPackages.addAll(this.referencedPackages);
        }
    }

    @Override
    public boolean isRecordablePackage(String packageName) {
        if (packageName == null) {
            return false;
        }
        String[] stringArray = EXCLUDED_PREFIXES;
        int n = EXCLUDED_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (packageName.startsWith(prefix)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Set<String> getUnsatisfiedTypesForPackage(String packageName) {
        Set<String> typesInPackage = this.unsatisfiedTypesByPackage.get(packageName);
        if (typesInPackage == null) {
            typesInPackage = new TreeSet<String>();
            this.unsatisfiedTypesByPackage.put(packageName, typesInPackage);
        }
        return typesInPackage;
    }

    protected static String getPackageName(String fullyQualifiedTypeName) {
        int index;
        if (fullyQualifiedTypeName != null && (index = fullyQualifiedTypeName.lastIndexOf(46)) > -1) {
            return fullyQualifiedTypeName.substring(0, index);
        }
        return null;
    }

    @Override
    public void recordUsesPackage(String usingPackage, String usedPackage) {
        if (this.isRecordablePackage(usingPackage) && this.isRecordablePackage(usedPackage) && !usingPackage.equals(usedPackage)) {
            Set<String> usesSet = this.getUsesSet(usingPackage);
            usesSet.add(usedPackage);
        }
    }

    protected void removeUses(String usingPackage, Set<String> usedPackages) {
        if (usedPackages.size() > 0) {
            Set<String> existingUses = this.uses.get(usingPackage);
            existingUses.removeAll(usedPackages);
            if (existingUses.size() == 0) {
                this.uses.remove(usingPackage);
            }
        }
    }

    @Override
    public Set<String> getExportedPackages() {
        this.condense();
        return this.exportedPackages;
    }

    @Override
    public Set<String> getImportedPackages() {
        this.condense();
        return this.importedPackages;
    }

    @Override
    public Set<String> getUses(String exportingPackage) {
        return this.getUsesSet(exportingPackage);
    }

    private Set<String> getUsesSet(String exportingPackage) {
        Set<String> usesSet = this.uses.get(exportingPackage);
        if (usesSet == null) {
            usesSet = new TreeSet<String>();
            this.uses.put(exportingPackage, usesSet);
        }
        return usesSet;
    }

    @Override
    public void recordReferencedType(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName != null) {
            this.condensed = false;
            this.importedTypes.add(fullyQualifiedTypeName);
        }
    }

    @Override
    public void recordReferencedPackage(String fullyQualifiedPackageName) {
        if (fullyQualifiedPackageName != null && this.isRecordablePackage(fullyQualifiedPackageName)) {
            this.condensed = false;
            this.referencedPackages.add(fullyQualifiedPackageName);
        }
    }

    protected void removeImportedType(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName != null) {
            this.condensed = false;
            this.importedTypes.remove(fullyQualifiedTypeName);
        }
    }

    protected void removeReferencedPackage(String fullyQualifiedPackageName) {
        if (fullyQualifiedPackageName != null) {
            this.condensed = false;
            this.referencedPackages.remove(fullyQualifiedPackageName);
        }
    }

    @Override
    public void recordType(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName != null) {
            this.recordExportPackage(StandardReadablePartialManifest.getPackageName(fullyQualifiedTypeName));
            this.condensed = false;
            this.localTypes.add(fullyQualifiedTypeName);
        }
    }

    protected void unrecordType(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName != null) {
            this.condensed = false;
            this.localTypes.remove(fullyQualifiedTypeName);
        }
    }

    @Override
    public Set<String> getUnsatisfiedTypes(String packageName) {
        this.condense();
        Set<String> unsatisfiedTypes = this.unsatisfiedTypesByPackage.get(packageName);
        return unsatisfiedTypes == null ? EMPTY_SET : unsatisfiedTypes;
    }
}

