/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.indexer.Capability;
import org.osgi.service.indexer.Requirement;
import org.osgi.service.indexer.ResourceAnalyzer;
import org.osgi.service.indexer.ResourceIndexer;
import org.osgi.service.indexer.impl.BlueprintAnalyzer;
import org.osgi.service.indexer.impl.BundleAnalyzer;
import org.osgi.service.indexer.impl.ConsoleLogSvc;
import org.osgi.service.indexer.impl.GeneratorState;
import org.osgi.service.indexer.impl.JarResource;
import org.osgi.service.indexer.impl.OSGiFrameworkAnalyzer;
import org.osgi.service.indexer.impl.SCRAnalyzer;
import org.osgi.service.indexer.impl.URLResolver;
import org.osgi.service.indexer.impl.types.TypedValue;
import org.osgi.service.indexer.impl.util.AddOnlyList;
import org.osgi.service.indexer.impl.util.Indent;
import org.osgi.service.indexer.impl.util.Pair;
import org.osgi.service.indexer.impl.util.Tag;
import org.osgi.service.log.LogService;

public class RepoIndex
implements ResourceIndexer {
    public static final String REPOSITORY_INCREMENT_OVERRIDE = "-repository.increment.override";
    private final BundleAnalyzer bundleAnalyzer;
    private final OSGiFrameworkAnalyzer frameworkAnalyzer;
    private final SCRAnalyzer scrAnalyzer;
    private final BlueprintAnalyzer blueprintAnalyzer;
    private final LogService log;
    private final List<Pair<ResourceAnalyzer, Filter>> analyzers = new LinkedList<Pair<ResourceAnalyzer, Filter>>();
    private final List<URLResolver> resolvers = new ArrayList<URLResolver>();

    public RepoIndex() {
        this(new ConsoleLogSvc());
    }

    public RepoIndex(LogService log) {
        this.log = log;
        this.bundleAnalyzer = new BundleAnalyzer(log);
        this.frameworkAnalyzer = new OSGiFrameworkAnalyzer(log);
        this.scrAnalyzer = new SCRAnalyzer(log);
        this.blueprintAnalyzer = new BlueprintAnalyzer(log);
        try {
            Filter allFilter = FrameworkUtil.createFilter("(name=*.jar)");
            this.addAnalyzer(this.bundleAnalyzer, allFilter);
            this.addAnalyzer(this.frameworkAnalyzer, allFilter);
            this.addAnalyzer(this.scrAnalyzer, allFilter);
            this.addAnalyzer(this.blueprintAnalyzer, allFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new ExceptionInInitializerError("Unexpected internal error compiling filter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAnalyzer(ResourceAnalyzer analyzer, Filter filter) {
        List<Pair<ResourceAnalyzer, Filter>> list = this.analyzers;
        synchronized (list) {
            this.analyzers.add(Pair.create(analyzer, filter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAnalyzer(ResourceAnalyzer analyzer, Filter filter) {
        List<Pair<ResourceAnalyzer, Filter>> list = this.analyzers;
        synchronized (list) {
            this.analyzers.remove(Pair.create(analyzer, filter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(Set<File> files, OutputStream out, Map<String, String> config) throws Exception {
        if (config == null) {
            config = new HashMap<String, String>(0);
        }
        TreeSet<File> filesToIndex = new TreeSet<File>();
        if (files != null && !files.isEmpty()) {
            this.resolveDirectories(files, filesToIndex);
        }
        PrintWriter pw = null;
        try {
            String prettySetting = config.get("pretty");
            String compressedSetting = config.get("compressed");
            Indent indent = prettySetting == null || !Boolean.parseBoolean(prettySetting) && compressedSetting != null ? Indent.NONE : Indent.PRETTY;
            boolean compressed = prettySetting == null && compressedSetting == null || Boolean.parseBoolean(compressedSetting);
            pw = !compressed ? new PrintWriter(new OutputStreamWriter(out, "UTF-8")) : new PrintWriter(new GZIPOutputStream(out, 9));
            pw.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            String stylesheet = config.get("stylesheet");
            if (stylesheet != null) {
                indent.print(pw);
                pw.printf("<?xml-stylesheet href=\"%s\" type=\"%s\"?>", stylesheet, "text/xsl");
            }
            Tag repoTag = new Tag("repository");
            String repoName = config.get("repository.name");
            if (repoName == null) {
                repoName = "Untitled";
            }
            repoTag.addAttribute("name", repoName);
            String increment = config.get(REPOSITORY_INCREMENT_OVERRIDE);
            if (increment == null) {
                increment = Long.toString(System.currentTimeMillis());
            }
            repoTag.addAttribute("increment", increment);
            repoTag.addAttribute("xmlns", "http://www.osgi.org/xmlns/repository/v1.0.0");
            repoTag.printOpen(indent, pw, false);
            for (File file : filesToIndex) {
                try {
                    Tag resourceTag = this.generateResource(file, config);
                    resourceTag.print(indent.next(), pw);
                }
                catch (Exception e) {
                    this.log(2, MessageFormat.format("Could not index {0}, skipped ({1}).", file, e), null);
                }
            }
            repoTag.printClose(indent, pw);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    private void resolveDirectories(Set<File> files, Set<File> filesToIndex) {
        for (File file : files) {
            if (!file.isDirectory()) {
                filesToIndex.add(file);
                continue;
            }
            File[] dirFiles = file.listFiles();
            if (dirFiles.length <= 0) continue;
            LinkedHashSet<File> dirFilesSet = new LinkedHashSet<File>(Arrays.asList(dirFiles));
            this.resolveDirectories(dirFilesSet, filesToIndex);
        }
    }

    @Override
    public void indexFragment(Set<File> files, Writer out, Map<String, String> config) throws Exception {
        PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        for (File file : files) {
            try {
                Tag resourceTag = this.generateResource(file, config);
                resourceTag.print(Indent.PRETTY, pw);
            }
            catch (Exception e) {
                this.log(2, MessageFormat.format("Could not index {0}, skipped ({1}).", file, e), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tag generateResource(File file, Map<String, String> config) throws Exception {
        JarResource resource = new JarResource(file);
        AddOnlyList<Capability> caps = new AddOnlyList<Capability>(new LinkedList());
        AddOnlyList<Requirement> reqs = new AddOnlyList<Requirement>(new LinkedList());
        Tag resourceTag = new Tag("resource");
        try {
            Object rootURL;
            if (config != null) {
                File rootDir;
                String rootURLStr = config.get("root.url");
                rootURL = rootURLStr != null ? ((rootDir = new File(rootURLStr)).isDirectory() ? rootDir.toURI().toURL() : new URL(rootURLStr)) : new File(System.getProperty("user.dir")).toURI().toURL();
                String urlTemplate = config.get("url.template");
                this.bundleAnalyzer.setStateLocal(new GeneratorState(((URL)rootURL).toURI().normalize(), urlTemplate, this.resolvers));
            } else {
                this.bundleAnalyzer.setStateLocal(null);
            }
            try {
                rootURL = this.analyzers;
                synchronized (rootURL) {
                    for (Pair<ResourceAnalyzer, Filter> entry : this.analyzers) {
                        ResourceAnalyzer analyzer = entry.getFirst();
                        Filter filter = entry.getSecond();
                        if (filter != null && !filter.match(resource.getProperties())) continue;
                        try {
                            analyzer.analyzeResource(resource, caps, reqs);
                        }
                        catch (Exception e) {
                            this.log(1, MessageFormat.format("Error calling analyzer \"{0}\" on resource {1}.", analyzer.getClass().getName(), resource.getLocation()), e);
                            StringWriter writer = new StringWriter();
                            Formatter comment = new Formatter(writer);
                            comment.format("Error calling analyzer \"%s\" on resource %s with message %s and stack: ", analyzer.getClass().getName(), resource.getLocation(), e);
                            comment.close();
                            e.printStackTrace(new PrintWriter(writer));
                            resourceTag.addComment(writer.toString());
                        }
                    }
                }
            }
            finally {
                this.bundleAnalyzer.setStateLocal(null);
            }
        }
        finally {
            resource.close();
        }
        for (Capability cap : caps) {
            Tag capTag = new Tag("capability");
            capTag.addAttribute("namespace", cap.getNamespace());
            RepoIndex.appendAttributeAndDirectiveTags(capTag, cap.getAttributes(), cap.getDirectives());
            resourceTag.addContent(capTag);
        }
        for (Requirement req : reqs) {
            Tag reqTag = new Tag("requirement");
            reqTag.addAttribute("namespace", req.getNamespace());
            RepoIndex.appendAttributeAndDirectiveTags(reqTag, req.getAttributes(), req.getDirectives());
            resourceTag.addContent(reqTag);
        }
        return resourceTag;
    }

    private void log(int level, String message, Throwable t) {
        if (this.log != null) {
            this.log.log(level, message, t);
        } else {
            PrintStream ps;
            switch (level) {
                case 4: {
                    return;
                }
                case 3: {
                    ps = System.out;
                    break;
                }
                default: {
                    ps = System.err;
                }
            }
            ps.println(message);
            if (t != null) {
                t.printStackTrace(ps);
            }
        }
    }

    private static void appendAttributeAndDirectiveTags(Tag parentTag, Map<String, Object> attribs, Map<String, String> directives) {
        for (Map.Entry<String, Object> entry : attribs.entrySet()) {
            Tag attribTag = new Tag("attribute");
            attribTag.addAttribute("name", entry.getKey());
            TypedValue value = TypedValue.valueOf(entry.getValue());
            value.addTo(attribTag);
            parentTag.addContent(attribTag);
        }
        for (Map.Entry<String, Object> entry : directives.entrySet()) {
            Tag directiveTag = new Tag("directive");
            directiveTag.addAttribute("name", entry.getKey());
            directiveTag.addAttribute("value", (String)entry.getValue());
            parentTag.addContent(directiveTag);
        }
    }

    public List<ResourceAnalyzer> getAnalyzers() {
        ArrayList<ResourceAnalyzer> list = new ArrayList<ResourceAnalyzer>();
        for (Pair<ResourceAnalyzer, Filter> entry : this.analyzers) {
            list.add(entry.getFirst());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceIndexer.IndexResult indexFile(File file) throws Exception {
        ResourceIndexer.IndexResult result = new ResourceIndexer.IndexResult();
        result.resource = new JarResource(file);
        result.signature = this.getSignature();
        List<Pair<ResourceAnalyzer, Filter>> list = this.analyzers;
        synchronized (list) {
            for (Pair<ResourceAnalyzer, Filter> entry : this.analyzers) {
                ResourceAnalyzer analyzer = entry.getFirst();
                Filter filter = entry.getSecond();
                if (filter != null && !filter.match(result.resource.getProperties())) continue;
                analyzer.analyzeResource(result.resource, result.capabilities, result.requirements);
            }
        }
        return result;
    }

    private long getSignature() {
        long value = 97L;
        for (Pair<ResourceAnalyzer, Filter> ra : this.analyzers) {
            value *= (long)(997 * ra.getFirst().getClass().getName().hashCode() + 13);
        }
        return value;
    }

    @Deprecated
    public void setURLResolver(URLResolver resolver) {
        if (this.resolvers.isEmpty()) {
            this.addURLResolver(resolver);
        } else {
            this.resolvers.set(0, resolver);
        }
    }

    public void addURLResolver(URLResolver resolver) {
        this.resolvers.add(resolver);
    }
}

