/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.compiler.instrumentation.FailSafeMethodVisitor;
import com.intellij.compiler.notNullVerification.AuxiliaryMethodGenerator;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

public class NotNullVerifyingInstrumenter
extends ClassVisitor
implements Opcodes {
    private static final String IAE_CLASS_NAME = "java/lang/IllegalArgumentException";
    private static final String ISE_CLASS_NAME = "java/lang/IllegalStateException";
    private static final String ANNOTATION_DEFAULT_METHOD = "value";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Map<String, Map<Integer, String>> myMethodParamNames;
    private String myClassName;
    private boolean myIsModification = false;
    private RuntimeException myPostponedError;
    private final AuxiliaryMethodGenerator myAuxGenerator;
    private final Set<String> myNotNullAnnos = new HashSet<String>();
    private boolean myStatic;
    private boolean myInner;

    private NotNullVerifyingInstrumenter(ClassVisitor classVisitor, ClassReader reader, String[] notNullAnnotations) {
        super(393216, classVisitor);
        for (String annotation : notNullAnnotations) {
            this.myNotNullAnnos.add("L" + annotation.replace('.', '/') + ";");
        }
        this.myMethodParamNames = NotNullVerifyingInstrumenter.getAllParameterNames(reader);
        this.myAuxGenerator = new AuxiliaryMethodGenerator(reader);
    }

    public static boolean processClassFile(FailSafeClassReader reader, ClassVisitor writer, String[] notNullAnnotations) {
        NotNullVerifyingInstrumenter instrumenter = new NotNullVerifyingInstrumenter(writer, reader, notNullAnnotations);
        reader.accept(instrumenter, 0);
        instrumenter.myAuxGenerator.generateReportingMethod(writer);
        return instrumenter.isModification();
    }

    private static Map<String, Map<Integer, String>> getAllParameterNames(ClassReader reader) {
        final LinkedHashMap<String, Map<Integer, String>> methodParamNames = new LinkedHashMap<String, Map<Integer, String>>();
        reader.accept(new ClassVisitor(393216){
            private String myClassName;
            {
                super(x0);
                this.myClassName = null;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.myClassName = name;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                String methodName = this.myClassName + '.' + name + desc;
                final LinkedHashMap names = new LinkedHashMap();
                Type[] args = Type.getArgumentTypes((String)desc);
                methodParamNames.put(methodName, names);
                final LinkedHashMap<Integer, Integer> paramSlots = new LinkedHashMap<Integer, Integer>();
                int slotIndex = NotNullVerifyingInstrumenter.isStatic(access) ? 0 : 1;
                for (int paramIndex = 0; paramIndex < args.length; ++paramIndex) {
                    Type arg = args[paramIndex];
                    paramSlots.put(slotIndex, paramIndex);
                    slotIndex += arg.getSize();
                }
                return new MethodVisitor(this.api){

                    public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int slotIndex) {
                        Integer paramIndex = (Integer)paramSlots.get(slotIndex);
                        if (paramIndex != null) {
                            names.put(paramIndex, name2);
                        }
                    }
                };
            }
        }, 0);
        return methodParamNames;
    }

    public boolean isModification() {
        return this.myIsModification;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myClassName = name;
        this.myStatic = NotNullVerifyingInstrumenter.isStatic(access);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.myInner = true;
    }

    public MethodVisitor visitMethod(final int access, final String name, String desc, String signature, String[] exceptions) {
        int syntheticCount;
        boolean hasOuterClassParameter;
        if ((access & 0x40) != 0) {
            return new FailSafeMethodVisitor(393216, super.visitMethod(access, name, desc, signature, exceptions));
        }
        final Type[] args = Type.getArgumentTypes((String)desc);
        boolean bl = hasOuterClassParameter = this.myInner && !this.myStatic && "<init>".equals(name);
        int n = signature == null ? 0 : (syntheticCount = hasOuterClassParameter ? 1 : Math.max(0, args.length - NotNullVerifyingInstrumenter.getSignatureParameterCount(signature)));
        final int paramAnnotationOffset = signature == null ? 0 : (hasOuterClassParameter ? Math.max(0, args.length - NotNullVerifyingInstrumenter.getSignatureParameterCount(signature) - 1) : 0);
        final Type returnType = Type.getReturnType((String)desc);
        MethodVisitor v = this.cv.visitMethod(access, name, desc, signature, exceptions);
        final Map<Integer, String> paramNames = this.myMethodParamNames.get(this.myClassName + '.' + name + desc);
        return new FailSafeMethodVisitor(393216, v){
            private final Map<Integer, NotNullState> myNotNullParams;
            private NotNullState myMethodNotNull;
            private Label myStartGeneratedCodeLabel;
            {
                super(api, mv);
                this.myNotNullParams = new LinkedHashMap<Integer, NotNullState>();
            }

            private AnnotationVisitor collectNotNullArgs(AnnotationVisitor base, final NotNullState state) {
                return new AnnotationVisitor(393216, base){

                    public void visit(String methodName, Object o) {
                        if (NotNullVerifyingInstrumenter.ANNOTATION_DEFAULT_METHOD.equals(methodName) && !((String)o).isEmpty()) {
                            state.message = (String)o;
                        } else if ("exception".equals(methodName) && o instanceof Type && !((Type)o).getClassName().equals(Exception.class.getName())) {
                            state.exceptionType = ((Type)o).getInternalName();
                        }
                        super.visit(methodName, o);
                    }
                };
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                AnnotationVisitor av = this.mv.visitTypeAnnotation(typeRef, null, desc, visible);
                if (typePath != null) {
                    return av;
                }
                TypeReference ref = new TypeReference(typeRef);
                if (ref.getSort() == 20) {
                    return this.checkNotNullMethod(desc, av);
                }
                if (ref.getSort() == 22) {
                    return this.checkNotNullParameter(ref.getFormalParameterIndex() + syntheticCount, desc, av);
                }
                return av;
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String anno, boolean visible) {
                AnnotationVisitor base = this.mv.visitParameterAnnotation(parameter, anno, visible);
                if (parameter < paramAnnotationOffset) {
                    return base;
                }
                return this.checkNotNullParameter(parameter - paramAnnotationOffset, anno, base);
            }

            private AnnotationVisitor checkNotNullParameter(int parameter, String anno, AnnotationVisitor av) {
                if (parameter >= 0 && parameter < args.length && NotNullVerifyingInstrumenter.isReferenceType(args[parameter]) && NotNullVerifyingInstrumenter.this.myNotNullAnnos.contains(anno)) {
                    NotNullState state = new NotNullState(anno, NotNullVerifyingInstrumenter.IAE_CLASS_NAME);
                    this.myNotNullParams.put(parameter, state);
                    return this.collectNotNullArgs(av, state);
                }
                return av;
            }

            public AnnotationVisitor visitAnnotation(String anno, boolean isRuntime) {
                return this.checkNotNullMethod(anno, this.mv.visitAnnotation(anno, isRuntime));
            }

            private AnnotationVisitor checkNotNullMethod(String anno, AnnotationVisitor av) {
                if (NotNullVerifyingInstrumenter.isReferenceType(returnType) && NotNullVerifyingInstrumenter.this.myNotNullAnnos.contains(anno)) {
                    this.myMethodNotNull = new NotNullState(anno, NotNullVerifyingInstrumenter.ISE_CLASS_NAME);
                    return this.collectNotNullArgs(av, this.myMethodNotNull);
                }
                return av;
            }

            public void visitCode() {
                if (this.myNotNullParams.size() > 0) {
                    this.myStartGeneratedCodeLabel = new Label();
                    this.mv.visitLabel(this.myStartGeneratedCodeLabel);
                }
                for (Map.Entry<Integer, NotNullState> entry : this.myNotNullParams.entrySet()) {
                    String[] stringArray;
                    Integer param = entry.getKey();
                    int var = (access & 8) == 0 ? 1 : 0;
                    for (int i = 0; i < param; ++i) {
                        var += args[i].getSize();
                    }
                    this.mv.visitVarInsn(25, var);
                    Label end = new Label();
                    this.mv.visitJumpInsn(199, end);
                    NotNullState state = entry.getValue();
                    String paramName = paramNames == null ? null : (String)paramNames.get(param);
                    String descrPattern = state.getNullParamMessage(paramName);
                    if (state.message != null) {
                        stringArray = EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = paramName != null ? paramName : String.valueOf(param - syntheticCount);
                        stringArray2[1] = NotNullVerifyingInstrumenter.this.myClassName;
                        stringArray = stringArray2;
                        stringArray2[2] = name;
                    }
                    String[] args2 = stringArray;
                    this.reportError(state.exceptionType, end, descrPattern, args2);
                }
            }

            public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int index) {
                boolean isParameterOrThisRef = NotNullVerifyingInstrumenter.isStatic(access) ? index < args.length : index <= args.length;
                Label label = isParameterOrThisRef && this.myStartGeneratedCodeLabel != null ? this.myStartGeneratedCodeLabel : start;
                this.mv.visitLocalVariable(name2, desc, signature, label, end, index);
            }

            public void visitInsn(int opcode) {
                if (opcode == 176 && this.myMethodNotNull != null) {
                    String[] stringArray;
                    this.mv.visitInsn(89);
                    Label skipLabel = new Label();
                    this.mv.visitJumpInsn(199, skipLabel);
                    String descrPattern = this.myMethodNotNull.getNullResultMessage();
                    if (this.myMethodNotNull.message != null) {
                        stringArray = EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = NotNullVerifyingInstrumenter.this.myClassName;
                        stringArray = stringArray2;
                        stringArray2[1] = name;
                    }
                    String[] args2 = stringArray;
                    this.reportError(this.myMethodNotNull.exceptionType, skipLabel, descrPattern, args2);
                }
                this.mv.visitInsn(opcode);
            }

            private void reportError(String exceptionClass, Label end, String descrPattern, String[] args2) {
                NotNullVerifyingInstrumenter.this.myAuxGenerator.reportError(this.mv, NotNullVerifyingInstrumenter.this.myClassName, exceptionClass, descrPattern, args2);
                this.mv.visitLabel(end);
                NotNullVerifyingInstrumenter.this.myIsModification = true;
                NotNullVerifyingInstrumenter.this.processPostponedErrors();
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                try {
                    super.visitMaxs(maxStack, maxLocals);
                }
                catch (Throwable e) {
                    NotNullVerifyingInstrumenter.this.registerError(name, "visitMaxs", e);
                }
            }
        };
    }

    private static boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    private static int getSignatureParameterCount(String signature) {
        final int[] count = new int[]{0};
        new SignatureReader(signature).accept(new SignatureVisitor(393216){

            public SignatureVisitor visitParameterType() {
                count[0] = count[0] + 1;
                return super.visitParameterType();
            }
        });
        return count[0];
    }

    private static boolean isReferenceType(Type type) {
        return type.getSort() == 10 || type.getSort() == 9;
    }

    private void registerError(String methodName, String operationName, Throwable e) {
        if (this.myPostponedError == null) {
            Throwable err = e.getCause();
            if (err == null) {
                err = e;
            }
            StringBuilder message = new StringBuilder();
            message.append("Operation '").append(operationName).append("' failed for ").append(this.myClassName).append(".").append(methodName).append("(): ");
            String errMessage = err.getMessage();
            if (errMessage != null) {
                message.append(errMessage);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            err.printStackTrace(new PrintStream(out));
            message.append('\n').append(out.toString());
            this.myPostponedError = new RuntimeException(message.toString(), err);
        }
        if (this.myIsModification) {
            this.processPostponedErrors();
        }
    }

    private void processPostponedErrors() {
        RuntimeException error = this.myPostponedError;
        if (error != null) {
            throw error;
        }
    }

    private static class NotNullState {
        String message;
        String exceptionType;
        final String notNullAnno;

        NotNullState(String notNullAnno, String exceptionType) {
            this.notNullAnno = notNullAnno;
            this.exceptionType = exceptionType;
        }

        String getNullParamMessage(String paramName) {
            if (this.message != null) {
                return this.message;
            }
            String shortName = this.getAnnoShortName();
            if (paramName != null) {
                return "Argument for @" + shortName + " parameter '%s' of %s.%s must not be null";
            }
            return "Argument %s for @" + shortName + " parameter of %s.%s must not be null";
        }

        String getNullResultMessage() {
            if (this.message != null) {
                return this.message;
            }
            String shortName = this.getAnnoShortName();
            return "@" + shortName + " method %s.%s must not return null";
        }

        private String getAnnoShortName() {
            String fullName = this.notNullAnno.substring(1, this.notNullAnno.length() - 1);
            return fullName.substring(fullName.lastIndexOf(47) + 1);
        }
    }
}

