/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.osgi.jps.build.BndWrapper;
import org.jetbrains.osgi.jps.build.BundlorWrapper;
import org.jetbrains.osgi.jps.build.LocalPackageCollector;
import org.jetbrains.osgi.jps.build.OsgiBuildException;
import org.jetbrains.osgi.jps.build.OsmorcBuildTarget;
import org.jetbrains.osgi.jps.build.Reporter;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.jetbrains.osgi.jps.model.OsmorcJarContentEntry;
import org.jetbrains.osgi.jps.model.impl.JpsOsmorcModuleExtensionImpl;
import org.jetbrains.osgi.jps.util.OsgiBuildUtil;

public class OsgiBuildSession
implements Reporter {
    private static final Logger LOG = Logger.getInstance(OsgiBuildSession.class);
    private OsmorcBuildTarget myTarget;
    private CompileContext myContext;
    private JpsOsmorcModuleExtension myExtension;
    private JpsModule myModule;
    private String myMessagePrefix;
    private File myOutputJarFile;
    private Collection<File> myOutputJarFiles;
    private File myModuleOutputDir;
    private File[] myClasses;
    private File[] mySources;
    private BndWrapper myBndWrapper;
    private String mySourceToReport = null;

    public void build(@NotNull OsmorcBuildTarget target, @NotNull CompileContext context) throws IOException {
        if (target == null) {
            OsgiBuildSession.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OsgiBuildSession.$$$reportNull$$$0(1);
        }
        this.myTarget = target;
        this.myContext = context;
        this.myExtension = target.getExtension();
        this.myModule = target.getModule();
        this.myMessagePrefix = "[" + this.myModule.getName() + "] ";
        this.progress("Building OSGi bundle");
        try {
            this.prepare();
            this.doBuild();
        }
        catch (OsgiBuildException e) {
            this.error(e.getMessage(), e.getCause(), e.getSourcePath(), -1);
            return;
        }
        for (File jarFile : this.myOutputJarFiles) {
            if (jarFile.exists()) continue;
            this.error("Bundle was not built: " + jarFile, null, null, -1);
            return;
        }
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        if (logger.isEnabled()) {
            logger.logCompiledFiles(this.myOutputJarFiles, "osgi", "Built OSGi bundles:");
        }
        context.processMessage((BuildMessage)DoneSomethingNotification.INSTANCE);
    }

    private void prepare() throws OsgiBuildException {
        this.myModuleOutputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, false);
        if (this.myModuleOutputDir == null) {
            throw new OsgiBuildException("Unable to determine the compiler output path for the module.");
        }
        String jarFileLocation = this.myExtension.getJarFileLocation();
        if (jarFileLocation.isEmpty()) {
            throw new OsgiBuildException("Bundle path is empty - please check OSGi facet settings.");
        }
        this.myOutputJarFile = new File(jarFileLocation);
        this.myOutputJarFiles = this.myTarget.getOutputRoots(this.myContext);
        for (File file : this.myOutputJarFiles) {
            if (FileUtil.delete((File)file)) continue;
            throw new OsgiBuildException("Can't delete bundle file '" + file + "'.");
        }
        if (!FileUtil.createParentDirs((File)this.myOutputJarFile)) {
            throw new OsgiBuildException("Cannot create a directory for bundles '" + this.myOutputJarFile.getParent() + "'.");
        }
        List classes = ContainerUtil.newSmartList();
        if (this.myModuleOutputDir.exists()) {
            classes.add(this.myModuleOutputDir);
        }
        for (JpsDependencyElement dependency : this.myModule.getDependenciesList().getDependencies()) {
            File outputDir;
            JpsModule module;
            if (!(dependency instanceof JpsModuleDependency) || (module = ((JpsModuleDependency)dependency).getModule()) == null || JpsOsmorcExtensionService.getExtension(module) != null || (outputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(module, false)) == null || !outputDir.exists()) continue;
            classes.add(outputDir);
        }
        this.myClasses = classes.isEmpty() ? ArrayUtil.EMPTY_FILE_ARRAY : classes.toArray(new File[classes.size()]);
        List list = ContainerUtil.newSmartList();
        for (JpsModuleSourceRoot sourceRoot : this.myModule.getSourceRoots()) {
            File sourceDir = sourceRoot.getFile();
            if (!sourceDir.exists()) continue;
            list.add(sourceDir);
        }
        this.mySources = list.isEmpty() ? ArrayUtil.EMPTY_FILE_ARRAY : list.toArray(new File[list.size()]);
        this.myBndWrapper = new BndWrapper(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBuild() throws OsgiBuildException {
        this.progress("Running Bnd to build the bundle");
        if (this.myExtension.isUseBndFile()) {
            String bndPath = this.myExtension.getBndFileLocation();
            File bndFile = OsgiBuildUtil.findFileInModuleContentRoots(this.myModule, bndPath);
            if (bndFile == null || !bndFile.isFile()) {
                throw new OsgiBuildException("Bnd file missing '" + bndPath + "' - please check OSGi facet settings.");
            }
            this.mySourceToReport = bndFile.getAbsolutePath();
            try {
                this.myBndWrapper.build(bndFile, this.myClasses, this.mySources, this.myOutputJarFile);
            }
            catch (Exception e) {
                throw new OsgiBuildException("Unexpected build error", e, null);
            }
            this.mySourceToReport = null;
        } else {
            if (this.myExtension.isUseBundlorFile()) {
                Properties properties;
                String bundlorPath = this.myExtension.getBundlorFileLocation();
                File bundlorFile = OsgiBuildUtil.findFileInModuleContentRoots(this.myModule, bundlorPath);
                if (bundlorFile == null) {
                    throw new OsgiBuildException("Bundlor file missing '" + bundlorPath + "' - please check OSGi facet settings.");
                }
                File tempFile = new File(this.myOutputJarFile.getAbsolutePath() + ".tmp.jar");
                try {
                    properties = Collections.singletonMap("Created-By", "IntelliJ IDEA / OSGi Plugin");
                    this.myBndWrapper.build(properties, this.myClasses, this.mySources, tempFile);
                }
                catch (Exception e) {
                    throw new OsgiBuildException("Unexpected build error", e, null);
                }
                this.progress("Running Bundlor to calculate the manifest");
                try {
                    properties = OsgiBuildUtil.getMavenProjectProperties(this.myContext, this.myModule);
                    List<String> warnings = new BundlorWrapper().wrapModule(properties, tempFile, this.myOutputJarFile, bundlorFile);
                    for (String warning : warnings) {
                        this.warning(warning, null, bundlorFile.getPath(), -1);
                    }
                }
                finally {
                    if (!FileUtil.delete((File)tempFile)) {
                        this.warning("Can't delete temporary file '" + tempFile + "'", null, null, -1);
                    }
                }
            }
            if (this.myExtension.isManifestManuallyEdited() || this.myExtension.isOsmorcControlsManifest()) {
                Map<String, String> buildProperties = this.getBuildProperties();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("build properties: " + buildProperties);
                }
                this.mySourceToReport = this.getSourceFileToReport();
                try {
                    this.myBndWrapper.build(buildProperties, this.myClasses, this.mySources, this.myOutputJarFile);
                }
                catch (Exception e) {
                    throw new OsgiBuildException("Unexpected build error", e, null);
                }
                this.mySourceToReport = null;
            } else {
                ManifestGenerationMode mode = ((JpsOsmorcModuleExtensionImpl)this.myExtension).getProperties().myManifestGenerationMode;
                throw new OsgiBuildException("Internal error (unknown build method `" + (Object)((Object)mode) + "`)");
            }
        }
    }

    @NotNull
    private Map<String, String> getBuildProperties() throws OsgiBuildException {
        String pattern;
        Object custom;
        HashMap properties = ContainerUtil.newHashMap();
        properties.put("Import-Package", "*");
        properties.put("-removeheaders", "Include-Resource,Private-Package");
        if (this.myExtension.isOsmorcControlsManifest()) {
            properties.putAll(this.myExtension.getAdditionalProperties());
            properties.put("Bundle-SymbolicName", this.myExtension.getBundleSymbolicName());
            properties.put("Bundle-Version", this.myExtension.getBundleVersion());
            String activator = this.myExtension.getBundleActivator();
            if (!StringUtil.isEmptyOrSpaces((String)activator)) {
                properties.put("Bundle-Activator", activator);
            }
        } else {
            File manifestFile = this.myExtension.getManifestFile();
            if (manifestFile == null) {
                throw new OsgiBuildException("Manifest file '" + this.myExtension.getManifestLocation() + "' missing - please check OSGi facet settings.");
            }
            properties.put("-manifest", manifestFile.getAbsolutePath());
        }
        List resources = ContainerUtil.newSmartList();
        if (this.myExtension.isOsmorcControlsManifest() && (custom = (String)properties.get("Include-Resource")) != null) {
            resources.add(custom);
        }
        for (OsmorcJarContentEntry contentEntry : this.myExtension.getAdditionalJarContents()) {
            resources.add(contentEntry.myDestination + '=' + contentEntry.mySource);
        }
        if (this.myExtension.isManifestManuallyEdited()) {
            resources.add(this.myModuleOutputDir.getPath());
        }
        if (!resources.isEmpty()) {
            properties.put("Include-Resource", StringUtil.join((Collection)resources, (String)","));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(pattern = this.myExtension.getIgnoreFilePattern()))) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new OsgiBuildException("The file ignore pattern is invalid - please check OSGi facet settings.");
            }
            properties.put("-donotcopy", pattern);
        }
        if (this.myExtension.isOsmorcControlsManifest()) {
            this.progress("Calculating local packages");
            LocalPackageCollector.addLocalPackages(this.myModuleOutputDir, properties);
        }
        HashMap hashMap = properties;
        if (hashMap == null) {
            OsgiBuildSession.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private String getSourceFileToReport() {
        if (this.myExtension.isManifestManuallyEdited()) {
            File manifestFile = this.myExtension.getManifestFile();
            if (manifestFile != null) {
                return manifestFile.getPath();
            }
        } else {
            File mavenProjectFile = OsgiBuildUtil.getMavenProjectPath(this.myContext, this.myModule);
            if (mavenProjectFile != null) {
                return mavenProjectFile.getPath();
            }
        }
        return null;
    }

    @Override
    public void progress(@NotNull String message) {
        if (message == null) {
            OsgiBuildSession.$$$reportNull$$$0(3);
        }
        this.myContext.processMessage((BuildMessage)new ProgressMessage(this.myMessagePrefix + message));
    }

    @Override
    public void warning(@NotNull String message, @Nullable Throwable t, @Nullable String sourcePath, int lineNum) {
        if (message == null) {
            OsgiBuildSession.$$$reportNull$$$0(4);
        }
        this.process(BuildMessage.Kind.WARNING, message, t, sourcePath, lineNum);
    }

    @Override
    public void error(@NotNull String message, @Nullable Throwable t, @Nullable String sourcePath, int lineNum) {
        if (message == null) {
            OsgiBuildSession.$$$reportNull$$$0(5);
        }
        this.process(BuildMessage.Kind.ERROR, message, t, sourcePath, lineNum);
    }

    private void process(BuildMessage.Kind kind, String text, Throwable t, String path, int line) {
        LOG.warn(text, t);
        this.myContext.processMessage((BuildMessage)new CompilerMessage("osgi", kind, this.myMessagePrefix + text, (String)ObjectUtils.coalesce((Object)path, (Object)this.mySourceToReport), -1L, -1L, -1L, (long)line, -1L));
    }

    @Override
    public boolean isDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    @Override
    public void debug(@NotNull String message) {
        if (message == null) {
            OsgiBuildSession.$$$reportNull$$$0(6);
        }
        LOG.debug(message);
    }

    @Override
    public String setReportSource(String source) {
        String prevSource = this.mySourceToReport;
        this.mySourceToReport = source;
        return prevSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/jps/build/OsgiBuildSession";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/jps/build/OsgiBuildSession";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "progress";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "warning";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

