/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.nexus.provider;

import aQute.lib.io.IO;
import aQute.libg.command.Command;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Signer {
    private byte[] passphrase;
    private String cmd;

    public Signer(String passphrase, String cmd) {
        this.passphrase = passphrase.getBytes();
        this.cmd = cmd == null ? this.getDefault() : cmd;
    }

    private String getDefault() {
        boolean windows;
        boolean bl = windows = File.separatorChar == '\\';
        if (windows) {
            return "gpg";
        }
        return "gpg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(File f) throws Exception {
        Path tmp = Files.createTempFile("sign", ".asc", new FileAttribute[0]);
        try {
            Command cmd = new Command();
            cmd.add(this.cmd);
            cmd.add("--batch");
            cmd.add("--passphrase-fd");
            cmd.add("0");
            cmd.add("--output");
            cmd.add(tmp.toAbsolutePath().toString());
            Files.delete(tmp);
            cmd.add("-ab");
            cmd.add(f.getAbsolutePath());
            ByteArrayInputStream bin = new ByteArrayInputStream(this.passphrase);
            StringBuffer out = new StringBuffer();
            int result = cmd.execute(bin, (Appendable)out, (Appendable)System.err);
            if (result != 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = IO.read(tmp.toFile());
            return byArray;
        }
        finally {
            IO.delete(tmp.toFile());
        }
    }
}

