/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JpsAnnotationRootType;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependenciesRootsEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumerationHandler;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesRootsEnumeratorImpl;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.model.module.impl.JpsDependenciesEnumeratorBase;

public class JpsJavaDependenciesEnumeratorImpl
extends JpsDependenciesEnumeratorBase<JpsJavaDependenciesEnumeratorImpl>
implements JpsJavaDependenciesEnumerator {
    private boolean myProductionOnly;
    private boolean myRuntimeOnly;
    private boolean myCompileOnly;
    private boolean myExportedOnly;
    private boolean myRecursivelyExportedOnly;
    private JpsJavaClasspathKind myClasspathKind;
    private final List<JpsJavaDependenciesEnumerationHandler> myHandlers;

    public JpsJavaDependenciesEnumeratorImpl(Collection<JpsModule> rootModules) {
        super(rootModules);
        List<JpsJavaDependenciesEnumerationHandler> handlers = JpsJavaDependenciesEnumerationHandler.createHandlers(rootModules);
        this.myHandlers = handlers != null ? handlers : Collections.emptyList();
    }

    @Override
    @NotNull
    public JpsJavaDependenciesEnumerator productionOnly() {
        this.myProductionOnly = true;
        JpsJavaDependenciesEnumeratorImpl jpsJavaDependenciesEnumeratorImpl = this;
        if (jpsJavaDependenciesEnumeratorImpl == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(0);
        }
        return jpsJavaDependenciesEnumeratorImpl;
    }

    @Override
    @NotNull
    public JpsJavaDependenciesEnumerator compileOnly() {
        this.myCompileOnly = true;
        JpsJavaDependenciesEnumeratorImpl jpsJavaDependenciesEnumeratorImpl = this;
        if (jpsJavaDependenciesEnumeratorImpl == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(1);
        }
        return jpsJavaDependenciesEnumeratorImpl;
    }

    @Override
    @NotNull
    public JpsJavaDependenciesEnumerator runtimeOnly() {
        this.myRuntimeOnly = true;
        JpsJavaDependenciesEnumeratorImpl jpsJavaDependenciesEnumeratorImpl = this;
        if (jpsJavaDependenciesEnumeratorImpl == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(2);
        }
        return jpsJavaDependenciesEnumeratorImpl;
    }

    @Override
    @NotNull
    public JpsJavaDependenciesEnumerator exportedOnly() {
        if (this.myRecursively) {
            this.myRecursivelyExportedOnly = true;
        } else {
            this.myExportedOnly = true;
        }
        JpsJavaDependenciesEnumeratorImpl jpsJavaDependenciesEnumeratorImpl = this;
        if (jpsJavaDependenciesEnumeratorImpl == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(3);
        }
        return jpsJavaDependenciesEnumeratorImpl;
    }

    @Override
    @NotNull
    public JpsJavaDependenciesEnumerator recursivelyExportedOnly() {
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = ((JpsJavaDependenciesEnumeratorImpl)this.recursively()).exportedOnly();
        if (jpsJavaDependenciesEnumerator == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(4);
        }
        return jpsJavaDependenciesEnumerator;
    }

    @Override
    @NotNull
    public JpsJavaDependenciesEnumerator includedIn(@NotNull JpsJavaClasspathKind classpathKind) {
        if (classpathKind == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(5);
        }
        this.myClasspathKind = classpathKind;
        JpsJavaDependenciesEnumeratorImpl jpsJavaDependenciesEnumeratorImpl = this;
        if (jpsJavaDependenciesEnumeratorImpl == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(6);
        }
        return jpsJavaDependenciesEnumeratorImpl;
    }

    @Override
    @NotNull
    public JpsJavaDependenciesRootsEnumerator classes() {
        JpsJavaDependenciesRootsEnumeratorImpl jpsJavaDependenciesRootsEnumeratorImpl = new JpsJavaDependenciesRootsEnumeratorImpl(this, JpsOrderRootType.COMPILED);
        if (jpsJavaDependenciesRootsEnumeratorImpl == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(7);
        }
        return jpsJavaDependenciesRootsEnumeratorImpl;
    }

    @Override
    @NotNull
    public JpsJavaDependenciesRootsEnumerator sources() {
        JpsJavaDependenciesRootsEnumeratorImpl jpsJavaDependenciesRootsEnumeratorImpl = new JpsJavaDependenciesRootsEnumeratorImpl(this, JpsOrderRootType.SOURCES);
        if (jpsJavaDependenciesRootsEnumeratorImpl == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(8);
        }
        return jpsJavaDependenciesRootsEnumeratorImpl;
    }

    @Override
    @NotNull
    public JpsJavaDependenciesRootsEnumerator annotations() {
        JpsJavaDependenciesRootsEnumeratorImpl jpsJavaDependenciesRootsEnumeratorImpl = new JpsJavaDependenciesRootsEnumeratorImpl(this, (JpsOrderRootType)JpsAnnotationRootType.INSTANCE);
        if (jpsJavaDependenciesRootsEnumeratorImpl == null) {
            JpsJavaDependenciesEnumeratorImpl.$$$reportNull$$$0(9);
        }
        return jpsJavaDependenciesRootsEnumeratorImpl;
    }

    @Override
    protected JpsJavaDependenciesEnumeratorImpl self() {
        return this;
    }

    @Override
    protected boolean shouldProcessDependenciesRecursively() {
        return JpsJavaDependenciesEnumerationHandler.shouldProcessDependenciesRecursively(this.myHandlers);
    }

    @Override
    protected boolean shouldProcess(JpsModule module, JpsDependencyElement element) {
        boolean exported = !(element instanceof JpsSdkDependency);
        JpsJavaDependencyExtension extension = JpsJavaExtensionService.getInstance().getDependencyExtension(element);
        if (extension != null) {
            boolean forTestCompile;
            exported = extension.isExported();
            JpsJavaDependencyScope scope = extension.getScope();
            boolean bl = forTestCompile = scope.isIncludedIn(JpsJavaClasspathKind.TEST_COMPILE) || scope == JpsJavaDependencyScope.RUNTIME && this.shouldAddRuntimeDependenciesToTestCompilationClasspath();
            if (this.myCompileOnly && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_COMPILE) && !forTestCompile || this.myRuntimeOnly && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_RUNTIME) && !scope.isIncludedIn(JpsJavaClasspathKind.TEST_RUNTIME) || this.myClasspathKind != null && !scope.isIncludedIn(this.myClasspathKind) && (this.myClasspathKind != JpsJavaClasspathKind.TEST_COMPILE || !forTestCompile)) {
                return false;
            }
            if (this.myProductionOnly && (!scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_COMPILE) && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_RUNTIME) || this.myCompileOnly && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_COMPILE) || this.myRuntimeOnly && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_RUNTIME))) {
                return false;
            }
        }
        if (!exported) {
            if (this.myExportedOnly) {
                return false;
            }
            if ((this.myRecursivelyExportedOnly || element instanceof JpsSdkDependency) && !this.isEnumerationRootModule(module)) {
                return false;
            }
        }
        return true;
    }

    public boolean isProductionOnly() {
        return this.myProductionOnly || this.myClasspathKind == JpsJavaClasspathKind.PRODUCTION_RUNTIME || this.myClasspathKind == JpsJavaClasspathKind.PRODUCTION_COMPILE;
    }

    public boolean isProductionOnTests(JpsDependencyElement element) {
        for (JpsJavaDependenciesEnumerationHandler handler : this.myHandlers) {
            if (!handler.isProductionOnTestsDependency(element)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        for (JpsJavaDependenciesEnumerationHandler handler : this.myHandlers) {
            if (handler.shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        for (JpsJavaDependenciesEnumerationHandler handler : this.myHandlers) {
            if (!handler.shouldAddRuntimeDependenciesToTestCompilationClasspath()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JpsJavaDependenciesEnumeratorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpathKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "productionOnly";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "compileOnly";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeOnly";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "exportedOnly";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "recursivelyExportedOnly";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JpsJavaDependenciesEnumeratorImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "includedIn";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "classes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sources";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "annotations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "includedIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

