/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.appengine.build;

import com.intellij.appengine.rt.EnhancerRunner;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.appengine.build.EnhancerProcessHandlerBase;
import org.jetbrains.jps.appengine.model.JpsAppEngineExtensionService;
import org.jetbrains.jps.appengine.model.JpsAppEngineModuleExtension;
import org.jetbrains.jps.appengine.model.PersistenceApi;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class AppEngineEnhancerBuilder
extends ModuleLevelBuilder {
    public static final String NAME = "Google AppEngine Enhancer";

    public AppEngineEnhancerBuilder() {
        super(BuilderCategory.CLASS_POST_PROCESSOR);
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        boolean doneSomething = false;
        for (JpsModule module : chunk.getModules()) {
            JpsAppEngineModuleExtension extension = JpsAppEngineExtensionService.getInstance().getExtension(module);
            if (extension == null || !extension.isRunEnhancerOnMake()) continue;
            doneSomething |= AppEngineEnhancerBuilder.processModule(context, dirtyFilesHolder, extension);
        }
        return doneSomething ? ModuleLevelBuilder.ExitCode.OK : ModuleLevelBuilder.ExitCode.NOTHING_DONE;
    }

    public List<String> getCompilableFileExtensions() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processModule(CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, JpsAppEngineModuleExtension extension) throws IOException, ProjectBuildException {
        THashSet roots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (String path : extension.getFilesToEnhance()) {
            roots.add(new File(FileUtil.toSystemDependentName((String)path)));
        }
        ArrayList pathsToProcess = new ArrayList();
        dirtyFilesHolder.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>((Set)roots, context, pathsToProcess){
            final /* synthetic */ Set val$roots;
            final /* synthetic */ CompileContext val$context;
            final /* synthetic */ List val$pathsToProcess;
            {
                this.val$roots = set;
                this.val$context = compileContext;
                this.val$pathsToProcess = list;
            }

            public boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor root) throws IOException {
                Collection outputs;
                if (JpsPathUtil.isUnder((Set)this.val$roots, (File)file) && (outputs = this.val$context.getProjectDescriptor().dataManager.getSourceToOutputMap((BuildTarget)target).getOutputs(file.getAbsolutePath())) != null) {
                    this.val$pathsToProcess.addAll(outputs);
                }
                return true;
            }
        });
        if (pathsToProcess.isEmpty()) {
            return false;
        }
        JpsModule module = extension.getModule();
        JpsSdk sdk = JavaBuilderUtil.ensureModuleHasJdk((JpsModule)module, (CompileContext)context, (String)NAME);
        context.processMessage((BuildMessage)new ProgressMessage("Enhancing classes in module '" + module.getName() + "'..."));
        List<String> vmParams = Collections.singletonList("-Xmx256m");
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(extension.getToolsApiJarPath());
        classpath.add(PathManager.getJarPathForClass(EnhancerRunner.class));
        boolean removeOrmJars = Boolean.parseBoolean(System.getProperty("jps.appengine.enhancer.remove.orm.jars", "true"));
        for (File file : JpsJavaExtensionService.dependencies((JpsModule)module).recursively().compileOnly().productionOnly().classes().getRoots()) {
            if (removeOrmJars && FileUtil.isAncestor((File)new File(extension.getOrmLibPath()), (File)file, (boolean)true)) continue;
            classpath.add(file.getAbsolutePath());
        }
        ArrayList<String> programParams = new ArrayList<String>();
        File argsFile = FileUtil.createTempFile((String)"appEngineEnhanceFiles", (String)".txt");
        try (PrintWriter writer = new PrintWriter(argsFile);){
            for (String path : pathsToProcess) {
                writer.println(FileUtil.toSystemDependentName((String)path));
            }
        }
        programParams.add(argsFile.getAbsolutePath());
        programParams.add("com.google.appengine.tools.enhancer.Enhance");
        programParams.add("-api");
        PersistenceApi api = extension.getPersistenceApi();
        programParams.add(api.getEnhancerApiName());
        if (api.getEnhancerVersion() == 2) {
            programParams.add("-enhancerVersion");
            programParams.add("v2");
        }
        programParams.add("-v");
        List commandLine = ExternalProcessUtil.buildJavaCommandLine((String)JpsJavaSdkType.getJavaExecutable((JpsSdk)sdk), (String)EnhancerRunner.class.getName(), Collections.emptyList(), classpath, vmParams, programParams);
        Process process = new ProcessBuilder(commandLine).start();
        ExternalEnhancerProcessHandler handler = new ExternalEnhancerProcessHandler(process, commandLine, context);
        handler.startNotify();
        handler.waitFor();
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        if (logger.isEnabled()) {
            logger.logCompiledPaths(pathsToProcess, NAME, "Enhancing classes:");
        }
        return true;
    }

    @NotNull
    public String getPresentableName() {
        if (NAME == null) {
            AppEngineEnhancerBuilder.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/appengine/build/AppEngineEnhancerBuilder", "getPresentableName"));
    }

    private static class ExternalEnhancerProcessHandler
    extends EnhancerProcessHandlerBase {
        private final CompileContext myContext;

        public ExternalEnhancerProcessHandler(Process process, List<String> commandLine, CompileContext context) {
            super(process, ParametersListUtil.join(commandLine), null);
            this.myContext = context;
        }

        @Override
        protected void reportInfo(String message) {
            this.myContext.processMessage((BuildMessage)new CompilerMessage(AppEngineEnhancerBuilder.NAME, BuildMessage.Kind.INFO, message));
        }

        @Override
        protected void reportError(String message) {
            this.myContext.processMessage((BuildMessage)new CompilerMessage(AppEngineEnhancerBuilder.NAME, BuildMessage.Kind.ERROR, message));
        }
    }
}

