/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import com.intellij.util.containers.SLRUCache;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacNameTable {
    private final SLRUCache<Name, String> myParsedNameCache = new SLRUCache<Name, String>(1000, 1000){

        @NotNull
        public String createValue(Name key) {
            String string = key.toString();
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacNameTable$1", "createValue"));
        }
    };
    private final Elements myElements;
    private Name myAsterisk;
    private Name myInit;
    private TypeElement myStreamElement;
    private TypeElement myIteratorElement;
    private TypeElement myIterableElement;

    public JavacNameTable(Elements elements) {
        this.myElements = elements;
    }

    @NotNull
    public String parseName(Name name) {
        String string = (String)this.myParsedNameCache.get((Object)name);
        if (string == null) {
            JavacNameTable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String parseBinaryName(Element element) {
        String string = this.parseName(this.myElements.getBinaryName((TypeElement)element));
        if (string == null) {
            JavacNameTable.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAsterisk(Name name) {
        if (this.myAsterisk == null) {
            this.myAsterisk = this.myElements.getName("*");
        }
        return this.myAsterisk == name;
    }

    public boolean isInit(Name name) {
        if (this.myInit == null) {
            this.myInit = this.myElements.getName("<init>");
        }
        return this.myInit == name;
    }

    @Nullable(value="if the type is not loaded to javac name table")
    public TypeElement getStreamElement() {
        if (this.myStreamElement == null) {
            this.myStreamElement = this.myElements.getTypeElement("java.util.stream.Stream");
        }
        return this.myStreamElement;
    }

    @Nullable(value="if the type is not loaded to javac name table")
    public TypeElement getIteratorElement() {
        if (this.myIteratorElement == null) {
            this.myIteratorElement = this.myElements.getTypeElement("java.util.Iterator");
        }
        return this.myIteratorElement;
    }

    @Nullable(value="if the type is not loaded to javac name table")
    public TypeElement getIterableElement() {
        if (this.myIterableElement == null) {
            this.myIterableElement = this.myElements.getTypeElement("java.lang.Iterable");
        }
        return this.myIterableElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/javac/ast/api/JavacNameTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBinaryName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

