/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjJpsWeaver;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.module.JpsModule;

public class AjWeavingBuilder
extends AjBuilderBase {
    private static final String AJ_WEAVER_CLASS = "org.aspectj.weaver.tools.WeavingAdaptor";

    public AjWeavingBuilder() {
        super(BuilderCategory.CLASS_INSTRUMENTER, AJ_WEAVER_CLASS);
    }

    @Override
    public ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder, @NotNull ModuleLevelBuilder.OutputConsumer consumer, @NotNull AjCompilerSettings settings) throws ProjectBuildException, IOException, AjBuilderBase.AjBuildException {
        if (context == null) {
            AjWeavingBuilder.$$$reportNull$$$0(0);
        }
        if (chunk == null) {
            AjWeavingBuilder.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            AjWeavingBuilder.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            AjWeavingBuilder.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            AjWeavingBuilder.$$$reportNull$$$0(4);
        }
        if (!settings.delegateToJavac) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        if (consumer.getCompiledClasses().isEmpty()) {
            LOG.debug("no files");
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        ModuleLevelBuilder.ExitCode result = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            JpsModule module = target.getModule();
            AjModuleSettings moduleSettings = AjJpsModuleSettings.getSettings(module);
            if (moduleSettings == null || !moduleSettings.weaveOnly) continue;
            ModuleLevelBuilder.ExitCode targetResult = new AjJpsWeaver(context, chunk, consumer, target, settings).build();
            if (targetResult.compareTo((Enum)result) > 0) {
                result = targetResult;
            }
            if (result != ModuleLevelBuilder.ExitCode.ABORT) continue;
            break;
        }
        return result;
    }

    public List<String> getCompilableFileExtensions() {
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "chunk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/aspectj/build/AjWeavingBuilder";
        objectArray[2] = "doBuild";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

