/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Base64;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class MavenManifestGenerationBuildTaskProvider
extends ArtifactBuildTaskProvider {
    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (artifact == null) {
            MavenManifestGenerationBuildTaskProvider.$$$reportNull$$$0(0);
        }
        if (buildPhase == null) {
            MavenManifestGenerationBuildTaskProvider.$$$reportNull$$$0(1);
        }
        String artifactName = artifact.getName();
        if (buildPhase == ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING && (artifactName.endsWith(" exploded") || artifactName.endsWith("ejb-client")) && artifact.getRootElement() instanceof JpsArtifactRootElement) {
            List<MavenManifestGenerationBuildTask> list = Collections.singletonList(new MavenManifestGenerationBuildTask(artifact));
            if (list == null) {
                MavenManifestGenerationBuildTaskProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            MavenManifestGenerationBuildTaskProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildPhase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactBuildTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactBuildTasks";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MavenManifestGenerationBuildTask
    extends BuildTask {
        private static final Logger LOG = Logger.getInstance(MavenManifestGenerationBuildTask.class);
        private final JpsArtifact myArtifact;

        public MavenManifestGenerationBuildTask(JpsArtifact artifact) {
            this.myArtifact = artifact;
        }

        public void build(CompileContext context) throws ProjectBuildException {
            BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
            MavenProjectConfiguration projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
            if (projectConfiguration == null) {
                return;
            }
            MavenModuleResourceConfiguration moduleResourceConfiguration = projectConfiguration.moduleConfigurations.get(MavenManifestGenerationBuildTask.getModuleName(this.myArtifact.getName()));
            if (moduleResourceConfiguration != null && StringUtil.isNotEmpty((String)moduleResourceConfiguration.manifest)) {
                try {
                    File output = new File(this.myArtifact.getOutputPath(), "META-INF/MANIFEST.MF");
                    FileUtil.writeToFile((File)output, (byte[])Base64.decode((String)moduleResourceConfiguration.manifest));
                    this.handleSkinnyWars(context, projectConfiguration, moduleResourceConfiguration);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        private void handleSkinnyWars(CompileContext context, MavenProjectConfiguration projectConfiguration, MavenModuleResourceConfiguration moduleResourceConfiguration) {
            if (!"ear".equals(moduleResourceConfiguration.modelMap.get("packaging"))) {
                return;
            }
            if (!Boolean.parseBoolean(moduleResourceConfiguration.modelMap.get("build.plugin.maven-ear-plugin.skinnyWars"))) {
                return;
            }
            String earClasspath = moduleResourceConfiguration.classpath;
            if (earClasspath == null) {
                return;
            }
            Map earClasspathMap = ContainerUtil.map2Map((Collection)StringUtil.split((String)earClasspath, (String)" "), s -> {
                int idx = s.lastIndexOf("/");
                return Pair.create((Object)s.substring(idx == -1 ? 0 : idx + 1), (Object)s);
            });
            JpsArtifactUtil.processPackagingElements((JpsPackagingElement)this.myArtifact.getRootElement(), element -> {
                if (!(element instanceof JpsFileCopyPackagingElement)) {
                    return true;
                }
                JpsFileCopyPackagingElement fileCopyPackagingElement = (JpsFileCopyPackagingElement)element;
                String filePath = fileCopyPackagingElement.getFilePath();
                File skinnyManifest = new File(filePath);
                if (!"SKINNY_MANIFEST.MF".equals(skinnyManifest.getName())) {
                    return true;
                }
                String skinnyWarModuleName = skinnyManifest.getParentFile().getParentFile().getName();
                MavenModuleResourceConfiguration warConfiguration = projectConfiguration.moduleConfigurations.get(skinnyWarModuleName);
                if (warConfiguration == null || warConfiguration.classpath == null) {
                    return true;
                }
                try {
                    File skinnyManifestTargetFile;
                    block12: {
                        byte[] warManifestData = Base64.decode((String)warConfiguration.manifest);
                        Manifest warManifest = new Manifest(new ByteArrayInputStream(warManifestData));
                        ArrayList skinnyWarClasspath = ContainerUtil.newArrayList();
                        Iterator iterator = StringUtil.split((String)warConfiguration.classpath, (String)" ").iterator();
                        while (iterator.hasNext()) {
                            String entry;
                            int idx = (entry = (String)iterator.next()).lastIndexOf("/");
                            String entryName = entry.substring(idx == -1 ? 0 : idx + 1);
                            String earEntryPath = (String)earClasspathMap.get(entryName);
                            skinnyWarClasspath.add(earEntryPath == null ? entry : earEntryPath);
                        }
                        Attributes warManifestMainAttributes = warManifest.getMainAttributes();
                        warManifestMainAttributes.putValue("Class-Path", StringUtil.join((Collection)skinnyWarClasspath, (String)" "));
                        skinnyManifestTargetFile = null;
                        FileUtil.createParentDirs((File)skinnyManifest);
                        FileOutputStream outputStream = new FileOutputStream(skinnyManifest);
                        try {
                            warManifest.write(outputStream);
                            if (!(fileCopyPackagingElement instanceof JpsElementBase)) break block12;
                            LinkedList<String> pathParts = new LinkedList<String>();
                            pathParts.add(fileCopyPackagingElement.getRenamedOutputFileName());
                            for (JpsElementBase parent = ((JpsElementBase)fileCopyPackagingElement).getParent(); parent != null; parent = parent.getParent()) {
                                String outputPath;
                                if (parent instanceof JpsDirectoryPackagingElement) {
                                    pathParts.addFirst(((JpsDirectoryPackagingElement)parent).getDirectoryName());
                                    continue;
                                }
                                if (!(parent instanceof JpsArtifact) || (outputPath = ((JpsArtifact)parent).getOutputPath()) == null) continue;
                                pathParts.addFirst(outputPath);
                                skinnyManifestTargetFile = new File(StringUtil.join(pathParts, (String)"/"));
                                break;
                            }
                        }
                        finally {
                            StreamUtil.closeStream((Closeable)outputStream);
                        }
                    }
                    if (skinnyManifestTargetFile != null) {
                        FileUtil.createParentDirs(skinnyManifestTargetFile);
                        FileUtil.copy((File)skinnyManifest, skinnyManifestTargetFile);
                    }
                    FSOperations.markDirtyIfNotDeleted((CompileContext)context, (CompilationRound)CompilationRound.NEXT, (File)skinnyManifest);
                    FSOperations.markDirtyIfNotDeleted((CompileContext)context, (CompilationRound)CompilationRound.NEXT, skinnyManifestTargetFile);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                return true;
            });
        }

        @Nullable
        private static String getModuleName(@NotNull String artifactName) {
            if (artifactName == null) {
                MavenManifestGenerationBuildTask.$$$reportNull$$$0(0);
            }
            return StringUtil.substringBefore((String)artifactName, (String)":");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider$MavenManifestGenerationBuildTask", "getModuleName"));
        }
    }
}

