/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexResourceBuildTarget;
import com.intellij.flex.build.FlexResourceBuildTargetType;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexCompilerOptions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.util.JpsPathUtil;

public class FlexResourceBuilder
extends TargetBuilder<BuildRootDescriptor, FlexResourceBuildTarget> {
    @NonNls
    private static final String BUILDER_NAME = "Flash Resource Builder";

    protected FlexResourceBuilder() {
        super(Arrays.asList(FlexResourceBuildTargetType.PRODUCTION, FlexResourceBuildTargetType.TEST));
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            FlexResourceBuilder.$$$reportNull$$$0(0);
        }
        return BUILDER_NAME;
    }

    public void build(@NotNull FlexResourceBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, FlexResourceBuildTarget> holder, final @NotNull BuildOutputConsumer outputConsumer, final @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            FlexResourceBuilder.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            FlexResourceBuilder.$$$reportNull$$$0(2);
        }
        if (outputConsumer == null) {
            FlexResourceBuilder.$$$reportNull$$$0(3);
        }
        if (context == null) {
            FlexResourceBuilder.$$$reportNull$$$0(4);
        }
        final JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(target.getModule().getProject());
        final JpsCompilerExcludes excludes = configuration.getCompilerExcludes();
        try {
            holder.processDirtyFiles((FileProcessor)new FileProcessor<BuildRootDescriptor, FlexResourceBuildTarget>(){

                public boolean apply(FlexResourceBuildTarget target, File file, BuildRootDescriptor root) throws IOException {
                    if (excludes.isExcluded(file)) {
                        return true;
                    }
                    String relativePath = FileUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)root.getRootFile(), (File)file));
                    if (target.isTests()) {
                        if (!FlexCommonUtils.isSourceFile(file.getName())) {
                            String outputRootUrl = JpsJavaExtensionService.getInstance().getOutputUrl(target.getModule(), target.isTests());
                            if (outputRootUrl == null) {
                                return true;
                            }
                            String targetPath = JpsPathUtil.urlToPath((String)outputRootUrl) + '/' + relativePath;
                            context.processMessage((BuildMessage)new ProgressMessage("Copying " + file.getPath()));
                            FlexResourceBuilder.copyResource(context, file, Collections.singleton(targetPath), outputConsumer);
                        }
                    } else {
                        ArrayList<String> targetPaths = new ArrayList<String>();
                        for (JpsFlexBuildConfiguration bc : ((JpsFlexBuildConfigurationManager)target.getModule().getProperties()).getBuildConfigurations()) {
                            JpsFlexCompilerOptions.ResourceFilesMode mode;
                            if (bc.isSkipCompile() || !FlexCommonUtils.canHaveResourceFiles(bc.getNature()) || bc.getCompilerOptions().getResourceFilesMode() == JpsFlexCompilerOptions.ResourceFilesMode.None || ((mode = bc.getCompilerOptions().getResourceFilesMode()) != JpsFlexCompilerOptions.ResourceFilesMode.All || FlexCommonUtils.isSourceFile(file.getName())) && (mode != JpsFlexCompilerOptions.ResourceFilesMode.ResourcePatterns || !configuration.isResourceFile(file, root.getRootFile()))) continue;
                            String outputFolder = PathUtilRt.getParentPath((String)bc.getActualOutputFilePath());
                            targetPaths.add(outputFolder + "/" + relativePath);
                        }
                        if (!targetPaths.isEmpty()) {
                            context.processMessage((BuildMessage)new ProgressMessage("Copying " + file.getPath()));
                            FlexResourceBuilder.copyResource(context, file, targetPaths, outputConsumer);
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw new ProjectBuildException(e.getMessage(), (Throwable)e);
        }
    }

    private static void copyResource(CompileContext context, File file, Collection<String> targetPaths, BuildOutputConsumer outputConsumer) {
        try {
            for (String targetPath : targetPaths) {
                File targetFile = new File(targetPath);
                FileUtil.copyContent((File)file, (File)targetFile);
                outputConsumer.registerOutputFile(targetFile, Collections.singletonList(file.getPath()));
            }
        }
        catch (IOException e) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, e.getMessage(), FileUtil.toSystemIndependentName((String)file.getPath())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jps/flex/build/FlexResourceBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jps/flex/build/FlexResourceBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

