/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.codec;

import aQute.lib.codec.Codec;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;

public class HCodec
implements Codec {
    final Codec codec;

    public HCodec(Codec codec) {
        this.codec = codec;
    }

    @Override
    public Object decode(Reader in, Type type) throws Exception {
        return this.codec.decode(in, type);
    }

    public <T> T decode(InputStream in, Class<T> t) throws Exception {
        return t.cast(this.decode(in, (Type)t));
    }

    public <T> T decode(Reader in, Class<T> t) throws Exception {
        return t.cast(this.decode(in, (Type)t));
    }

    public Object decode(InputStream in, Type t) throws Exception {
        InputStreamReader r = new InputStreamReader(in, "UTF-8");
        return this.codec.decode(r, t);
    }

    @Override
    public void encode(Type t, Object o, Appendable out) throws Exception {
        this.codec.encode(t, o, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Type t, Object o, OutputStream out) throws Exception {
        OutputStreamWriter wr = new OutputStreamWriter(out, "UTF-8");
        try {
            this.codec.encode(t, o, wr);
        }
        finally {
            wr.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T decode(File in, Class<T> t) throws Exception {
        FileInputStream fin = new FileInputStream(in);
        try {
            T t2;
            InputStreamReader rdr = new InputStreamReader((InputStream)fin, "UTF-8");
            try {
                t2 = t.cast(this.decode((Reader)rdr, t));
            }
            catch (Throwable throwable) {
                rdr.close();
                throw throwable;
            }
            rdr.close();
            return t2;
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Type t, Object o, File out) throws Exception {
        FileOutputStream oout = new FileOutputStream(out);
        try {
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)oout, "UTF-8");
            try {
                this.codec.encode(t, o, wr);
            }
            finally {
                ((Writer)wr).close();
            }
        }
        finally {
            ((OutputStream)oout).close();
        }
    }
}

