/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

@Tag(value="source")
public class GwtSourcePath
implements Comparable<GwtSourcePath> {
    @Attribute(value="fullPath")
    public String myFullPath;
    @Attribute(value="caseSensitive")
    public boolean myCaseSensitive;
    @Attribute(value="defaultExcludes")
    public boolean myDefaultExcludes;
    @Tag(value="includes")
    @AbstractCollection(surroundWithTag=false, elementTag="include")
    public List<String> myIncludes;
    @Tag(value="excludes")
    @AbstractCollection(surroundWithTag=false, elementTag="exclude")
    public List<String> myExcludes;
    @Transient
    public Map<String, Pattern> myPatternsCache;

    public GwtSourcePath() {
        this.myPatternsCache = ContainerUtil.newHashMap();
        this.myCaseSensitive = true;
        this.myDefaultExcludes = true;
        this.myIncludes = new SmartList();
        this.myExcludes = new SmartList();
    }

    public GwtSourcePath(@NotNull String fullPath, boolean caseSensitive, boolean defaultExcludes, @NotNull List<String> includes, @NotNull List<String> excludes) {
        if (fullPath == null) {
            GwtSourcePath.$$$reportNull$$$0(0);
        }
        if (includes == null) {
            GwtSourcePath.$$$reportNull$$$0(1);
        }
        if (excludes == null) {
            GwtSourcePath.$$$reportNull$$$0(2);
        }
        this.myPatternsCache = ContainerUtil.newHashMap();
        this.myFullPath = fullPath;
        this.myCaseSensitive = caseSensitive;
        this.myDefaultExcludes = defaultExcludes;
        this.myIncludes = GwtSourcePath.copyOf(includes, caseSensitive);
        this.myExcludes = GwtSourcePath.copyOf(excludes, caseSensitive);
    }

    @NotNull
    private static List<String> copyOf(@NotNull List<String> list, boolean caseSensitive) {
        if (list == null) {
            GwtSourcePath.$$$reportNull$$$0(3);
        }
        if (list.isEmpty()) {
            List<String> list2 = list;
            if (list2 == null) {
                GwtSourcePath.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList copy = ContainerUtil.newArrayListWithCapacity((int)list.size());
        for (String str : list) {
            copy.add(caseSensitive ? str : StringUtil.toLowerCase((String)str));
        }
        ContainerUtil.sort((List)copy);
        ArrayList arrayList = copy;
        if (arrayList == null) {
            GwtSourcePath.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public String getFullPath() {
        return this.myFullPath;
    }

    public boolean caseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean defaultExcludes() {
        return this.myDefaultExcludes;
    }

    public boolean includes(String path) {
        if (this.myIncludes.isEmpty()) {
            return true;
        }
        for (String includePattern : this.myIncludes) {
            if (!this.compilePattern(includePattern).matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean excludes(String path) {
        for (String includePattern : this.myExcludes) {
            if (!this.compilePattern(includePattern).matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    private Pattern compilePattern(String str) {
        Pattern pattern = this.myPatternsCache.get(str);
        if (pattern == null) {
            pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)str), this.myCaseSensitive ? 0 : 2);
            this.myPatternsCache.put(str, pattern);
        }
        return pattern;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GwtSourcePath that = (GwtSourcePath)obj;
        if (this.myCaseSensitive != that.myCaseSensitive) {
            return false;
        }
        if (this.myDefaultExcludes != that.myDefaultExcludes) {
            return false;
        }
        if (this.myCaseSensitive ? !this.myFullPath.equals(that.myFullPath) : !this.myFullPath.equalsIgnoreCase(that.myFullPath)) {
            return false;
        }
        if (!this.myIncludes.equals(that.myIncludes)) {
            return false;
        }
        return this.myExcludes.equals(that.myExcludes);
    }

    public int hashCode() {
        int result = (this.myCaseSensitive ? this.myFullPath : StringUtil.toLowerCase((String)this.myFullPath)).hashCode();
        result = 31 * result + (this.myCaseSensitive ? 1 : 0);
        result = 31 * result + (this.myDefaultExcludes ? 1 : 0);
        result = 31 * result + this.myIncludes.hashCode();
        result = 31 * result + this.myExcludes.hashCode();
        return result;
    }

    @Override
    public int compareTo(@NotNull GwtSourcePath that) {
        int compare;
        if (that == null) {
            GwtSourcePath.$$$reportNull$$$0(6);
        }
        int n = this.myCaseSensitive == that.myCaseSensitive ? 0 : (compare = this.myCaseSensitive ? 1 : -1);
        if (compare != 0) {
            return compare;
        }
        int n2 = this.myDefaultExcludes == that.myDefaultExcludes ? 0 : (compare = this.myDefaultExcludes ? 1 : -1);
        if (compare != 0) {
            return compare;
        }
        compare = this.myCaseSensitive ? this.myFullPath.compareTo(that.myFullPath) : this.myFullPath.compareToIgnoreCase(that.myFullPath);
        if (compare != 0) {
            return compare;
        }
        compare = ContainerUtil.compareLexicographically(this.myIncludes, that.myIncludes);
        if (compare != 0) {
            return compare;
        }
        return ContainerUtil.compareLexicographically(this.myExcludes, that.myExcludes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gwt/model/impl/GwtSourcePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gwt/model/impl/GwtSourcePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyOf";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

