/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.GenericFactory;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.legacy.descriptors.IPkgDesc;
import com.android.sdklib.repository.legacy.descriptors.PkgType;
import com.android.sdklib.repository.meta.AddonFactory;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.Library;
import com.android.sdklib.repository.meta.RepoFactory;
import com.android.sdklib.repository.meta.SdkCommonFactory;
import com.android.sdklib.repository.meta.SysImgFactory;
import com.android.sdklib.repository.targets.SystemImage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LegacyRepoUtils {
    private static final Pattern PATTERN_LIB_DATA = Pattern.compile("^([a-zA-Z0-9._-]+\\.jar);(.*)$", 2);
    private static final String ADDON_LIBRARIES = "libraries";

    static TypeDetails createTypeDetails(IPkgDesc desc, int layoutLibVersion, Collection<IAndroidTarget.OptionalLibrary> addonLibraries, File packageDir, ProgressIndicator progress, FileOp fop) {
        SdkCommonFactory sdkFactory = (SdkCommonFactory)AndroidSdkHandler.getCommonModule().createLatestFactory();
        RepoFactory repoFactory = (RepoFactory)AndroidSdkHandler.getRepositoryModule().createLatestFactory();
        AddonFactory addonFactory = (AddonFactory)AndroidSdkHandler.getAddonModule().createLatestFactory();
        SysImgFactory sysImgFactory = (SysImgFactory)AndroidSdkHandler.getSysImgModule().createLatestFactory();
        GenericFactory genericFactory = (GenericFactory)RepoManager.getGenericModule().createLatestFactory();
        AndroidVersion androidVersion = desc.getAndroidVersion();
        if (desc.getType() == PkgType.PKG_PLATFORM) {
            DetailsTypes.PlatformDetailsType details = repoFactory.createPlatformDetailsType();
            assert (androidVersion != null);
            details.setApiLevel(androidVersion.getApiLevel());
            details.setCodename(androidVersion.getCodename());
            DetailsTypes.PlatformDetailsType.LayoutlibType layoutLib = repoFactory.createLayoutlibType();
            layoutLib.setApi(layoutLibVersion);
            details.setLayoutlib(layoutLib);
            return (TypeDetails)details;
        }
        if (desc.getType() == PkgType.PKG_SYS_IMAGE || desc.getType() == PkgType.PKG_ADDON_SYS_IMAGE) {
            DetailsTypes.SysImgDetailsType details = sysImgFactory.createSysImgDetailsType();
            details.setAbi(desc.getPath());
            assert (androidVersion != null);
            details.setApiLevel(androidVersion.getApiLevel());
            details.setCodename(androidVersion.getCodename());
            IdDisplay tagIdDisplay = desc.getTag();
            if (tagIdDisplay != null) {
                IdDisplay tag = sdkFactory.createIdDisplayType();
                tag.setId(tagIdDisplay.getId());
                tag.setDisplay(tagIdDisplay.getDisplay());
                details.setTag(tag);
            } else {
                details.setTag(SystemImage.DEFAULT_TAG);
            }
            IdDisplay vendorIdDisplay = desc.getVendor();
            if (vendorIdDisplay != null) {
                IdDisplay vendor = sdkFactory.createIdDisplayType();
                vendor.setId(vendorIdDisplay.getId());
                vendor.setDisplay(vendorIdDisplay.getDisplay());
                details.setVendor(vendor);
            }
            return (TypeDetails)details;
        }
        if (desc.getType() == PkgType.PKG_ADDON) {
            IdDisplay nameIdDisplay;
            DetailsTypes.AddonDetailsType details = addonFactory.createAddonDetailsType();
            IdDisplay vendorIdDisplay = desc.getVendor();
            if (vendorIdDisplay != null) {
                IdDisplay vendor = sdkFactory.createIdDisplayType();
                vendor.setId(vendorIdDisplay.getId());
                vendor.setDisplay(vendorIdDisplay.getDisplay());
                details.setVendor(vendor);
            }
            if ((nameIdDisplay = desc.getName()) != null) {
                IdDisplay tag = sdkFactory.createIdDisplayType();
                tag.setId(nameIdDisplay.getId());
                tag.setDisplay(nameIdDisplay.getDisplay());
                details.setTag(tag);
            }
            assert (androidVersion != null);
            details.setApiLevel(androidVersion.getApiLevel());
            details.setCodename(androidVersion.getCodename());
            if (!addonLibraries.isEmpty()) {
                DetailsTypes.AddonDetailsType.Libraries librariesType = addonFactory.createLibrariesType();
                List<Library> libraries = librariesType.getLibrary();
                for (IAndroidTarget.OptionalLibrary addonLib : addonLibraries) {
                    Library lib = sdkFactory.createLibraryType();
                    lib.setDescription(addonLib.getDescription());
                    lib.setName(addonLib.getName());
                    String jarPath = addonLib.getJar().getPath();
                    if (packageDir != null) {
                        lib.setPackagePath(packageDir);
                        try {
                            jarPath = FileOpUtils.makeRelative((File)new File(packageDir, "libs"), (File)new File(jarPath), (FileOp)fop);
                        }
                        catch (IOException e) {
                            progress.logWarning("Error finding library", (Throwable)e);
                        }
                    }
                    if (!jarPath.isEmpty()) {
                        lib.setLocalJarPath(jarPath);
                    }
                    libraries.add(lib);
                }
                details.setLibraries(librariesType);
            }
            return (TypeDetails)details;
        }
        if (desc.getType() == PkgType.PKG_SOURCE) {
            DetailsTypes.SourceDetailsType details = repoFactory.createSourceDetailsType();
            assert (androidVersion != null);
            details.setApiLevel(androidVersion.getApiLevel());
            details.setCodename(androidVersion.getCodename());
            return (TypeDetails)details;
        }
        if (desc.getType() == PkgType.PKG_EXTRA) {
            DetailsTypes.ExtraDetailsType details = addonFactory.createExtraDetailsType();
            IdDisplay vendorIdDisplay = desc.getVendor();
            if (vendorIdDisplay != null) {
                IdDisplay vendor = sdkFactory.createIdDisplayType();
                vendor.setId(vendorIdDisplay.getId());
                vendor.setDisplay(vendorIdDisplay.getDisplay());
                details.setVendor(vendor);
            }
            return (TypeDetails)details;
        }
        return (TypeDetails)genericFactory.createGenericDetailsType();
    }

    public static String getDisplayName(IPkgDesc legacy) {
        return LegacyRepoUtils.getDisplayNameInternal(legacy).replace(" (Obsolete)", "");
    }

    private static String getDisplayNameInternal(IPkgDesc legacy) {
        String result = legacy.getListDescription();
        if (result != null) {
            return result;
        }
        if (legacy.getType() == PkgType.PKG_PLATFORM) {
            AndroidVersion androidVersion = legacy.getAndroidVersion();
            assert (androidVersion != null);
            return SdkVersionInfo.getAndroidName(androidVersion.getFeatureLevel());
        }
        result = legacy.getListDescription();
        if (!result.isEmpty()) {
            return result;
        }
        String string = result = legacy.getName() != null ? legacy.getName().getDisplay() : "";
        if (!result.isEmpty()) {
            return result;
        }
        return legacy.getInstallId();
    }

    public static List<IAndroidTarget.OptionalLibrary> parseLegacyAdditionalLibraries(File packageLocation, ProgressIndicator progress, FileOp fop) {
        Map<String, String> propertyMap;
        ArrayList result = Lists.newArrayList();
        File addOnManifest = new File(packageLocation, "manifest.ini");
        if (!fop.isFile(addOnManifest)) {
            return result;
        }
        try {
            propertyMap = ProjectProperties.parsePropertyStream(fop.newFileInputStream(addOnManifest), addOnManifest.getPath(), null);
        }
        catch (IOException e) {
            progress.logWarning("Failed to find " + addOnManifest, (Throwable)e);
            return result;
        }
        if (propertyMap == null) {
            return result;
        }
        String librariesValue = propertyMap.get(ADDON_LIBRARIES);
        SdkCommonFactory sdkFactory = (SdkCommonFactory)AndroidSdkHandler.getCommonModule().createLatestFactory();
        HashMap libMap = Maps.newHashMap();
        if (librariesValue != null) {
            String[] libraryNames;
            if (!(librariesValue = librariesValue.trim()).isEmpty() && (libraryNames = librariesValue.split(";")).length > 0) {
                for (String libName : libraryNames) {
                    String libData = propertyMap.get(libName = libName.trim());
                    if (libData != null) {
                        Matcher m = PATTERN_LIB_DATA.matcher(libData);
                        if (m.matches()) {
                            libMap.put(libName, new String[]{m.group(1), m.group(2)});
                            continue;
                        }
                        progress.logWarning(String.format("Ignoring library '%1$s', property value has wrong format\n\t%2$s", libName, libData));
                        continue;
                    }
                    progress.logWarning(String.format("Ignoring library '%1$s', missing property value", libName));
                }
            }
            for (Map.Entry entry : libMap.entrySet()) {
                String jarFile = ((String[])entry.getValue())[0];
                String desc = ((String[])entry.getValue())[1];
                Library lib = sdkFactory.createLibraryType();
                lib.setName((String)entry.getKey());
                lib.setPackagePath(packageLocation);
                lib.setDescription(desc);
                lib.setLocalJarPath(jarFile);
                lib.setManifestEntryRequired(true);
                result.add(lib);
            }
        }
        return result;
    }

    public static String getLegacyPath(IPkgDesc desc, String relativeInstallPath) {
        switch (desc.getType()) {
            case PKG_TOOLS: {
                return "tools";
            }
            case PKG_PLATFORM_TOOLS: {
                return "platform-tools";
            }
            case PKG_BUILD_TOOLS: {
                return DetailsTypes.getBuildToolsPath(desc.getRevision());
            }
            case PKG_DOC: {
                return "docs";
            }
            case PKG_PLATFORM: {
                return DetailsTypes.getPlatformPath(desc.getAndroidVersion());
            }
            case PKG_ADDON: {
                return DetailsTypes.getAddonPath(desc.getVendor(), desc.getAndroidVersion(), desc.getName());
            }
            case PKG_SYS_IMAGE: 
            case PKG_ADDON_SYS_IMAGE: {
                return DetailsTypes.getSysImgPath(desc.getVendor(), desc.getAndroidVersion(), desc.getTag(), desc.getPath());
            }
            case PKG_SOURCE: {
                return DetailsTypes.getSourcesPath(desc.getAndroidVersion());
            }
            case PKG_EXTRA: {
                String name;
                String path = "extras";
                String vendor = desc.getVendor().getId();
                if (vendor != null && vendor.length() > 0) {
                    path = path + ';' + vendor;
                }
                if ((name = desc.getPath()) != null && name.length() > 0) {
                    path = path + ';' + name;
                }
                return path;
            }
            case PKG_NDK: {
                return "ndk-bundle";
            }
            case PKG_LLDB: {
                return DetailsTypes.getLldbPath(desc.getRevision());
            }
        }
        if (relativeInstallPath != null) {
            return relativeInstallPath.replace(File.separatorChar, ';');
        }
        return "unknown";
    }
}

