/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Resource;
import aQute.lib.io.IO;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class URLResource
implements Resource {
    URL url;
    String extra;
    long size = -1L;

    public URLResource(URL url) {
        this.url = url;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.url.openStream();
    }

    public String toString() {
        return ":" + this.url.getPath() + ":";
    }

    @Override
    public void write(OutputStream out) throws Exception {
        IO.copy(this.openInputStream(), out);
    }

    @Override
    public long lastModified() {
        return -1L;
    }

    @Override
    public String getExtra() {
        return this.extra;
    }

    @Override
    public void setExtra(String extra) {
        this.extra = extra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws Exception {
        if (this.size >= 0L) {
            return this.size;
        }
        try {
            if (this.url.getProtocol().equals("file:")) {
                File file = new File(this.url.getPath());
                if (file.isFile()) {
                    this.size = file.length();
                    return this.size;
                }
            } else {
                URLConnection con = this.url.openConnection();
                if (con instanceof HttpURLConnection) {
                    HttpURLConnection http = (HttpURLConnection)con;
                    http.setRequestMethod("HEAD");
                    http.connect();
                    String l = http.getHeaderField("Content-Length");
                    if (l != null) {
                        this.size = Long.parseLong(l);
                        return this.size;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        InputStream in = this.openInputStream();
        try (DataInputStream din = null;){
            din = new DataInputStream(in);
            long result = din.skipBytes(Integer.MAX_VALUE);
            while (in.read() >= 0) {
                result += (long)din.skipBytes(Integer.MAX_VALUE);
            }
            this.size = result;
        }
        return this.size;
    }
}

