/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.service.reporter.Reporter;
import org.apache.felix.resolver.Logger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class LogReporter
extends Logger
implements LogService {
    private Reporter reporter;

    public LogReporter(Reporter reporter) {
        super(2);
        this.reporter = reporter;
    }

    @Override
    public void log(ServiceReference sr, int level, String message) {
        this.getLevel(level).log(sr, message);
    }

    @Override
    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.getLevel(level).log(sr, message, exception);
    }

    private Silent getLevel(int usedLevel) {
        if (usedLevel <= this.getLogLevel()) {
            switch (usedLevel) {
                case 1: {
                    return new Error();
                }
                case 2: {
                    return new Warning();
                }
            }
            return new Trace();
        }
        return new Silent();
    }

    class Silent {
        Silent() {
        }

        public void log(String message) {
        }

        public void log(String message, Throwable exception) {
        }

        public void log(ServiceReference<?> sr, String message) {
        }

        public void log(ServiceReference<?> sr, String message, Throwable exception) {
        }
    }

    class Trace
    extends Silent {
        Trace() {
        }

        @Override
        public void log(String message) {
            LogReporter.this.reporter.trace("%s", new Object[]{message});
        }

        @Override
        public void log(String message, Throwable exception) {
            LogReporter.this.reporter.trace("%s : %s", new Object[]{message, exception});
        }

        @Override
        public void log(ServiceReference<?> sr, String message) {
            LogReporter.this.reporter.trace("%s (%s)", new Object[]{message, sr});
        }

        @Override
        public void log(ServiceReference<?> sr, String message, Throwable exception) {
            LogReporter.this.reporter.trace("%s : %s (%s)", new Object[]{message, exception, sr});
        }
    }

    class Warning
    extends Silent {
        Warning() {
        }

        @Override
        public void log(String message) {
            LogReporter.this.reporter.warning("%s", new Object[]{message});
        }

        @Override
        public void log(String message, Throwable exception) {
            LogReporter.this.reporter.warning("%s : %s", new Object[]{message, exception});
        }

        @Override
        public void log(ServiceReference<?> sr, String message) {
            LogReporter.this.reporter.warning("%s (%s)", new Object[]{message, sr});
        }

        @Override
        public void log(ServiceReference<?> sr, String message, Throwable exception) {
            LogReporter.this.reporter.warning("%s : %s (%s)", new Object[]{message, exception, sr});
        }
    }

    class Error
    extends Silent {
        Error() {
        }

        @Override
        public void log(String message) {
            LogReporter.this.reporter.error("%s", new Object[]{message});
        }

        @Override
        public void log(String message, Throwable exception) {
            LogReporter.this.reporter.error("%s : %s", new Object[]{message, exception});
        }

        @Override
        public void log(ServiceReference<?> sr, String message) {
            LogReporter.this.reporter.error("%s (%s)", new Object[]{message, sr});
        }

        @Override
        public void log(ServiceReference<?> sr, String message, Throwable exception) {
            LogReporter.this.reporter.error("%s : %s (%s)", new Object[]{message, exception, sr});
        }
    }
}

