/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.model.impl;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;
import org.jetbrains.osgi.jps.model.JpsOsmorcProjectExtension;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.jetbrains.osgi.jps.model.OsmorcJarContentEntry;
import org.jetbrains.osgi.jps.model.OutputPathType;
import org.jetbrains.osgi.jps.model.impl.JpsOsmorcProjectExtensionImpl;
import org.jetbrains.osgi.jps.model.impl.OsmorcModuleExtensionProperties;
import org.jetbrains.osgi.jps.util.OsgiBuildUtil;

public class JpsOsmorcModuleExtensionImpl
extends JpsElementBase<JpsOsmorcModuleExtensionImpl>
implements JpsOsmorcModuleExtension {
    private final OsmorcModuleExtensionProperties myProperties;
    private final NullableLazyValue<File> myDescriptorFile = new NullableLazyValue<File>(){

        protected File compute() {
            if (((JpsOsmorcModuleExtensionImpl)JpsOsmorcModuleExtensionImpl.this).myProperties.myManifestGenerationMode == ManifestGenerationMode.Bnd) {
                return OsgiBuildUtil.findFileInModuleContentRoots(JpsOsmorcModuleExtensionImpl.this.getModule(), JpsOsmorcModuleExtensionImpl.this.getBndFileLocation());
            }
            if (((JpsOsmorcModuleExtensionImpl)JpsOsmorcModuleExtensionImpl.this).myProperties.myManifestGenerationMode == ManifestGenerationMode.Bundlor) {
                return OsgiBuildUtil.findFileInModuleContentRoots(JpsOsmorcModuleExtensionImpl.this.getModule(), JpsOsmorcModuleExtensionImpl.this.getBundlorFileLocation());
            }
            if (((JpsOsmorcModuleExtensionImpl)JpsOsmorcModuleExtensionImpl.this).myProperties.myManifestGenerationMode == ManifestGenerationMode.Manually) {
                return OsgiBuildUtil.findFileInModuleContentRoots(JpsOsmorcModuleExtensionImpl.this.getModule(), JpsOsmorcModuleExtensionImpl.this.getManifestLocation());
            }
            return null;
        }
    };

    public JpsOsmorcModuleExtensionImpl(OsmorcModuleExtensionProperties properties) {
        this.myProperties = properties;
    }

    public OsmorcModuleExtensionProperties getProperties() {
        return this.myProperties;
    }

    @NotNull
    public JpsOsmorcModuleExtensionImpl createCopy() {
        JpsOsmorcModuleExtensionImpl jpsOsmorcModuleExtensionImpl = new JpsOsmorcModuleExtensionImpl((OsmorcModuleExtensionProperties)XmlSerializerUtil.createCopy((Object)this.myProperties));
        if (jpsOsmorcModuleExtensionImpl == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(0);
        }
        return jpsOsmorcModuleExtensionImpl;
    }

    public void applyChanges(@NotNull JpsOsmorcModuleExtensionImpl modified) {
        if (modified == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)modified.myProperties, (Object)this.myProperties);
    }

    @Override
    @NotNull
    public String getJarFileLocation() {
        String nullSafeLocation;
        String jarFileLocation = this.myProperties.myJarFileLocation;
        OutputPathType outputPathType = this.myProperties.myOutputPathType;
        String string = nullSafeLocation = jarFileLocation != null ? jarFileLocation : "";
        if (outputPathType == null) {
            String string2 = nullSafeLocation;
            if (string2 == null) {
                JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(2);
            }
            return string2;
        }
        switch (outputPathType) {
            case CompilerOutputPath: {
                File outputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(this.getModule(), false);
                String string3 = outputDir != null ? new File(outputDir.getParent(), nullSafeLocation).getAbsolutePath() : nullSafeLocation;
                if (string3 == null) {
                    JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(3);
                }
                return string3;
            }
            case OsgiOutputPath: {
                String bundlesOutputPath;
                JpsOsmorcProjectExtension projectExtension = this.getProjectExtension();
                if (projectExtension != null && !StringUtil.isEmptyOrSpaces((String)(bundlesOutputPath = projectExtension.getBundlesOutputPath()))) {
                    String string4 = bundlesOutputPath + "/" + nullSafeLocation;
                    if (string4 == null) {
                        JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(4);
                    }
                    return string4;
                }
                String string5 = JpsOsmorcProjectExtensionImpl.getDefaultBundlesOutputPath(this.getModule().getProject()) + "/" + nullSafeLocation;
                if (string5 == null) {
                    JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(5);
                }
                return string5;
            }
        }
        String string6 = nullSafeLocation;
        if (string6 == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(6);
        }
        return string6;
    }

    @Override
    @Nullable
    public File getBundleDescriptorFile() {
        return (File)this.myDescriptorFile.getValue();
    }

    @Override
    public boolean isUseBndFile() {
        return this.myProperties.myManifestGenerationMode == ManifestGenerationMode.Bnd;
    }

    @Override
    public boolean isUseBundlorFile() {
        return this.myProperties.myManifestGenerationMode == ManifestGenerationMode.Bundlor;
    }

    @Override
    public boolean isManifestManuallyEdited() {
        return this.myProperties.myManifestGenerationMode == ManifestGenerationMode.Manually;
    }

    @Override
    public boolean isOsmorcControlsManifest() {
        return this.myProperties.myManifestGenerationMode == ManifestGenerationMode.OsmorcControlled;
    }

    @Override
    @NotNull
    public String getBndFileLocation() {
        String string = StringUtil.notNullize((String)this.myProperties.myBndFileLocation);
        if (string == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public Map<String, String> getAdditionalProperties() {
        Map<String, String> map = Collections.unmodifiableMap(this.myProperties.myAdditionalProperties);
        if (map == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(8);
        }
        return map;
    }

    @Override
    @NotNull
    public String getBundleSymbolicName() {
        String string = StringUtil.notNullize((String)this.myProperties.myBundleSymbolicName);
        if (string == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getBundleVersion() {
        String string = StringUtil.notNullize((String)this.myProperties.myBundleVersion, (String)"1.0.0");
        if (string == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    public String getBundleActivator() {
        return this.myProperties.myBundleActivator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public File getManifestFile() {
        if (!this.isOsmorcControlsManifest()) {
            if (!this.isManifestManuallyEdited()) return null;
            return OsgiBuildUtil.findFileInModuleContentRoots(this.getModule(), this.getManifestLocation());
        }
        String pathToJar = this.getJarFileLocation();
        if (pathToJar.isEmpty()) {
            return null;
        }
        File jarFile = new File(pathToJar);
        if (!jarFile.exists()) {
            return null;
        }
        try (JarFile jar = new JarFile(jarFile);){
            JarEntry manifestEntry = jar.getJarEntry("META-INF/MANIFEST.MF");
            if (manifestEntry == null) {
                File file = null;
                return file;
            }
            File file = new File(jarFile, manifestEntry.getName());
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getManifestLocation() {
        if (this.myProperties.myUseProjectDefaultManifestFileLocation) {
            JpsOsmorcProjectExtension projectExtension = this.getProjectExtension();
            String string = projectExtension == null ? "META-INF/MANIFEST.MF" : projectExtension.getDefaultManifestFileLocation();
            if (string == null) {
                JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)this.myProperties.myManifestLocation);
        if (string == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public boolean isAlwaysRebuildBundleJar() {
        return this.myProperties.myAlwaysRebuildBundleJar;
    }

    @Override
    @NotNull
    public List<OsmorcJarContentEntry> getAdditionalJarContents() {
        List<OsmorcJarContentEntry> list = Collections.unmodifiableList(this.myProperties.myAdditionalJARContents);
        if (list == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @Nullable
    public String getIgnoreFilePattern() {
        return this.myProperties.myIgnoreFilePattern;
    }

    @Override
    @NotNull
    public String getBundlorFileLocation() {
        String string = StringUtil.notNullize((String)this.myProperties.myBundlorFileLocation);
        if (string == null) {
            JpsOsmorcModuleExtensionImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    private JpsModule getModule() {
        return (JpsModule)this.getParent();
    }

    private JpsOsmorcProjectExtension getProjectExtension() {
        return JpsOsmorcExtensionService.getExtension(this.getModule().getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFileLocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBndFileLocation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProperties";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleSymbolicName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleVersion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getManifestLocation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalJarContents";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundlorFileLocation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

