/*
 * Decompiled with CFR 0.152.
 */
package aQute.service.library;

import aQute.service.library.LibraryVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LibraryVersionRange {
    LibraryVersion high;
    LibraryVersion low;
    char start = (char)91;
    char end = (char)93;
    static Pattern RANGE = Pattern.compile("(\\(|\\[)\\s*([-\\da-zA-Z._]+)\\s*,\\s*([-\\da-zA-Z._]+)\\s*(\\]|\\))", 32);

    public LibraryVersionRange(String string) {
        string = string.trim();
        Matcher m = RANGE.matcher(string);
        if (m.matches()) {
            this.low = new LibraryVersion(m.group(2));
            this.high = new LibraryVersion(m.group(3));
            this.start = m.group(1).charAt(0);
            this.end = m.group(4).charAt(0);
            if (this.low.compareTo(this.high) > 0) {
                throw new IllegalArgumentException("Low Range is higher than High Range: " + this.low + "-" + this.high);
            }
        } else {
            this.high = this.low = new LibraryVersion(string);
        }
    }

    public boolean isRange() {
        return this.high != this.low;
    }

    public boolean includeLow() {
        return this.start == '[';
    }

    public boolean includeHigh() {
        return this.end == ']';
    }

    public String toString() {
        if (this.high == this.low) {
            return this.high.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.start);
        sb.append(this.low);
        sb.append(',');
        sb.append(this.high);
        sb.append(this.end);
        return sb.toString();
    }

    public LibraryVersion getLow() {
        return this.low;
    }

    public LibraryVersion getHigh() {
        return this.high;
    }

    public boolean includes(LibraryVersion v) {
        if (!this.isRange()) {
            return this.low.compareTo(v) <= 0;
        }
        if (this.includeLow() ? v.compareTo(this.low) < 0 : v.compareTo(this.low) <= 0) {
            return false;
        }
        return !(this.includeHigh() ? v.compareTo(this.high) > 0 : v.compareTo(this.high) >= 0);
    }

    public List<LibraryVersion> filter(Iterable<LibraryVersion> versions) {
        ArrayList<LibraryVersion> list = new ArrayList<LibraryVersion>();
        for (LibraryVersion v : versions) {
            if (!this.includes(v)) continue;
            list.add(v);
        }
        return list;
    }
}

