/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc.impl;

import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.JpsFlexDependencies;
import com.intellij.flex.model.bc.JpsFlexDependencyEntry;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.impl.JpsFlexBCDependencyEntryImpl;
import com.intellij.flex.model.bc.impl.JpsModuleLibraryDependencyEntryImpl;
import com.intellij.flex.model.bc.impl.JpsSharedLibraryDependencyEntryImpl;
import com.intellij.flex.model.sdk.JpsFlexSdkType;
import com.intellij.flex.model.sdk.JpsFlexmojosSdkProperties;
import com.intellij.flex.model.sdk.JpsFlexmojosSdkType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.impl.JpsSdkReferenceRole;

class JpsFlexDependenciesImpl
extends JpsCompositeElementBase<JpsFlexDependenciesImpl>
implements JpsFlexDependencies {
    static final JpsFlexDependenciesRole ROLE = new JpsFlexDependenciesRole();
    private static final JpsSdkReferenceRole<JpsDummyElement> FLEX_SDK_REF_ROLE = new JpsSdkReferenceRole((JpsSdkType)JpsFlexSdkType.INSTANCE);
    private static final JpsSdkReferenceRole<JpsSimpleElement<JpsFlexmojosSdkProperties>> FLEXMOJOS_SDK_REF_ROLE = new JpsSdkReferenceRole((JpsSdkType)JpsFlexmojosSdkType.INSTANCE);
    private static final JpsElementChildRoleBase<JpsFlexDependencyEntry> ENTRY_ROLE = JpsElementChildRoleBase.create((String)"flex dependency entry");
    private static final JpsElementCollectionRole<JpsFlexDependencyEntry> ENTRIES_ROLE = JpsElementCollectionRole.create(ENTRY_ROLE);
    private static final LinkageType DEFAULT_FRAMEWORK_LINKAGE = LinkageType.Default;
    @NotNull
    private String myTargetPlayer = "";
    @NotNull
    private ComponentSet myComponentSet = ComponentSet.SparkAndMx;
    @NotNull
    private LinkageType myFrameworkLinkage = DEFAULT_FRAMEWORK_LINKAGE;

    private JpsFlexDependenciesImpl() {
        this.myContainer.setChild(ENTRIES_ROLE);
    }

    private JpsFlexDependenciesImpl(JpsFlexDependenciesImpl original) {
        super((JpsCompositeElementBase)original);
        this.myTargetPlayer = original.myTargetPlayer;
        this.myComponentSet = original.myComponentSet;
        this.myFrameworkLinkage = original.myFrameworkLinkage;
    }

    @NotNull
    public JpsFlexDependenciesImpl createCopy() {
        JpsFlexDependenciesImpl jpsFlexDependenciesImpl = new JpsFlexDependenciesImpl(this);
        if (jpsFlexDependenciesImpl == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(0);
        }
        return jpsFlexDependenciesImpl;
    }

    public void applyChanges(@NotNull JpsFlexDependenciesImpl modified) {
        if (modified == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(1);
        }
        super.applyChanges((JpsCompositeElementBase)modified);
        this.setTargetPlayer(modified.getTargetPlayer());
        this.setComponentSet(modified.getComponentSet());
        this.setFrameworkLinkage(modified.getFrameworkLinkage());
    }

    @Override
    @Nullable
    public JpsSdk<?> getSdk() {
        JpsTypedLibrary resolve;
        JpsTypedLibrary resolve2;
        JpsSdkReference flexSdkReference = (JpsSdkReference)this.myContainer.getChild(FLEX_SDK_REF_ROLE);
        if (flexSdkReference != null && (resolve2 = (JpsTypedLibrary)flexSdkReference.resolve()) != null) {
            return (JpsSdk)resolve2.getProperties();
        }
        JpsSdkReference flexmojosSdkReference = (JpsSdkReference)this.myContainer.getChild(FLEXMOJOS_SDK_REF_ROLE);
        if (flexmojosSdkReference != null && (resolve = (JpsTypedLibrary)flexmojosSdkReference.resolve()) != null) {
            return (JpsSdk)resolve.getProperties();
        }
        return null;
    }

    @Override
    @NotNull
    public String getTargetPlayer() {
        String string = this.myTargetPlayer;
        if (string == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void setTargetPlayer(@NotNull String targetPlayer) {
        if (targetPlayer == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(3);
        }
        this.myTargetPlayer = targetPlayer;
    }

    @Override
    @NotNull
    public ComponentSet getComponentSet() {
        ComponentSet componentSet = this.myComponentSet;
        if (componentSet == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(4);
        }
        return componentSet;
    }

    @Override
    public void setComponentSet(@NotNull ComponentSet componentSet) {
        if (componentSet == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(5);
        }
        this.myComponentSet = componentSet;
    }

    @Override
    @NotNull
    public LinkageType getFrameworkLinkage() {
        LinkageType linkageType = this.myFrameworkLinkage;
        if (linkageType == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(6);
        }
        return linkageType;
    }

    @Override
    public void setFrameworkLinkage(@NotNull LinkageType frameworkLinkage) {
        if (frameworkLinkage == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(7);
        }
        this.myFrameworkLinkage = frameworkLinkage;
    }

    @Override
    @NotNull
    public List<JpsFlexDependencyEntry> getEntries() {
        List list = ((JpsElementCollection)this.myContainer.getChild(ENTRIES_ROLE)).getElements();
        if (list == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    State getState() {
        State state = new State();
        JpsSdkReference flexSdkReference = (JpsSdkReference)this.myContainer.getChild(FLEX_SDK_REF_ROLE);
        JpsSdkReference flexmojosSdkReference = (JpsSdkReference)this.myContainer.getChild(FLEXMOJOS_SDK_REF_ROLE);
        if (flexSdkReference != null && flexmojosSdkReference != null) {
            state.SDK.mySdkName = flexSdkReference.getSdkName();
        }
        state.TARGET_PLAYER = this.myTargetPlayer;
        state.COMPONENT_SET = this.myComponentSet;
        state.FRAMEWORK_LINKAGE = this.myFrameworkLinkage.getSerializedText();
        return state;
    }

    void loadState(@NotNull State state) {
        if (state == null) {
            JpsFlexDependenciesImpl.$$$reportNull$$$0(9);
        }
        if (state.SDK != null && !StringUtil.isEmpty((String)state.SDK.mySdkName)) {
            this.myContainer.setChild(FLEX_SDK_REF_ROLE, (JpsElement)JpsElementFactory.getInstance().createSdkReference(state.SDK.mySdkName, (JpsSdkType)JpsFlexSdkType.INSTANCE));
            this.myContainer.setChild(FLEXMOJOS_SDK_REF_ROLE, (JpsElement)JpsElementFactory.getInstance().createSdkReference(state.SDK.mySdkName, (JpsSdkType)JpsFlexmojosSdkType.INSTANCE));
        }
        this.myTargetPlayer = state.TARGET_PLAYER;
        this.myComponentSet = state.COMPONENT_SET;
        this.myFrameworkLinkage = LinkageType.valueOf(state.FRAMEWORK_LINKAGE, DEFAULT_FRAMEWORK_LINKAGE);
        JpsElementCollection entries = (JpsElementCollection)this.myContainer.getChild(ENTRIES_ROLE);
        assert (entries.getElements().size() == 0);
        for (State.EntryState entryState : state.ENTRIES) {
            LinkageType linkageType = LinkageType.valueOf(entryState.DEPENDENCY_TYPE.LINKAGE_TYPE, DEFAULT_FRAMEWORK_LINKAGE);
            if (entryState.LIBRARY_ID != null) {
                entries.addChild((JpsElement)new JpsModuleLibraryDependencyEntryImpl(entryState.LIBRARY_ID, linkageType));
                continue;
            }
            if (entryState.LIBRARY_NAME != null) {
                entries.addChild((JpsElement)new JpsSharedLibraryDependencyEntryImpl(entryState.LIBRARY_NAME, entryState.LIBRARY_LEVEL, linkageType));
                continue;
            }
            if (entryState.BC_NAME != null) {
                entries.addChild((JpsElement)new JpsFlexBCDependencyEntryImpl(entryState.MODULE_NAME, entryState.BC_NAME, linkageType));
                continue;
            }
            assert (false) : "unknown entry " + entryState;
        }
    }

    static /* synthetic */ LinkageType access$100() {
        return DEFAULT_FRAMEWORK_LINKAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/flex/model/bc/impl/JpsFlexDependenciesImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPlayer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkLinkage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/flex/model/bc/impl/JpsFlexDependenciesImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlayer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentSet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkLinkage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTargetPlayer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setComponentSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkLinkage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="dependencies")
    public static class State {
        @Property(surroundWithTag=false)
        public SdkState SDK = new SdkState();
        @Attribute(value="target-player")
        public String TARGET_PLAYER = "";
        @Attribute(value="component-set")
        public ComponentSet COMPONENT_SET = ComponentSet.SparkAndMx;
        @Attribute(value="framework-linkage")
        public String FRAMEWORK_LINKAGE = JpsFlexDependenciesImpl.access$100().getSerializedText();
        @Tag(value="entries")
        @AbstractCollection(surroundWithTag=false)
        public EntryState[] ENTRIES = new EntryState[0];

        @Tag(value="dependency")
        public static class DependencyTypeState {
            @Attribute(value="linkage")
            public String LINKAGE_TYPE;
        }

        @Tag(value="entry")
        public static class EntryState {
            @Attribute(value="module-name")
            public String MODULE_NAME;
            @Attribute(value="build-configuration-name")
            public String BC_NAME;
            @Attribute(value="library-id")
            public String LIBRARY_ID;
            @Attribute(value="library-name")
            public String LIBRARY_NAME;
            @Attribute(value="library-level")
            public String LIBRARY_LEVEL;
            @Property(surroundWithTag=false)
            public DependencyTypeState DEPENDENCY_TYPE;
        }

        @Tag(value="sdk")
        public static class SdkState {
            @Attribute(value="name")
            public String mySdkName;
        }
    }

    private static class JpsFlexDependenciesRole
    extends JpsElementChildRoleBase<JpsFlexDependencies>
    implements JpsElementCreator<JpsFlexDependencies> {
        public JpsFlexDependenciesRole() {
            super("flex dependencies");
        }

        @NotNull
        public JpsFlexDependencies create() {
            JpsFlexDependenciesImpl jpsFlexDependenciesImpl = new JpsFlexDependenciesImpl();
            if (jpsFlexDependenciesImpl == null) {
                JpsFlexDependenciesRole.$$$reportNull$$$0(0);
            }
            return jpsFlexDependenciesImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexDependenciesImpl$JpsFlexDependenciesRole", "create"));
        }
    }
}

