/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.parser.manifest.internal;

import com.springsource.util.parser.manifest.internal.Token;
import com.springsource.util.parser.manifest.internal.TokenKind;

public final class ManifestToken
implements Token {
    private static final String COLON_VALUE = ":";
    private static final String NEWLINE_VALUE = "\\n";
    private String value;
    private TokenKind kind;
    private int startoffset;
    private int endoffset;

    public static ManifestToken makeName(char[] value, int start, int end) {
        return new ManifestToken(new String(value), TokenKind.NAME, start, end);
    }

    public static ManifestToken makeValue(char[] value, int start, int end) {
        return new ManifestToken(new String(value), TokenKind.VALUE, start, end);
    }

    public static ManifestToken makeColon(int start, int end) {
        return new ManifestToken(COLON_VALUE, TokenKind.COLON, start, end);
    }

    public static Token makeNewline(int start, int end) {
        return new ManifestToken(NEWLINE_VALUE, TokenKind.NEWLINE, start, end);
    }

    private ManifestToken(String value, TokenKind kind, int start, int end) {
        this.value = value;
        this.kind = kind;
        this.startoffset = start;
        this.endoffset = end;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("'").append(this.value).append("'");
        s.append("@").append(this.startoffset).append(COLON_VALUE).append(this.endoffset);
        return s.toString();
    }

    public TokenKind getKind() {
        return this.kind;
    }

    public int getEndOffset() {
        return this.endoffset;
    }

    public int getStartOffset() {
        return this.startoffset;
    }
}

