/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository;

import aQute.bnd.deployer.repository.AbstractIndexedRepo;
import aQute.bnd.deployer.repository.RepoConstants;
import aQute.bnd.service.Actionable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FixedIndexedRepo
extends AbstractIndexedRepo
implements Actionable {
    private static final String EMPTY_LOCATION = "";
    public static final String PROP_LOCATIONS = "locations";
    public static final String PROP_CACHE = "cache";
    private String locations;
    protected File cacheDir = new File(System.getProperty("user.home") + File.separator + RepoConstants.DEFAULT_CACHE_DIR);

    @Override
    public synchronized void setProperties(Map<String, String> map) {
        super.setProperties(map);
        this.locations = map.get(PROP_LOCATIONS);
        String cachePath = map.get(PROP_CACHE);
        if (cachePath != null) {
            this.cacheDir = new File(cachePath);
            if (!this.cacheDir.isDirectory()) {
                try {
                    throw new IllegalArgumentException(String.format("Cache path '%s' does not exist, or is not a directory.", this.cacheDir.getCanonicalPath()));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not get cacheDir canonical path", e);
                }
            }
        }
    }

    @Override
    protected List<URI> loadIndexes() throws Exception {
        List<URI> result;
        try {
            result = this.locations != null ? FixedIndexedRepo.parseLocations(this.locations) : Collections.emptyList();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Invalid location, unable to parse as URL list: %s", this.locations), e);
        }
        return result;
    }

    public synchronized File getCacheDirectory() {
        return this.cacheDir;
    }

    public void setCacheDirectory(File cacheDir) {
        if (cacheDir == null) {
            throw new IllegalArgumentException("null cache directory not permitted");
        }
        this.cacheDir = cacheDir;
    }

    @Override
    public synchronized String getName() {
        if (this.name != null && !this.name.equals(((Object)((Object)this)).getClass().getName())) {
            return this.name;
        }
        return this.locations;
    }

    public String getLocation() {
        if (this.locations == null) {
            return EMPTY_LOCATION;
        }
        return this.locations.toString();
    }

    public void setLocations(String locations) throws MalformedURLException, URISyntaxException {
        FixedIndexedRepo.parseLocations(locations);
        this.locations = locations;
    }

    public File getRoot() {
        return this.cacheDir;
    }

    public Map<String, Runnable> actions(Object ... target) throws Exception {
        HashMap<String, Runnable> map = new HashMap<String, Runnable>();
        map.put("Refresh", new Runnable(){

            @Override
            public void run() {
                try {
                    FixedIndexedRepo.this.refresh();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return map;
    }

    public String tooltip(Object ... target) throws Exception {
        return null;
    }

    public String title(Object ... target) throws Exception {
        return null;
    }
}

