/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.blint.support.contributors;

import com.springsource.bundlor.blint.support.Validator;
import com.springsource.bundlor.util.BundleManifestUtils;
import com.springsource.util.osgi.VersionRange;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.ImportedPackage;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionedImportsRangeValidator
implements Validator {
    private static final String MESSAGE = "The import of package %s has an unlikely version";

    @Override
    public Set<String> validate(ManifestContents manifest) {
        HashSet<String> warnings = new HashSet<String>();
        BundleManifest bundleManifest = BundleManifestUtils.createBundleManifest(manifest);
        List<ImportedPackage> importedPackages = bundleManifest.getImportPackage().getImportedPackages();
        for (ImportedPackage importedPackage : importedPackages) {
            try {
                VersionRange versionRange = importedPackage.getVersion();
                if (!this.isReversed(versionRange) && !this.isExclusive(versionRange)) continue;
                warnings.add(String.format(MESSAGE, importedPackage.getPackageName()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                warnings.add(String.format(MESSAGE, importedPackage.getPackageName()));
            }
        }
        return warnings;
    }

    private boolean isReversed(VersionRange versionRange) {
        if (versionRange.getCeiling() == null) {
            return false;
        }
        return versionRange.getFloor().compareTo((Object)versionRange.getCeiling()) > 0;
    }

    private boolean isExclusive(VersionRange versionRange) {
        if (versionRange.getFloor().equals((Object)versionRange.getCeiling())) {
            return !versionRange.isFloorInclusive() && !versionRange.isCeilingInclusive();
        }
        return false;
    }
}

