/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.FilterCopyHandler;
import org.jetbrains.jps.maven.compiler.MavenResourceFileProcessor;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceFileFilter;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsModuleOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class MavenWebArtifactRootCopyingHandlerProvider
extends ArtifactRootCopyingHandlerProvider {
    private static final Logger LOG = Logger.getInstance(MavenWebArtifactRootCopyingHandlerProvider.class);

    @Nullable
    public FileCopyingHandler createCustomHandler(@NotNull JpsArtifact artifact, @NotNull File root, @NotNull File targetDirectory, @NotNull JpsPackagingElement contextElement, @NotNull JpsModel model, @NotNull BuildDataPaths buildDataPaths) {
        MavenProjectConfiguration projectConfiguration;
        if (artifact == null) {
            MavenWebArtifactRootCopyingHandlerProvider.$$$reportNull$$$0(0);
        }
        if (root == null) {
            MavenWebArtifactRootCopyingHandlerProvider.$$$reportNull$$$0(1);
        }
        if (targetDirectory == null) {
            MavenWebArtifactRootCopyingHandlerProvider.$$$reportNull$$$0(2);
        }
        if (contextElement == null) {
            MavenWebArtifactRootCopyingHandlerProvider.$$$reportNull$$$0(3);
        }
        if (model == null) {
            MavenWebArtifactRootCopyingHandlerProvider.$$$reportNull$$$0(4);
        }
        if (buildDataPaths == null) {
            MavenWebArtifactRootCopyingHandlerProvider.$$$reportNull$$$0(5);
        }
        if ((projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(buildDataPaths)) == null) {
            return null;
        }
        MavenWebArtifactConfiguration artifactResourceConfiguration = projectConfiguration.webArtifactConfigs.get(artifact.getName());
        if (artifactResourceConfiguration == null) {
            return null;
        }
        MavenModuleResourceConfiguration moduleResourceConfiguration = projectConfiguration.moduleConfigurations.get(artifactResourceConfiguration.moduleName);
        if (moduleResourceConfiguration == null) {
            LOG.debug("Maven resource configuration not found for module " + artifactResourceConfiguration.moduleName);
            return null;
        }
        if (contextElement instanceof JpsModuleOutputPackagingElement) {
            if (!FileUtil.namesEqual((String)"classes", (String)root.getName())) {
                return null;
            }
            return new MavenClassesCopyingHandler(root.getParentFile(), artifactResourceConfiguration, moduleResourceConfiguration);
        }
        ResourceRootConfiguration rootConfiguration = artifactResourceConfiguration.getRootConfiguration(root);
        String relativeDirInWar = null;
        if (rootConfiguration == null) {
            if (artifact.getOutputPath() != null && !FileUtil.isAncestor((File)new File(artifactResourceConfiguration.warSourceDirectory), (File)root, (boolean)false) && (relativeDirInWar = FileUtil.getRelativePath((File)new File(artifact.getOutputPath()), (File)targetDirectory)) == null) {
                return null;
            }
            ResourceRootConfiguration warRootConfig = MavenWebArtifactRootCopyingHandlerProvider.getWarRootConfig(artifactResourceConfiguration, moduleResourceConfiguration);
            warRootConfig.directory = root.getPath();
            warRootConfig.includes.addAll(artifactResourceConfiguration.warSourceIncludes);
            warRootConfig.excludes.addAll(artifactResourceConfiguration.warSourceExcludes);
            return new MavenWebArtifactCopyingHandler(warRootConfig, moduleResourceConfiguration, relativeDirInWar);
        }
        MavenResourceFileProcessor fileProcessor = new MavenResourceFileProcessor(projectConfiguration, model.getProject(), moduleResourceConfiguration);
        return new MavenWebRootCopyingHandler(fileProcessor, artifactResourceConfiguration, rootConfiguration, moduleResourceConfiguration, root);
    }

    private static ResourceRootConfiguration getWarRootConfig(@NotNull MavenWebArtifactConfiguration artifactConfig, @NotNull MavenModuleResourceConfiguration moduleResourceConfig) {
        if (artifactConfig == null) {
            MavenWebArtifactRootCopyingHandlerProvider.$$$reportNull$$$0(6);
        }
        if (moduleResourceConfig == null) {
            MavenWebArtifactRootCopyingHandlerProvider.$$$reportNull$$$0(7);
        }
        ResourceRootConfiguration rootConfig = new ResourceRootConfiguration();
        rootConfig.directory = artifactConfig.warSourceDirectory;
        rootConfig.targetPath = moduleResourceConfig.outputDirectory;
        rootConfig.includes.addAll(artifactConfig.packagingIncludes);
        rootConfig.excludes.addAll(artifactConfig.packagingExcludes);
        return rootConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDataPaths";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactConfig";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleResourceConfig";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getWarRootConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MavenWebRootCopyingHandler
    extends MavenWebArtifactCopyingHandler {
        private final MavenResourceFileProcessor myFileProcessor;
        @NotNull
        private final ResourceRootConfiguration myRootConfiguration;
        private MavenResourceFileFilter myFileFilter;
        private boolean myMainWebAppRoot;

        private MavenWebRootCopyingHandler(@NotNull MavenResourceFileProcessor fileProcessor, @NotNull MavenWebArtifactConfiguration artifactConfiguration, @NotNull ResourceRootConfiguration rootConfiguration, @NotNull MavenModuleResourceConfiguration moduleResourceConfiguration, @NotNull File root) {
            if (fileProcessor == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(0);
            }
            if (artifactConfiguration == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(1);
            }
            if (rootConfiguration == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(2);
            }
            if (moduleResourceConfiguration == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(3);
            }
            if (root == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(4);
            }
            super(artifactConfiguration, moduleResourceConfiguration, null);
            this.myFileProcessor = fileProcessor;
            this.myRootConfiguration = rootConfiguration;
            this.myFileFilter = new MavenResourceFileFilter(root, this.myRootConfiguration);
            this.myMainWebAppRoot = FileUtil.pathsEqual((String)artifactConfiguration.warSourceDirectory, (String)rootConfiguration.directory);
        }

        public void copyFile(@NotNull File from, @NotNull File to, @NotNull CompileContext context) throws IOException {
            if (from == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(5);
            }
            if (to == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(6);
            }
            if (context == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(7);
            }
            this.myFileProcessor.copyFile(from, to, this.myRootConfiguration, context, this.myMainWebAppRoot ? this.myFileFilter.acceptingWebXml() : FileUtilRt.ALL_FILES);
        }

        @Override
        protected int configurationHash() {
            return this.myRootConfiguration.computeConfigurationHash() + super.configurationHash() * 31;
        }

        @NotNull
        public FileFilter createFileFilter() {
            FileFilter superFilter = super.createFileFilter();
            if (this.myMainWebAppRoot) {
                FileFilter fileFilter = superFilter;
                if (fileFilter == null) {
                    MavenWebRootCopyingHandler.$$$reportNull$$$0(8);
                }
                return fileFilter;
            }
            MavenResourceFileFilter thisFilter = this.myFileFilter.acceptingWebXml();
            FileFilter fileFilter = path -> superFilter.accept(path) && thisFilter.accept(path);
            if (fileFilter == null) {
                MavenWebRootCopyingHandler.$$$reportNull$$$0(9);
            }
            return fileFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactConfiguration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootConfiguration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleResourceConfiguration";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFileFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "copyFile";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MavenClassesCopyingHandler
    extends MavenWebArtifactCopyingHandler {
        private final File myTargetDir;
        private final List<ResourceRootConfiguration> myWebResources;

        public MavenClassesCopyingHandler(@NotNull File targetDir, @NotNull MavenWebArtifactConfiguration artifactConfig, @NotNull MavenModuleResourceConfiguration moduleResourceConfig) {
            if (targetDir == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(0);
            }
            if (artifactConfig == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(1);
            }
            if (moduleResourceConfig == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(2);
            }
            this(targetDir, MavenWebArtifactRootCopyingHandlerProvider.getWarRootConfig(artifactConfig, moduleResourceConfig), MavenClassesCopyingHandler.getWebResources(targetDir, artifactConfig), moduleResourceConfig);
        }

        protected MavenClassesCopyingHandler(@NotNull File targetDir, @NotNull ResourceRootConfiguration warRootConfig, @NotNull List<ResourceRootConfiguration> webResources, @NotNull MavenModuleResourceConfiguration moduleResourceConfig) {
            if (targetDir == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(3);
            }
            if (warRootConfig == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(4);
            }
            if (webResources == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(5);
            }
            if (moduleResourceConfig == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(6);
            }
            super(new ClassesFilter(targetDir, warRootConfig, webResources), warRootConfig, moduleResourceConfig);
            this.myTargetDir = targetDir;
            this.myWebResources = webResources;
        }

        @NotNull
        private static List<ResourceRootConfiguration> getWebResources(@NotNull File targetDir, @NotNull MavenWebArtifactConfiguration artifactConfig) {
            if (targetDir == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(7);
            }
            if (artifactConfig == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(8);
            }
            String webInfClassesPath = FileUtil.toSystemIndependentName((String)new File(targetDir, "WEB-INF" + File.separator + "classes").getPath());
            List result = ContainerUtil.newSmartList();
            for (ResourceRootConfiguration webResource : artifactConfig.webResources) {
                String targetPath;
                if (!webResource.isFiltered || StringUtil.isEmptyOrSpaces((String)(targetPath = webResource.targetPath)) || !webInfClassesPath.equals(targetPath) && !"WEB-INF/classes".equals(StringUtil.trimEnd((String)StringUtil.trimStart((String)targetPath, (String)"/"), (char)'/'))) continue;
                result.add(webResource);
            }
            List list = result;
            if (list == null) {
                MavenClassesCopyingHandler.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Override
        protected int configurationHash() {
            int hash = super.configurationHash();
            hash = 31 * hash + FileUtil.fileHashCode((File)this.myTargetDir);
            for (ResourceRootConfiguration webResource : this.myWebResources) {
                hash = 31 * hash + webResource.includes.hashCode();
                hash = 31 * hash + webResource.excludes.hashCode();
                hash = 31 * hash + webResource.computeConfigurationHash();
            }
            return hash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetDir";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactConfig";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleResourceConfig";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "warRootConfig";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "webResources";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenClassesCopyingHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenClassesCopyingHandler";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWebResources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getWebResources";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ClassesFilter
        extends MavenResourceFileFilter {
            private final File myTargetDir;
            private final Map<ResourceRootConfiguration, FileFilter> myWebResourcesMap;

            public ClassesFilter(@NotNull File targetDir, @NotNull ResourceRootConfiguration warRootConfig, @NotNull List<ResourceRootConfiguration> webResources) {
                if (targetDir == null) {
                    ClassesFilter.$$$reportNull$$$0(0);
                }
                if (warRootConfig == null) {
                    ClassesFilter.$$$reportNull$$$0(1);
                }
                if (webResources == null) {
                    ClassesFilter.$$$reportNull$$$0(2);
                }
                super(targetDir, warRootConfig);
                this.myWebResourcesMap = ContainerUtil.newHashMap();
                this.myTargetDir = targetDir;
                for (ResourceRootConfiguration webResource : webResources) {
                    MavenResourceFileFilter filter = new MavenResourceFileFilter(new File(FileUtil.toSystemDependentName((String)webResource.directory)), webResource);
                    this.myWebResourcesMap.put(webResource, filter);
                }
            }

            @Override
            public boolean accept(@NotNull File file) {
                if (file == null) {
                    ClassesFilter.$$$reportNull$$$0(3);
                }
                for (Map.Entry<ResourceRootConfiguration, FileFilter> entry : this.myWebResourcesMap.entrySet()) {
                    String relPath = FileUtil.getRelativePath((File)new File(this.myTargetDir, "classes"), (File)file);
                    if (relPath == null) {
                        LOG.debug("File " + file.getPath() + " is not under classes directory of " + this.myTargetDir.getPath());
                        continue;
                    }
                    File webResourceFile = new File(FileUtil.toSystemDependentName((String)entry.getKey().directory), relPath);
                    if (!webResourceFile.exists() || !entry.getValue().accept(webResourceFile)) continue;
                    return false;
                }
                String relPath = FileUtil.getRelativePath((File)this.myTargetDir, (File)file);
                return relPath != null && super.accept(new File(this.myTargetDir, "WEB-INF" + File.separator + relPath));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetDir";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "warRootConfig";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "webResources";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenClassesCopyingHandler$ClassesFilter";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "accept";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class MavenWebArtifactCopyingHandler
    extends FilterCopyHandler {
        private final ResourceRootConfiguration myWarRootConfig;
        private final MavenModuleResourceConfiguration myModuleResourceConfig;

        public MavenWebArtifactCopyingHandler(@NotNull MavenWebArtifactConfiguration artifactConfig, @NotNull MavenModuleResourceConfiguration moduleResourceConfig, @Nullable String relativeDirectoryPath) {
            if (artifactConfig == null) {
                MavenWebArtifactCopyingHandler.$$$reportNull$$$0(0);
            }
            if (moduleResourceConfig == null) {
                MavenWebArtifactCopyingHandler.$$$reportNull$$$0(1);
            }
            this(MavenWebArtifactRootCopyingHandlerProvider.getWarRootConfig(artifactConfig, moduleResourceConfig), moduleResourceConfig, relativeDirectoryPath);
        }

        private MavenWebArtifactCopyingHandler(@NotNull ResourceRootConfiguration warRootConfig, @NotNull MavenModuleResourceConfiguration moduleResourceConfig, @Nullable String relativeDirectoryPath) {
            if (warRootConfig == null) {
                MavenWebArtifactCopyingHandler.$$$reportNull$$$0(2);
            }
            if (moduleResourceConfig == null) {
                MavenWebArtifactCopyingHandler.$$$reportNull$$$0(3);
            }
            this(new MavenResourceFileFilter(new File(FileUtil.toSystemDependentName((String)warRootConfig.directory)), warRootConfig, relativeDirectoryPath).acceptingWebXml(), warRootConfig, moduleResourceConfig);
        }

        protected MavenWebArtifactCopyingHandler(@NotNull FileFilter filter, @NotNull ResourceRootConfiguration warRootConfig, @NotNull MavenModuleResourceConfiguration moduleResourceConfig) {
            if (filter == null) {
                MavenWebArtifactCopyingHandler.$$$reportNull$$$0(4);
            }
            if (warRootConfig == null) {
                MavenWebArtifactCopyingHandler.$$$reportNull$$$0(5);
            }
            if (moduleResourceConfig == null) {
                MavenWebArtifactCopyingHandler.$$$reportNull$$$0(6);
            }
            super(filter);
            this.myWarRootConfig = warRootConfig;
            this.myModuleResourceConfig = moduleResourceConfig;
        }

        public void writeConfiguration(@NotNull PrintWriter out) {
            if (out == null) {
                MavenWebArtifactCopyingHandler.$$$reportNull$$$0(7);
            }
            out.print("maven hash:");
            out.println(this.configurationHash());
        }

        protected int configurationHash() {
            int hash = 0;
            hash = 31 * hash + this.myWarRootConfig.includes.hashCode();
            hash = 31 * hash + this.myWarRootConfig.excludes.hashCode();
            hash = 31 * hash + this.myWarRootConfig.computeConfigurationHash();
            hash = 31 * hash + this.myModuleResourceConfig.computeModuleConfigurationHash();
            return hash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactConfig";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleResourceConfig";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "warRootConfig";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebArtifactCopyingHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

